/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.CompositeConfigurationListener;
import org.logicalcobwebs.proxool.CompositeProxoolListener;
import org.logicalcobwebs.proxool.ConfigurationListenerIF;
import org.logicalcobwebs.proxool.ConnectionListenerIF;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.ConnectionPoolStatisticsIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolListenerIF;
import org.logicalcobwebs.proxool.ProxyFactory;
import org.logicalcobwebs.proxool.ShutdownHook;
import org.logicalcobwebs.proxool.StateListenerIF;
import org.logicalcobwebs.proxool.Version;
import org.logicalcobwebs.proxool.admin.Admin;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.logicalcobwebs.proxool.admin.StatisticsIF;
import org.logicalcobwebs.proxool.admin.StatisticsListenerIF;

public class ProxoolFacade {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ProxoolFacade == null ? (class$org$logicalcobwebs$proxool$ProxoolFacade = ProxoolFacade.class$("org.logicalcobwebs.proxool.ProxoolFacade")) : class$org$logicalcobwebs$proxool$ProxoolFacade);
    private static Map configurators = new HashMap();
    private static CompositeProxoolListener compositeProxoolListener = new CompositeProxoolListener();
    private static boolean versionLogged = false;
    private static Thread shutdownHook;
    private static final boolean MERCIFUL = true;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxoolFacade;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxoolDriver;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;

    public static synchronized String registerConnectionPool(String string, Properties properties) throws ProxoolException {
        return ProxoolFacade.registerConnectionPool(string, properties, true);
    }

    protected static synchronized String registerConnectionPool(String string, Properties properties, boolean bl) throws ProxoolException {
        String string2 = ProxoolFacade.getAlias(string);
        if (!versionLogged) {
            versionLogged = true;
            LOG.info("Proxool " + Version.getVersion());
        }
        try {
            Class.forName((class$org$logicalcobwebs$proxool$ProxoolDriver == null ? (class$org$logicalcobwebs$proxool$ProxoolDriver = ProxoolFacade.class$("org.logicalcobwebs.proxool.ProxoolDriver")) : class$org$logicalcobwebs$proxool$ProxoolDriver).getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.error("Couldn't load " + (class$org$logicalcobwebs$proxool$ProxoolDriver == null ? (class$org$logicalcobwebs$proxool$ProxoolDriver = ProxoolFacade.class$("org.logicalcobwebs.proxool.ProxoolDriver")) : class$org$logicalcobwebs$proxool$ProxoolDriver).getName());
        }
        if (ConnectionPoolManager.getInstance().isPoolExists(string2)) {
            throw new ProxoolException("Attempt to register duplicate pool called '" + string2 + "'");
        }
        ConnectionPoolDefinition connectionPoolDefinition = new ConnectionPoolDefinition(string, properties, bl);
        ProxoolFacade.registerConnectionPool(connectionPoolDefinition);
        return string2;
    }

    protected static void registerConnectionPool(ConnectionPoolDefinition connectionPoolDefinition) throws ProxoolException {
        ConnectionPool connectionPool = ConnectionPoolManager.getInstance().createConnectionPool(connectionPoolDefinition);
        connectionPool.start();
        compositeProxoolListener.onRegistration(connectionPoolDefinition, connectionPoolDefinition.getCompleteInfo());
        if (ProxoolFacade.isConfiguredForJMX(connectionPoolDefinition.getCompleteInfo())) {
            ProxoolFacade.registerForJmx(connectionPoolDefinition.getAlias(), connectionPoolDefinition.getCompleteInfo());
        }
    }

    public static void registerConnectionPool(String string) throws ProxoolException {
        ProxoolFacade.registerConnectionPool(string, null);
    }

    protected static String getAlias(String string) throws ProxoolException {
        String string2 = null;
        String string3 = "proxool.";
        if (string.startsWith("proxool.")) {
            int n = string.indexOf(":");
            string2 = n > -1 ? string.substring("proxool.".length(), n) : string.substring("proxool.".length());
        }
        if (string2 == null || string2.length() == 0) {
            throw new ProxoolException("The URL '" + string + "' is not in the correct form. It should be: 'proxool.alias:driver:url'");
        }
        return string2;
    }

    private static void removeConnectionPool(String string, ConnectionPool connectionPool, int n) {
        String string2 = connectionPool.getDefinition().getAlias();
        if (connectionPool != null) {
            try {
                compositeProxoolListener.onShutdown(string2);
                connectionPool.shutdown(n, string);
            }
            catch (Throwable throwable) {
                LOG.error("Problem trying to shutdown '" + string2 + "' connection pool", throwable);
            }
        }
        connectionPool = null;
    }

    public static void removeConnectionPool(String string, int n) throws ProxoolException {
        ProxoolFacade.removeConnectionPool(Thread.currentThread().getName(), ConnectionPoolManager.getInstance().getConnectionPool(string), n);
    }

    public static void removeAllConnectionPools(int n) {
        ProxoolFacade.shutdown(Thread.currentThread().getName(), n);
    }

    public static void shutdown(int n) {
        ProxoolFacade.shutdown(Thread.currentThread().getName(), n);
    }

    protected static void shutdown(String string, int n) {
        block4: {
            ConnectionPool[] connectionPoolArray = ConnectionPoolManager.getInstance().getConnectionPools();
            for (int i = 0; i < connectionPoolArray.length; ++i) {
                ProxoolFacade.removeConnectionPool(string, connectionPoolArray[i], n);
            }
            try {
                if (shutdownHook != null) {
                    ShutdownHook.remove(shutdownHook);
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Unanticipated error during removal of ShutdownHook. Ignoring it.", throwable);
            }
        }
    }

    public static void removeConnectionPool(String string) throws ProxoolException {
        ProxoolFacade.removeConnectionPool(string, 0);
    }

    public static ConnectionPoolStatisticsIF getConnectionPoolStatistics(String string) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(string);
    }

    public static String getConnectionPoolStatisticsDump(String string) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(string).displayStatistics();
    }

    public static ConnectionPoolDefinitionIF getConnectionPoolDefinition(String string) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(string).getDefinition();
    }

    public static Collection getConnectionInfos(String string) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(string).getConnectionInfos();
    }

    public static void killAllConnections(String string, boolean bl) throws ProxoolException {
        ProxoolFacade.killAllConnections(string, "of thread " + Thread.currentThread().getName(), bl);
    }

    public static void killAllConnections(String string, String string2, boolean bl) throws ProxoolException {
        ConnectionPoolManager.getInstance().getConnectionPool(string).expireAllConnections(string2, bl);
    }

    public static void killAllConnections(String string) throws ProxoolException {
        ProxoolFacade.killAllConnections(string, "of thread " + Thread.currentThread().getName(), true);
    }

    public static void killAllConnections(String string, String string2) throws ProxoolException {
        ProxoolFacade.killAllConnections(string, string2, true);
    }

    public static boolean killConnecton(String string, long l, boolean bl) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(string).expireConnection(l, bl);
    }

    public static void addProxoolListener(ProxoolListenerIF proxoolListenerIF) {
        compositeProxoolListener.addListener(proxoolListenerIF);
    }

    public static boolean removeProxoolListener(ProxoolListenerIF proxoolListenerIF) {
        return compositeProxoolListener.removeListener(proxoolListenerIF);
    }

    public static void setStateListener(String string, StateListenerIF stateListenerIF) throws ProxoolException {
        ProxoolFacade.addStateListener(string, stateListenerIF);
    }

    public static void addStateListener(String string, StateListenerIF stateListenerIF) throws ProxoolException {
        ConnectionPool connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string);
        connectionPool.addStateListener(stateListenerIF);
    }

    public boolean removeStateListener(String string, StateListenerIF stateListenerIF) throws ProxoolException {
        ConnectionPool connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string);
        return connectionPool.removeStateListener(stateListenerIF);
    }

    public static void setConnectionListener(String string, ConnectionListenerIF connectionListenerIF) throws ProxoolException {
        ProxoolFacade.addConnectionListener(string, connectionListenerIF);
    }

    public static void addConnectionListener(String string, ConnectionListenerIF connectionListenerIF) throws ProxoolException {
        ConnectionPool connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string);
        connectionPool.addConnectionListener(connectionListenerIF);
    }

    public static boolean removeConnectionListener(String string, ConnectionListenerIF connectionListenerIF) throws ProxoolException {
        ConnectionPool connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string);
        return connectionPool.removeConnectionListener(connectionListenerIF);
    }

    public static void setConfigurationListener(String string, ConfigurationListenerIF configurationListenerIF) throws ProxoolException {
        ProxoolFacade.addConfigurationListener(string, configurationListenerIF);
    }

    public static void addConfigurationListener(String string, ConfigurationListenerIF configurationListenerIF) throws ProxoolException {
        CompositeConfigurationListener compositeConfigurationListener;
        if (ConnectionPoolManager.getInstance().isPoolExists(string)) {
            compositeConfigurationListener = (CompositeConfigurationListener)configurators.get(string);
            if (compositeConfigurationListener == null) {
                compositeConfigurationListener = new CompositeConfigurationListener();
                configurators.put(string, compositeConfigurationListener);
            }
        } else {
            throw new ProxoolException(ConnectionPoolManager.getInstance().getKnownPools(string));
        }
        compositeConfigurationListener.addListener(configurationListenerIF);
    }

    protected static void definitionUpdated(String string, ConnectionPoolDefinitionIF connectionPoolDefinitionIF, Properties properties, Properties properties2) {
        CompositeConfigurationListener compositeConfigurationListener = (CompositeConfigurationListener)configurators.get(string);
        if (compositeConfigurationListener != null) {
            compositeConfigurationListener.definitionUpdated(connectionPoolDefinitionIF, properties, properties2);
        }
    }

    public static boolean removeConfigurationListener(String string, ConfigurationListenerIF configurationListenerIF) throws ProxoolException {
        boolean bl = false;
        if (ConnectionPoolManager.getInstance().isPoolExists(string)) {
            CompositeConfigurationListener compositeConfigurationListener = (CompositeConfigurationListener)configurators.get(string);
            if (compositeConfigurationListener != null) {
                bl = compositeConfigurationListener.removeListener(configurationListenerIF);
            }
        } else {
            throw new ProxoolException(ConnectionPoolManager.getInstance().getKnownPools(string));
        }
        return bl;
    }

    public static void redefineConnectionPool(String string, Properties properties) throws ProxoolException {
        String string2 = ProxoolFacade.getAlias(string);
        ConnectionPool connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string2);
        ConnectionPoolDefinition connectionPoolDefinition = connectionPool.getDefinition();
        connectionPoolDefinition.redefine(string, properties);
    }

    public static void updateConnectionPool(String string, Properties properties) throws ProxoolException {
        String string2 = ProxoolFacade.getAlias(string);
        ConnectionPool connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string2);
        ConnectionPoolDefinition connectionPoolDefinition = connectionPool.getDefinition();
        connectionPoolDefinition.update(string, properties);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug("Finalising");
    }

    public static Statement getDelegateStatement(Statement statement) throws ProxoolException {
        try {
            return ProxyFactory.getDelegateStatement(statement);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProxoolException("Statement argument is not one provided by Proxool (it's a " + statement.getClass() + ")");
        }
    }

    public static Connection getDelegateConnection(Connection connection) throws ProxoolException {
        try {
            return ProxyFactory.getDelegateConnection(connection);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProxoolException("Connection argument is not one provided by Proxool (it's a " + connection.getClass() + ")");
        }
    }

    public static String[] getAliases() {
        return ConnectionPoolManager.getInstance().getConnectionPoolNames();
    }

    public static StatisticsIF getStatistics(String string, String string2) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(string).getAdmin().getStatistics(string2);
    }

    public static StatisticsIF[] getStatistics(String string) throws ProxoolException {
        Admin admin = ConnectionPoolManager.getInstance().getConnectionPool(string).getAdmin();
        if (admin != null) {
            return admin.getStatistics();
        }
        return new StatisticsIF[0];
    }

    public static void addStatisticsListener(String string, StatisticsListenerIF statisticsListenerIF) throws ProxoolException {
        Admin admin = ConnectionPoolManager.getInstance().getConnectionPool(string).getAdmin();
        if (admin == null) {
            throw new ProxoolException("Statistics are switched off, your can't add a listener");
        }
        admin.addStatisticsListener(statisticsListenerIF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnapshotIF getSnapshot(String string, boolean bl) throws ProxoolException {
        SnapshotIF snapshotIF = null;
        ConnectionPool connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string);
        if (bl) {
            try {
                connectionPool.acquireConnectionStatusReadLock();
                LOG.debug("Starting snapshot");
                snapshotIF = Admin.getSnapshot(connectionPool, connectionPool.getDefinition(), connectionPool.getConnectionInfos());
                LOG.debug("Finishing snapshot");
            }
            finally {
                connectionPool.releaseConnectionStatusReadLock();
            }
        } else {
            snapshotIF = Admin.getSnapshot(connectionPool, connectionPool.getDefinition(), null);
        }
        return snapshotIF;
    }

    public static SnapshotIF getSnapshot(String string) throws ProxoolException {
        return ProxoolFacade.getSnapshot(string, false);
    }

    private static boolean registerForJmx(String string, Properties properties) {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("org.logicalcobwebs.proxool.admin.jmx.ProxoolJMXHelper");
            Method method = clazz.getDeclaredMethod("registerPool", class$java$lang$String == null ? (class$java$lang$String = ProxoolFacade.class$("java.lang.String")) : class$java$lang$String, class$java$util$Properties == null ? (class$java$util$Properties = ProxoolFacade.class$("java.util.Properties")) : class$java$util$Properties);
            method.invoke(null, string, properties);
            bl = true;
        }
        catch (Exception exception) {
            LOG.error("JMX registration of " + string + " pool failed.", exception);
        }
        return bl;
    }

    private static boolean isConfiguredForJMX(Properties properties) {
        String string = properties.getProperty("proxool.jmx");
        return string != null && string.equalsIgnoreCase("true");
    }

    protected static void setShutdownHook(Thread thread) {
        shutdownHook = thread;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

