/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.FatalSqlExceptionHelper;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class ProxoolDriver
implements Driver {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ProxoolDriver == null ? (class$org$logicalcobwebs$proxool$ProxoolDriver = ProxoolDriver.class$("org.logicalcobwebs.proxool.ProxoolDriver")) : class$org$logicalcobwebs$proxool$ProxoolDriver);
    private static final ResourceBundle ATTRIBUTE_DESCRIPTIONS_RESOURCE;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxoolDriver;

    private static ResourceBundle createAttributeDescriptionsResource() {
        try {
            return ResourceBundle.getBundle("org.logicalcobwebs.proxool.resources.attributeDescriptions");
        }
        catch (Exception exception) {
            LOG.error("Could not find resource org.logicalcobwebs.proxool.resources.attributeDescriptions", exception);
            return null;
        }
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!string.startsWith("proxool")) {
            return null;
        }
        ConnectionPool connectionPool = null;
        try {
            String string2 = ProxoolFacade.getAlias(string);
            if (!ConnectionPoolManager.getInstance().isPoolExists(string2)) {
                ProxoolFacade.registerConnectionPool(string, properties, false);
                connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string2);
            } else if (properties != null && properties.size() > 0) {
                connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string2);
                ConnectionPoolDefinition connectionPoolDefinition = connectionPool.getDefinition();
                if (!connectionPoolDefinition.isEqual(string, properties)) {
                    connectionPoolDefinition.redefine(string, properties);
                }
            } else {
                connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string2);
            }
            return connectionPool.getConnection();
        }
        catch (SQLException sQLException) {
            LOG.error("Problem", sQLException);
            try {
                String string3 = ProxoolFacade.getAlias(string);
                connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string3);
                if (FatalSqlExceptionHelper.testException(connectionPool.getDefinition(), sQLException)) {
                    FatalSqlExceptionHelper.throwFatalSQLException(connectionPool.getDefinition().getFatalSqlExceptionWrapper(), sQLException);
                }
                throw sQLException;
            }
            catch (ProxoolException proxoolException) {
                LOG.error("Problem", sQLException);
                throw new SQLException(sQLException.toString());
            }
        }
        catch (ProxoolException proxoolException) {
            LOG.error("Problem", proxoolException);
            throw new SQLException(proxoolException.toString());
        }
    }

    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith("proxool");
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[18];
        ConnectionPool connectionPool = null;
        try {
            connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string);
        }
        catch (ProxoolException proxoolException) {
            throw new SQLException(proxoolException.toString());
        }
        ConnectionPoolDefinition connectionPoolDefinition = connectionPool.getDefinition();
        driverPropertyInfoArray[0] = this.buildDriverPropertyInfo("proxool.driver", String.valueOf(connectionPoolDefinition.getDriver()));
        driverPropertyInfoArray[1] = this.buildDriverPropertyInfo("proxool.url", String.valueOf(connectionPoolDefinition.getUrl()));
        driverPropertyInfoArray[2] = this.buildDriverPropertyInfo("proxool.minimum-connection-count", String.valueOf(connectionPoolDefinition.getMinimumConnectionCount()));
        driverPropertyInfoArray[3] = this.buildDriverPropertyInfo("proxool.maximum-connection-count", String.valueOf(connectionPoolDefinition.getMaximumConnectionCount()));
        driverPropertyInfoArray[4] = this.buildDriverPropertyInfo("proxool.maximum-connection-lifetime", String.valueOf(connectionPoolDefinition.getMaximumConnectionLifetime()));
        driverPropertyInfoArray[5] = this.buildDriverPropertyInfo("proxool.maximum-new-connections", String.valueOf(connectionPoolDefinition.getMaximumNewConnections()));
        driverPropertyInfoArray[6] = this.buildDriverPropertyInfo("proxool.prototype-count", String.valueOf(connectionPoolDefinition.getPrototypeCount()));
        driverPropertyInfoArray[7] = this.buildDriverPropertyInfo("proxool.house-keeping-sleep-time", String.valueOf(connectionPoolDefinition.getHouseKeepingSleepTime()));
        driverPropertyInfoArray[8] = this.buildDriverPropertyInfo("proxool.house-keeping-test-sql", connectionPoolDefinition.getHouseKeepingTestSql());
        driverPropertyInfoArray[9] = this.buildDriverPropertyInfo("proxool.recently-started-threshold", String.valueOf(connectionPoolDefinition.getRecentlyStartedThreshold()));
        driverPropertyInfoArray[10] = this.buildDriverPropertyInfo("proxool.overload-without-refusal-lifetime", String.valueOf(connectionPoolDefinition.getOverloadWithoutRefusalLifetime()));
        driverPropertyInfoArray[11] = this.buildDriverPropertyInfo("proxool.maximum-active-time", String.valueOf(connectionPoolDefinition.getMaximumActiveTime()));
        driverPropertyInfoArray[12] = this.buildDriverPropertyInfo("proxool.verbose", String.valueOf(connectionPoolDefinition.isVerbose()));
        driverPropertyInfoArray[13] = this.buildDriverPropertyInfo("proxool.trace", String.valueOf(connectionPoolDefinition.isTrace()));
        driverPropertyInfoArray[14] = this.buildDriverPropertyInfo("proxool.fatal-sql-exception", String.valueOf(connectionPoolDefinition.getFatalSqlExceptions()));
        driverPropertyInfoArray[15] = this.buildDriverPropertyInfo("proxool.fatal-sql-exception", String.valueOf(connectionPoolDefinition.getFatalSqlExceptions()));
        driverPropertyInfoArray[16] = this.buildDriverPropertyInfo("proxool.statistics", String.valueOf(connectionPoolDefinition.getStatistics()));
        driverPropertyInfoArray[17] = this.buildDriverPropertyInfo("proxool.statistics-log-level", String.valueOf(connectionPoolDefinition.getStatisticsLogLevel()));
        return driverPropertyInfoArray;
    }

    private DriverPropertyInfo buildDriverPropertyInfo(String string, String string2) {
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string, ATTRIBUTE_DESCRIPTIONS_RESOURCE.getString(string));
        if (string2 != null) {
            driverPropertyInfo.value = string2;
        }
        return driverPropertyInfo;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new ProxoolDriver());
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.toString());
        }
        ATTRIBUTE_DESCRIPTIONS_RESOURCE = ProxoolDriver.createAttributeDescriptionsResource();
    }
}

