/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.Prototyper;
import org.logicalcobwebs.proxool.PrototyperController;

public class PrototyperThread
extends Thread {
    private static final ThreadGroup PROTOTYPER_THREAD_GROUP = new ThreadGroup("PROTOTYPER_THREAD_GROUP");
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$PrototyperThread == null ? (class$org$logicalcobwebs$proxool$PrototyperThread = PrototyperThread.class$("org.logicalcobwebs.proxool.PrototyperThread")) : class$org$logicalcobwebs$proxool$PrototyperThread);
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$PrototyperThread;

    public PrototyperThread(String string) {
        super(PROTOTYPER_THREAD_GROUP, string);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            int n = 0;
            while (PrototyperController.isKeepSweeping()) {
                PrototyperController.sweepStarted();
                ConnectionPool[] connectionPoolArray = ConnectionPoolManager.getInstance().getConnectionPools();
                for (int i = 0; i < connectionPoolArray.length; ++i) {
                    Prototyper prototyper = connectionPoolArray[i].getPrototyper();
                    try {
                        connectionPoolArray[i].acquirePrimaryReadLock();
                        if (!connectionPoolArray[i].isConnectionPoolUp() || !prototyper.isSweepNeeded()) continue;
                        prototyper.sweep();
                        ++n;
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.error("Couldn't acquire primary read lock", interruptedException);
                        continue;
                    }
                    finally {
                        connectionPoolArray[i].releasePrimaryReadLock();
                    }
                }
            }
            this.doWait();
        }
    }

    private synchronized void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            LOG.debug("Expected interruption of sleep");
        }
    }

    protected synchronized void doNotify() {
        this.notify();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

