/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.SQLException;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.PrototyperThread;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnectionIF;

public class PrototyperController {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$PrototyperController == null ? (class$org$logicalcobwebs$proxool$PrototyperController = PrototyperController.class$("org.logicalcobwebs.proxool.PrototyperController")) : class$org$logicalcobwebs$proxool$PrototyperController);
    private static PrototyperThread prototyperThread = new PrototyperThread("Prototyper");
    private static boolean keepSweeping;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$PrototyperController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void triggerSweep(String string) {
        block12: {
            block11: {
                try {
                    ConnectionPool connectionPool = ConnectionPoolManager.getInstance().getConnectionPool(string);
                    try {
                        connectionPool.acquirePrimaryReadLock();
                        connectionPool.getPrototyper().triggerSweep();
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.error("Couldn't acquire primary read lock", interruptedException);
                    }
                    finally {
                        connectionPool.releasePrimaryReadLock();
                    }
                }
                catch (ProxoolException proxoolException) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("Couldn't trigger prototyper triggerSweep for '" + string + "'  - maybe it's just been shutdown");
                }
            }
            try {
                keepSweeping = true;
                boolean bl = prototyperThread.isAlive();
                prototyperThread.doNotify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                LOG.debug("Hmm", illegalMonitorStateException);
                if (Thread.activeCount() > 10 && LOG.isInfoEnabled()) {
                    LOG.info("Suspicious thread count of " + Thread.activeCount());
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug("Ignoring attempt to prototype whilst already prototyping");
            }
        }
    }

    protected static ProxyConnectionIF buildConnection(String string, int n, String string2) throws SQLException, ProxoolException {
        return PrototyperController.getConnectionPool(string).getPrototyper().buildConnection(n, string2);
    }

    private static ConnectionPool getConnectionPool(String string) throws ProxoolException {
        return ConnectionPoolManager.getInstance().getConnectionPool(string);
    }

    protected static void checkSimultaneousBuildThrottle(String string) throws SQLException, ProxoolException {
        PrototyperController.getConnectionPool(string).getPrototyper().checkSimultaneousBuildThrottle();
    }

    public static void cancel(String string) {
        try {
            PrototyperController.getConnectionPool(string).getPrototyper().cancel();
        }
        catch (ProxoolException proxoolException) {
            LOG.error("Couldn't cancel prototyper", proxoolException);
        }
    }

    protected static void connectionRemoved(String string) {
        try {
            PrototyperController.getConnectionPool(string).getPrototyper().connectionRemoved();
        }
        catch (ProxoolException proxoolException) {
            LOG.debug("Ignoring connection removed from cancelled prototyper");
        }
    }

    public static boolean isKeepSweeping() {
        return keepSweeping;
    }

    public static void sweepStarted() {
        keepSweeping = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        prototyperThread.start();
    }
}

