/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.SQLException;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.AbstractProxyConnection;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.logicalcobwebs.proxool.ProxyFactory;

public class Prototyper {
    private ConnectionPool connectionPool;
    private Log log = LogFactory.getLog(class$org$logicalcobwebs$proxool$Prototyper == null ? (class$org$logicalcobwebs$proxool$Prototyper = Prototyper.class$("org.logicalcobwebs.proxool.Prototyper")) : class$org$logicalcobwebs$proxool$Prototyper);
    private long connectionCount;
    private final Object lock = new Integer(1);
    private boolean sweepNeeded = true;
    private long nextConnectionId = 1L;
    private boolean cancel;
    private int connectionsBeingMade;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$Prototyper;

    public Prototyper(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        this.log = connectionPool.getLog();
    }

    protected boolean isSweepNeeded() {
        return this.sweepNeeded;
    }

    protected void triggerSweep() {
        this.sweepNeeded = true;
    }

    protected boolean sweep() {
        boolean bl = false;
        try {
            while (!this.cancel && this.connectionPool.isConnectionPoolUp()) {
                String string = null;
                if (this.connectionCount >= (long)this.getDefinition().getMaximumConnectionCount()) break;
                if (this.connectionCount < (long)this.getDefinition().getMinimumConnectionCount()) {
                    string = "to achieve minimum of " + this.getDefinition().getMinimumConnectionCount();
                } else {
                    if (this.connectionPool.getAvailableConnectionCount() >= this.getDefinition().getPrototypeCount()) break;
                    string = "to keep " + this.getDefinition().getPrototypeCount() + " available";
                }
                ProxyConnectionIF proxyConnectionIF = null;
                try {
                    if (!this.connectionPool.isConnectionPoolUp()) break;
                    proxyConnectionIF = this.buildConnection(1, string);
                    bl = true;
                }
                catch (Throwable throwable) {
                    this.log.error("Prototype", throwable);
                    break;
                }
                if (proxyConnectionIF != null) continue;
            }
        }
        catch (Throwable throwable) {
            this.log.error("Unexpected error", throwable);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ProxyConnectionIF buildConnection(int n, String string) throws SQLException, ProxoolException {
        long l = 0L;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.connectionCount >= (long)this.getDefinition().getMaximumConnectionCount()) {
                throw new ProxoolException("ConnectionCount is " + this.connectionCount + ". Maximum connection count of " + this.getDefinition().getMaximumConnectionCount() + " cannot be exceeded.");
            }
            this.checkSimultaneousBuildThrottle();
            ++this.connectionsBeingMade;
            ++this.connectionCount;
            l = this.nextConnectionId++;
        }
        object2 = null;
        Connection connection = null;
        try {
            block18: {
                try {
                    object2 = ProxyFactory.buildProxyConnection(l, this.connectionPool, n);
                    connection = ProxyFactory.getConnection((ProxyConnectionIF)object2);
                    try {
                        this.connectionPool.onBirth(connection);
                    }
                    catch (Exception exception) {
                        this.log.error("Problem during onBirth (ignored)", exception);
                    }
                    this.connectionPool.addProxyConnection((ProxyConnectionIF)object2);
                    if (!this.log.isDebugEnabled()) break block18;
                    StringBuffer exception = new StringBuffer(this.connectionPool.displayStatistics());
                    exception.append(" - Connection #");
                    exception.append(((AbstractProxyConnection)object2).getId());
                    if (this.getDefinition().isVerbose()) {
                        exception.append(" (");
                        exception.append(Integer.toHexString(object2.hashCode()));
                        exception.append(")");
                    }
                    exception.append(" created ");
                    exception.append(string);
                    exception.append(" = ");
                    exception.append(ConnectionPool.getStatusDescription(((AbstractProxyConnection)object2).getStatus()));
                    if (this.getDefinition().isVerbose()) {
                        exception.append(" -> ");
                        exception.append(this.getDefinition().getUrl());
                        exception.append(" (");
                        exception.append(Integer.toHexString(((AbstractProxyConnection)object2).getConnection().hashCode()));
                        exception.append(") by thread ");
                        exception.append(Thread.currentThread().getName());
                    }
                    this.log.debug(exception);
                }
                catch (SQLException stringBuffer) {
                    throw stringBuffer;
                }
                catch (RuntimeException sQLException) {
                    if (!this.log.isDebugEnabled()) throw sQLException;
                    this.log.debug("Prototyping problem", sQLException);
                    throw sQLException;
                }
                catch (Throwable runtimeException) {
                    if (!this.log.isDebugEnabled()) throw new ProxoolException("Unexpected prototyping problem", runtimeException);
                    this.log.debug("Prototyping problem", runtimeException);
                    throw new ProxoolException("Unexpected prototyping problem", runtimeException);
                }
            }
            Object var9_11 = null;
            Object object = this.lock;
            synchronized (object) {
                if (object2 == null) {
                    --this.connectionCount;
                }
                --this.connectionsBeingMade;
                return object2;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            Object object = this.lock;
            synchronized (object) {
                if (object2 == null) {
                    --this.connectionCount;
                }
                --this.connectionsBeingMade;
                throw throwable;
            }
        }
    }

    protected void connectionRemoved() {
        --this.connectionCount;
    }

    protected void checkSimultaneousBuildThrottle() throws SQLException {
        if (this.connectionsBeingMade > this.getDefinition().getSimultaneousBuildThrottle()) {
            throw new SQLException("We are already in the process of making " + this.connectionsBeingMade + " connections and the number of simultaneous builds has been throttled to " + this.getDefinition().getSimultaneousBuildThrottle());
        }
    }

    public long getConnectionCount() {
        return this.connectionCount;
    }

    private ConnectionPoolDefinitionIF getDefinition() {
        return this.connectionPool.getDefinition();
    }

    public void cancel() {
        this.cancel = true;
    }

    public String getAlias() {
        return this.getDefinition().getAlias();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

