/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.HouseKeeper;
import org.logicalcobwebs.proxool.HouseKeeperThread;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.util.FastArrayList;

public class HouseKeeperController {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$HouseKeeperController == null ? (class$org$logicalcobwebs$proxool$HouseKeeperController = HouseKeeperController.class$("org.logicalcobwebs.proxool.HouseKeeperController")) : class$org$logicalcobwebs$proxool$HouseKeeperController);
    private static Map houseKeepers = new HashMap();
    private static List houseKeeperList = new FastArrayList();
    private static int houseKeeperIndex = 0;
    private static List houseKeeperThreads = new FastArrayList();
    private static final Object LOCK = new Integer(1);
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$HouseKeeperController;

    private static HouseKeeper getHouseKeeper(String string) throws ProxoolException {
        HouseKeeper houseKeeper = (HouseKeeper)houseKeepers.get(string);
        if (houseKeeper == null) {
            throw new ProxoolException("Tried to use an unregistered house keeper '" + string + "'");
        }
        return houseKeeper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HouseKeeper getHouseKeeperToRun() {
        HouseKeeper houseKeeper = null;
        Object object = LOCK;
        synchronized (object) {
            for (int i = 0; i < houseKeeperList.size(); ++i) {
                if (houseKeeperIndex > houseKeeperList.size() - 1) {
                    houseKeeperIndex = 0;
                }
                HouseKeeper houseKeeper2 = (HouseKeeper)houseKeeperList.get(houseKeeperIndex);
                ++houseKeeperIndex;
                if (!houseKeeper2.isSweepDue()) continue;
                houseKeeper = houseKeeper2;
                break;
            }
        }
        return houseKeeper;
    }

    protected static void sweepNow(String string) {
        try {
            HouseKeeperController.getHouseKeeper(string).sweep();
        }
        catch (ProxoolException proxoolException) {
            LOG.error("Couldn't run house keeper for " + string, proxoolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void register(ConnectionPool connectionPool) {
        String string = connectionPool.getDefinition().getAlias();
        LOG.debug("Registering '" + string + "' house keeper");
        HouseKeeper houseKeeper = new HouseKeeper(connectionPool);
        Object object = LOCK;
        synchronized (object) {
            houseKeepers.put(string, houseKeeper);
            houseKeeperList.add(houseKeeper);
            if (houseKeeperThreads.size() == 0) {
                HouseKeeperThread houseKeeperThread = new HouseKeeperThread("HouseKeeper");
                LOG.debug("Starting a house keeper thread");
                houseKeeperThread.start();
                houseKeeperThreads.add(houseKeeperThread);
            }
        }
    }

    protected static void cancel(String string) throws ProxoolException {
        HouseKeeper houseKeeper = HouseKeeperController.getHouseKeeper(string);
        houseKeepers.remove(string);
        houseKeeperList.remove(houseKeeper);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

