/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.Statement;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.FormatHelper;
import org.logicalcobwebs.proxool.PrototyperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnectionIF;

class HouseKeeper {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$HouseKeeper == null ? (class$org$logicalcobwebs$proxool$HouseKeeper = HouseKeeper.class$("org.logicalcobwebs.proxool.HouseKeeper")) : class$org$logicalcobwebs$proxool$HouseKeeper);
    private ConnectionPool connectionPool;
    private long timeLastSwept;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$HouseKeeper;

    public HouseKeeper(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sweep() throws ProxoolException {
        ConnectionPoolDefinition connectionPoolDefinition;
        block35: {
            connectionPoolDefinition = this.connectionPool.getDefinition();
            Log log = this.connectionPool.getLog();
            Statement statement = null;
            try {
                try {
                    this.connectionPool.acquirePrimaryReadLock();
                    Connection connection = null;
                    ProxyConnectionIF proxyConnectionIF = null;
                    int n = 0;
                    int[] nArray = new int[4];
                    ProxyConnectionIF[] proxyConnectionIFArray = this.connectionPool.getProxyConnections();
                    for (int i = 0; i < proxyConnectionIFArray.length; ++i) {
                        String string;
                        proxyConnectionIF = proxyConnectionIFArray[i];
                        connection = proxyConnectionIF.getConnection();
                        if (!this.connectionPool.isConnectionPoolUp()) break;
                        if (proxyConnectionIF.setStatus(1, 3)) {
                            try {
                                statement = connection.createStatement();
                                if (proxyConnectionIF.isReallyClosed()) {
                                    proxyConnectionIF.setStatus(3, 0);
                                    this.connectionPool.removeProxyConnection(proxyConnectionIF, "it appears to be closed", true, true);
                                }
                                if ((string = connectionPoolDefinition.getHouseKeepingTestSql()) != null && string.length() > 0) {
                                    Object var13_17;
                                    boolean bl = false;
                                    try {
                                        bl = statement.execute(string);
                                        var13_17 = null;
                                        if (log.isDebugEnabled() && connectionPoolDefinition.isVerbose()) {
                                            log.debug(this.connectionPool.displayStatistics() + " - Testing connection " + proxyConnectionIF.getId() + (bl ? ": True" : ": False"));
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var13_17 = null;
                                        if (log.isDebugEnabled() && connectionPoolDefinition.isVerbose()) {
                                            log.debug(this.connectionPool.displayStatistics() + " - Testing connection " + proxyConnectionIF.getId() + (bl ? ": True" : ": False"));
                                        }
                                        throw throwable;
                                    }
                                }
                                proxyConnectionIF.setStatus(3, 1);
                            }
                            catch (Throwable throwable) {
                                proxyConnectionIF.setStatus(3, 0);
                                this.connectionPool.removeProxyConnection(proxyConnectionIF, "it has problems: " + throwable, false, true);
                            }
                            finally {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        if (proxyConnectionIF.getAge() > (long)connectionPoolDefinition.getMaximumConnectionLifetime()) {
                            string = "age is " + proxyConnectionIF.getAge() + "ms";
                            if (proxyConnectionIF.setStatus(1, 3)) {
                                if (proxyConnectionIF.setStatus(3, 0)) {
                                    this.connectionPool.expireProxyConnection(proxyConnectionIF, string, false);
                                }
                            } else {
                                proxyConnectionIF.markForExpiry(string);
                                if (log.isDebugEnabled()) {
                                    log.debug(this.connectionPool.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnectionIF.getId()) + " marked for expiry.");
                                }
                            }
                        }
                        if (proxyConnectionIF.isActive()) {
                            long l = System.currentTimeMillis() - proxyConnectionIF.getTimeLastStartActive();
                            if (l < (long)connectionPoolDefinition.getRecentlyStartedThreshold()) {
                                ++n;
                            }
                            if (l > (long)connectionPoolDefinition.getMaximumActiveTime()) {
                                this.connectionPool.removeProxyConnection(proxyConnectionIF, "it has been active for too long", true, true);
                                log.warn("#" + FormatHelper.formatMediumNumber(proxyConnectionIF.getId()) + " was active for " + l + " milliseconds and has been removed automaticaly. The Thread responsible was named '" + proxyConnectionIF.getRequester() + "'.");
                            }
                        }
                        int n2 = proxyConnectionIF.getStatus();
                        nArray[n2] = nArray[n2] + 1;
                    }
                    this.calculateUpState(n);
                }
                catch (Throwable throwable) {
                    log.error("Housekeeping log.error( :", throwable);
                    Object var17_22 = null;
                    this.connectionPool.releasePrimaryReadLock();
                    this.timeLastSwept = System.currentTimeMillis();
                    if (connectionPoolDefinition.isVerbose() && log.isDebugEnabled()) {
                        log.debug(this.connectionPool.displayStatistics() + " - House keeping triggerSweep done");
                    }
                    break block35;
                }
                Object var17_21 = null;
                this.connectionPool.releasePrimaryReadLock();
            }
            catch (Throwable throwable) {
                Object var17_23 = null;
                this.connectionPool.releasePrimaryReadLock();
                this.timeLastSwept = System.currentTimeMillis();
                if (connectionPoolDefinition.isVerbose() && log.isDebugEnabled()) {
                    log.debug(this.connectionPool.displayStatistics() + " - House keeping triggerSweep done");
                }
                throw throwable;
            }
            this.timeLastSwept = System.currentTimeMillis();
            if (connectionPoolDefinition.isVerbose() && log.isDebugEnabled()) {
                log.debug(this.connectionPool.displayStatistics() + " - House keeping triggerSweep done");
            }
        }
        PrototyperController.triggerSweep(connectionPoolDefinition.getAlias());
    }

    private long getTimeSinceLastSweep() {
        return System.currentTimeMillis() - this.timeLastSwept;
    }

    protected boolean isSweepDue() {
        if (this.connectionPool.isConnectionPoolUp()) {
            return this.getTimeSinceLastSweep() > (long)this.connectionPool.getDefinition().getHouseKeepingSleepTime();
        }
        LOG.warn("House keeper is still being asked to sweep despite the connection pool being down");
        return false;
    }

    private void calculateUpState(int n) {
        try {
            int n2 = 0;
            int n3 = this.connectionPool.getAvailableConnectionCount();
            if (n3 > 0 || n > 0) {
                if (this.connectionPool.getTimeOfLastRefusal() > System.currentTimeMillis() - (long)this.connectionPool.getDefinition().getOverloadWithoutRefusalLifetime()) {
                    n2 = 2;
                } else if (this.connectionPool.getActiveConnectionCount() > 0) {
                    n2 = 1;
                }
            } else {
                n2 = 3;
            }
            this.connectionPool.setUpState(n2);
        }
        catch (Exception exception) {
            LOG.error(exception);
        }
    }

    protected String getAlias() {
        return this.connectionPool.getDefinition().getAlias();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

