/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.logicalcobwebs.logging.Log;

public class ConnectionResetter {
    private Log log;
    private boolean initialised;
    private Map accessorMutatorMap = new HashMap();
    private Map defaultValues = new HashMap();
    protected static final String MUTATOR_PREFIX = "set";
    private String driverName;
    static /* synthetic */ Class class$java$sql$Connection;

    protected ConnectionResetter(Log log, String string) {
        this.log = log;
        this.driverName = string;
        this.addReset("getCatalog", "setCatalog");
        this.addReset("isReadOnly", "setReadOnly");
        this.addReset("getTransactionIsolation", "setTransactionIsolation");
        this.addReset("getTypeMap", "setTypeMap");
        this.addReset("getHoldability", "setHoldability");
    }

    private void addReset(String string, String string2) {
        try {
            Method method = null;
            Method method2 = null;
            Method[] methodArray = (class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionResetter.class$("java.sql.Connection")) : class$java$sql$Connection).getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method3 = methodArray[i];
                if (method3.getName().equals(string)) {
                    if (method == null) {
                        method = method3;
                    } else {
                        this.log.info("Skipping ambiguous reset method " + string);
                        return;
                    }
                }
                if (!method3.getName().equals(string2)) continue;
                if (method2 == null) {
                    method2 = method3;
                    continue;
                }
                this.log.info("Skipping ambiguous reset method " + string2);
                return;
            }
            if (method == null) {
                this.log.debug("Ignoring attempt to map reset method " + string + " (probably because it isn't implemented in this JDK)");
            } else if (method2 == null) {
                this.log.debug("Ignoring attempt to map reset method " + string2 + " (probably because it isn't implemented in this JDK)");
            } else if (this.accessorMutatorMap.containsKey(method)) {
                this.log.warn("Ignoring attempt to map duplicate reset method " + string);
            } else if (this.accessorMutatorMap.containsValue(method2)) {
                this.log.warn("Ignoring attempt to map duplicate reset method " + string2);
            } else {
                if (string2.indexOf(MUTATOR_PREFIX) != 0) {
                    this.log.warn("Resetter mutator " + string2 + " does not start with " + MUTATOR_PREFIX + " as expected. Proxool maynot recognise that a reset is necessary.");
                }
                if (method.getParameterTypes().length > 0) {
                    this.log.info("Ignoring attempt to map accessor method " + string + ". It must have no arguments.");
                } else if (method2.getParameterTypes().length != 1) {
                    this.log.info("Ignoring attempt to map mutator method " + string2 + ". It must have exactly one argument, not " + method2.getParameterTypes().length);
                } else {
                    this.accessorMutatorMap.put(method, method2);
                }
            }
        }
        catch (Exception exception) {
            this.log.error("Problem mapping " + string + " and " + string2, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(Connection connection) {
        if (!this.initialised) {
            ConnectionResetter connectionResetter = this;
            synchronized (connectionResetter) {
                if (!this.initialised) {
                    Object object;
                    Method method;
                    Object object2;
                    HashSet<Object> hashSet = new HashSet<Object>();
                    Iterator iterator = this.accessorMutatorMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        object2 = (Method)iterator.next();
                        method = (Method)this.accessorMutatorMap.get(object2);
                        object = null;
                        try {
                            object = ((Method)object2).invoke((Object)connection, null);
                            if (object != null) {
                                this.defaultValues.put(method, object);
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Remembering default value: " + ((Method)object2).getName() + "() = " + object);
                            }
                        }
                        catch (Throwable throwable) {
                            this.log.debug(this.driverName + " does not support " + ((Method)object2).getName() + ". Proxool doesn't mind.");
                            hashSet.add(object2);
                        }
                        try {
                            Object[] objectArray = new Object[]{object};
                            method.invoke((Object)connection, objectArray);
                        }
                        catch (Throwable throwable) {
                            this.log.debug(this.driverName + " does not support " + method.getName() + ". Proxool doesn't mind.");
                            hashSet.add(object2);
                        }
                    }
                    object2 = hashSet.iterator();
                    while (object2.hasNext()) {
                        method = (Method)object2.next();
                        object = (Method)this.accessorMutatorMap.get(method);
                        this.accessorMutatorMap.remove(method);
                        this.defaultValues.remove(object);
                    }
                    this.initialised = true;
                }
            }
        }
    }

    protected boolean reset(Connection connection, String string) {
        boolean bl = false;
        try {
            connection.clearWarnings();
        }
        catch (SQLException sQLException) {
            bl = true;
            this.log.warn(string + " - Problem calling connection.clearWarnings()", sQLException);
        }
        boolean bl2 = true;
        try {
            bl2 = connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            bl = true;
            this.log.warn(string + " - Problem calling connection.getAutoCommit()", sQLException);
        }
        if (!bl2) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                this.log.error("Unexpected exception whilst calling rollback during connection reset", sQLException);
            }
        }
        Iterator iterator = this.accessorMutatorMap.keySet().iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            Method method2 = (Method)this.accessorMutatorMap.get(method);
            Object[] objectArray = new Object[]{this.defaultValues.get(method2)};
            try {
                Object object = method.invoke((Object)connection, null);
                if (object == null && objectArray[0] == null || object.equals(objectArray[0])) continue;
                method2.invoke((Object)connection, objectArray);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(string + " - Reset: " + method2.getName() + "(" + objectArray[0] + ") from " + object);
            }
            catch (Throwable throwable) {
                bl = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(string + " - Problem resetting: " + method2.getName() + "(" + objectArray[0] + ").", throwable);
            }
        }
        if (!bl2) {
            try {
                connection.setAutoCommit(true);
                this.log.debug(string + " - autoCommit reset back to true");
            }
            catch (Throwable throwable) {
                bl = true;
                this.log.warn(string + " - Problem calling connection.commit() or connection.setAutoCommit(true)", throwable);
            }
        }
        if (bl) {
            this.log.warn(string + " - There were some problems resetting the connection (see debug output for details). It will not be used again " + "(just in case). The thread that is responsible is named '" + Thread.currentThread().getName() + "'");
            if (!bl2) {
                this.log.warn(string + " - The connection was closed with autoCommit=false. That is fine, but it might indicate that " + "the problems that happened whilst trying to reset it were because a transaction is still in progress.");
            }
        }
        return !bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

