/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ProxoolException;

class ConnectionPoolManager {
    private static final Object LOCK = new Object();
    private Map connectionPoolMap = new HashMap();
    private Set connectionPools = new HashSet();
    private static ConnectionPoolManager connectionPoolManager = null;
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ProxoolFacade == null ? (class$org$logicalcobwebs$proxool$ProxoolFacade = ConnectionPoolManager.class$("org.logicalcobwebs.proxool.ProxoolFacade")) : class$org$logicalcobwebs$proxool$ProxoolFacade);
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxoolFacade;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionPoolManager getInstance() {
        if (connectionPoolManager == null) {
            Object object = LOCK;
            synchronized (object) {
                if (connectionPoolManager == null) {
                    connectionPoolManager = new ConnectionPoolManager();
                }
            }
        }
        return connectionPoolManager;
    }

    private ConnectionPoolManager() {
    }

    protected ConnectionPool getConnectionPool(String string) throws ProxoolException {
        ConnectionPool connectionPool = (ConnectionPool)this.connectionPoolMap.get(string);
        if (connectionPool == null) {
            throw new ProxoolException(this.getKnownPools(string));
        }
        return connectionPool;
    }

    protected String getKnownPools(String string) {
        StringBuffer stringBuffer = new StringBuffer("Couldn't find a pool called '" + string + "'. Known pools are: ");
        Iterator iterator = this.connectionPoolMap.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append(iterator.hasNext() ? ", " : ".");
        }
        return stringBuffer.toString();
    }

    protected boolean isPoolExists(String string) {
        return this.connectionPoolMap.containsKey(string);
    }

    protected ConnectionPool[] getConnectionPools() {
        return this.connectionPools.toArray(new ConnectionPool[this.connectionPools.size()]);
    }

    protected ConnectionPool createConnectionPool(ConnectionPoolDefinition connectionPoolDefinition) throws ProxoolException {
        ConnectionPool connectionPool = new ConnectionPool(connectionPoolDefinition);
        this.connectionPools.add(connectionPool);
        this.connectionPoolMap.put(connectionPoolDefinition.getAlias(), connectionPool);
        return connectionPool;
    }

    protected void removeConnectionPool(String string) {
        ConnectionPool connectionPool = (ConnectionPool)this.connectionPoolMap.get(string);
        if (connectionPool != null) {
            this.connectionPoolMap.remove(connectionPool.getDefinition().getAlias());
            this.connectionPools.remove(connectionPool);
        } else {
            LOG.info("Ignored attempt to remove either non-existent or already removed connection pool " + string);
        }
    }

    public String[] getConnectionPoolNames() {
        return this.connectionPoolMap.keySet().toArray(new String[this.connectionPoolMap.size()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

