/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.FatalSqlExceptionHelper;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

class ConnectionPoolDefinition
implements ConnectionPoolDefinitionIF {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ConnectionPoolDefinition == null ? (class$org$logicalcobwebs$proxool$ConnectionPoolDefinition = ConnectionPoolDefinition.class$("org.logicalcobwebs.proxool.ConnectionPoolDefinition")) : class$org$logicalcobwebs$proxool$ConnectionPoolDefinition);
    private Log poolLog = LOG;
    private String alias;
    private String jndiName;
    private String initialContextFactory;
    private String providerUrl;
    private String securityAuthentication;
    private String securityPrincipal;
    private String securityCredentials;
    private Properties delegateProperties = new Properties();
    private Properties completeInfo = new Properties();
    private Properties changedInfo = new Properties();
    private boolean connectionPropertiesChanged;
    private String url;
    private String completeUrl;
    private String driver;
    private int maximumConnectionLifetime;
    private int prototypeCount;
    private int minimumConnectionCount;
    private int maximumConnectionCount;
    private int houseKeepingSleepTime;
    private int simultaneousBuildThrottle;
    private int recentlyStartedThreshold;
    private int overloadWithoutRefusalLifetime;
    private int maximumActiveTime;
    private boolean verbose;
    private boolean trace;
    private String statistics;
    private String statisticsLogLevel;
    private Set fatalSqlExceptions = new HashSet();
    private String fatalSqlExceptionsAsString;
    private String fatalSqlExceptionWrapper = null;
    private String houseKeepingTestSql;
    private boolean testBeforeUse;
    private boolean testAfterUse;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ConnectionPoolDefinition;

    public ConnectionPoolDefinition() {
    }

    protected ConnectionPoolDefinition(String string, Properties properties, boolean bl) throws ProxoolException {
        this.alias = ProxoolFacade.getAlias(string);
        this.poolLog = LogFactory.getLog("org.logicalcobwebs.proxool." + this.alias);
        this.reset();
        this.doChange(string, properties, false, !bl);
    }

    protected void update(String string, Properties properties) throws ProxoolException {
        this.changedInfo.clear();
        this.connectionPropertiesChanged = false;
        this.poolLog.debug("Updating definition");
        this.doChange(string, properties, false, false);
        if (this.connectionPropertiesChanged) {
            this.poolLog.info("Mercifully killing all current connections because of definition changes");
            ProxoolFacade.killAllConnections(this.alias, "of definition changes", true);
        }
    }

    protected void redefine(String string, Properties properties) throws ProxoolException {
        this.reset();
        this.changedInfo.clear();
        this.connectionPropertiesChanged = false;
        this.poolLog.debug("Redefining definition");
        this.doChange(string, properties, false, false);
        if (this.getUrl() == null || this.getDriver() == null) {
            throw new ProxoolException("The URL is not defined properly: " + this.getCompleteUrl());
        }
        if (this.connectionPropertiesChanged) {
            LOG.info("Mercifully killing all current connections because of definition changes");
            ProxoolFacade.killAllConnections(this.alias, "definition has changed", true);
        }
    }

    private boolean doChange(String string, Properties properties, boolean bl, boolean bl2) throws ProxoolException {
        String string2;
        boolean bl3 = false;
        try {
            int n = string.indexOf(58);
            int n2 = string.indexOf(58, n + 1);
            if (n > -1 && n2 > -1) {
                string2 = string.substring(n + 1, n2);
                if (ConnectionPoolDefinition.isChanged(this.getDriver(), string2)) {
                    bl3 = true;
                    if (!bl) {
                        this.logChange(true, "proxool.driver", string2);
                        this.setDriver(string2);
                    }
                }
                String string3 = string.substring(n2 + 1);
                if (ConnectionPoolDefinition.isChanged(this.getUrl(), string3)) {
                    bl3 = true;
                    if (!bl) {
                        this.logChange(true, "proxool.url", string3);
                        this.setUrl(string3);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LOG.error("Invalid URL: '" + string + "'", indexOutOfBoundsException);
            throw new ProxoolException("Invalid URL: '" + string + "'");
        }
        if (!bl) {
            this.setCompleteUrl(string);
        }
        if (properties != null) {
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                string2 = properties.getProperty(string4);
                bl3 |= this.setAnyProperty(string4, string2, bl);
                if (bl) continue;
                this.completeInfo.setProperty(string4, string2);
            }
        }
        if (!bl) {
            ProxoolFacade.definitionUpdated(this.getAlias(), this, this.completeInfo, this.changedInfo);
        }
        if ((this.getDriver() == null || this.getUrl() == null) && bl2) {
            throw new ProxoolException("Attempt to refer to a unregistered pool by its alias '" + this.getAlias() + "'");
        }
        return bl3;
    }

    private void logChange(boolean bl, String string, String string2) {
        if (this.poolLog.isDebugEnabled()) {
            String string3 = string2;
            if (string.toLowerCase().indexOf("password") > -1) {
                string3 = "********";
            }
            this.poolLog.debug((bl ? "Recognised proxool property: " : "Delegating property to driver: ") + string + "=" + string3);
        }
    }

    private boolean setAnyProperty(String string, String string2, boolean bl) throws ProxoolException {
        boolean bl2 = true;
        boolean bl3 = false;
        bl3 = bl3 || this.setHouseKeeperProperty(string, string2, bl);
        bl3 = bl3 || this.setLoggingProperty(string, string2, bl);
        boolean bl4 = bl3 = bl3 || this.setJndiProperty(string, string2, bl);
        if (string.equals("user")) {
            bl2 = false;
            if (ConnectionPoolDefinition.isChanged(this.getUser(), string2)) {
                bl3 = true;
                if (!bl) {
                    this.setUser(string2);
                }
            }
        } else if (string.equals("password")) {
            bl2 = false;
            if (ConnectionPoolDefinition.isChanged(this.getPassword(), string2)) {
                bl3 = true;
                if (!bl) {
                    this.setPassword(string2);
                }
            }
        } else if (string.equals("proxool.driver")) {
            if (ConnectionPoolDefinition.isChanged(this.getDriver(), string2)) {
                bl3 = true;
                if (!bl) {
                    this.setDriver(string2);
                }
            }
        } else if (string.equals("proxool.url")) {
            if (ConnectionPoolDefinition.isChanged(this.getUrl(), string2)) {
                bl3 = true;
                if (!bl) {
                    this.setUrl(string2);
                }
            }
        } else if (string.equals("proxool.maximum-connection-count")) {
            if (this.getMaximumConnectionCount() != this.getInt(string, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setMaximumConnectionCount(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.maximum-connection-lifetime")) {
            if (this.getMaximumConnectionLifetime() != this.getInt(string, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setMaximumConnectionLifetime(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.maximum-new-connections")) {
            this.poolLog.warn("Use of proxool.maximum-new-connections is deprecated. Use more descriptive proxool.simultaneous-build-throttle instead.");
            if (this.getSimultaneousBuildThrottle() != this.getInt(string, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setSimultaneousBuildThrottle(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.simultaneous-build-throttle")) {
            if (this.getSimultaneousBuildThrottle() != this.getInt(string, string2)) {
                bl3 = true;
                this.setSimultaneousBuildThrottle(this.getInt(string, string2));
            }
        } else if (string.equals("proxool.minimum-connection-count")) {
            if (this.getMinimumConnectionCount() != this.getInt(string, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setMinimumConnectionCount(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.prototype-count")) {
            if (this.getPrototypeCount() != this.getInt(string, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setPrototypeCount(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.recently-started-threshold")) {
            if (this.getRecentlyStartedThreshold() != this.getInt(string, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setRecentlyStartedThreshold(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.overload-without-refusal-lifetime")) {
            if (this.getOverloadWithoutRefusalLifetime() != this.getInt(string, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setOverloadWithoutRefusalLifetime(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.maximum-active-time")) {
            if (this.getMaximumActiveTime() != this.getInt(string, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setMaximumActiveTime(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.fatal-sql-exception")) {
            if (ConnectionPoolDefinition.isChanged(this.fatalSqlExceptionsAsString, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setFatalSqlExceptionsAsString(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("proxool.fatal-sql-exception-wrapper-class")) {
            if (ConnectionPoolDefinition.isChanged(this.fatalSqlExceptionWrapper, string2)) {
                bl3 = true;
                if (!bl) {
                    this.setFatalSqlExceptionWrapper(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("proxool.statistics")) {
            if (ConnectionPoolDefinition.isChanged(this.getStatistics(), string2)) {
                bl3 = true;
                if (!bl) {
                    this.setStatistics(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("proxool.statistics-log-level") && ConnectionPoolDefinition.isChanged(this.getStatisticsLogLevel(), string2)) {
            bl3 = true;
            if (!bl) {
                this.setStatisticsLogLevel(string2.length() > 0 ? string2 : null);
            }
        }
        if (!string.startsWith("proxool.")) {
            if (ConnectionPoolDefinition.isChanged(this.getDelegateProperty(string), string2)) {
                bl3 = true;
                if (!bl) {
                    this.setDelegateProperty(string, string2);
                }
            }
            bl2 = false;
        }
        if (bl3 && !bl) {
            this.logChange(bl2, string, string2);
            this.changedInfo.setProperty(string, string2);
        }
        return bl3;
    }

    private boolean setLoggingProperty(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (string.equals("proxool.debug-level")) {
            if (string2 != null && string2.equals("1")) {
                this.poolLog.warn("Use of proxool.debug-level=1 is deprecated. Use proxool.verbose=true instead.");
                if (!this.isVerbose()) {
                    bl2 = true;
                    if (!bl) {
                        this.setVerbose(true);
                    }
                }
            } else {
                this.poolLog.warn("Use of proxool.debug-level=0 is deprecated. Use proxool.verbose=false instead.");
                if (this.isVerbose()) {
                    bl2 = true;
                    if (!bl) {
                        this.setVerbose(false);
                    }
                }
            }
        } else if (string.equals("proxool.verbose")) {
            boolean bl3 = Boolean.valueOf(string2);
            if (this.isVerbose() != bl3) {
                bl2 = true;
                if (!bl) {
                    this.setVerbose(bl3);
                }
            }
        } else if (string.equals("proxool.trace")) {
            boolean bl4 = Boolean.valueOf(string2);
            if (this.isTrace() != bl4) {
                bl2 = true;
                if (!bl) {
                    this.setTrace(bl4);
                }
            }
        }
        return bl2;
    }

    private boolean setHouseKeeperProperty(String string, String string2, boolean bl) throws ProxoolException {
        boolean bl2 = false;
        if (string.equals("proxool.house-keeping-sleep-time")) {
            if (this.getHouseKeepingSleepTime() != this.getInt(string, string2)) {
                bl2 = true;
                if (!bl) {
                    this.setHouseKeepingSleepTime(this.getInt(string, string2));
                }
            }
        } else if (string.equals("proxool.house-keeping-test-sql")) {
            if (ConnectionPoolDefinition.isChanged(this.getHouseKeepingTestSql(), string2)) {
                bl2 = true;
                if (!bl) {
                    this.setHouseKeepingTestSql(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("proxool.test-before-use")) {
            boolean bl3 = Boolean.valueOf(string2);
            if (this.isTestBeforeUse() != bl3) {
                bl2 = true;
                if (!bl) {
                    this.setTestBeforeUse(bl3);
                }
            }
        } else if (string.equals("proxool.test-after-use")) {
            boolean bl4 = Boolean.valueOf(string2);
            if (this.isTestAfterUse() != bl4) {
                bl2 = true;
                if (!bl) {
                    this.setTestAfterUse(bl4);
                }
            }
        }
        return bl2;
    }

    private boolean setJndiProperty(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (string.equals("proxool.jndi-name")) {
            if (ConnectionPoolDefinition.isChanged(this.getJndiName(), string2)) {
                bl2 = true;
                if (!bl) {
                    this.setJndiName(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("proxool.initial-context-factory")) {
            if (ConnectionPoolDefinition.isChanged(this.getInitialContextFactory(), string2)) {
                bl2 = true;
                if (!bl) {
                    this.setInitialContextFactory(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("proxool.provider-url")) {
            if (ConnectionPoolDefinition.isChanged(this.getProviderUrl(), string2)) {
                bl2 = true;
                if (!bl) {
                    this.setProviderUrl(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("security-authentication")) {
            if (ConnectionPoolDefinition.isChanged(this.getSecurityAuthentication(), string2)) {
                bl2 = true;
                if (!bl) {
                    this.setSecurityAuthentication(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("proxool.security-principal")) {
            if (ConnectionPoolDefinition.isChanged(this.getSecurityPrincipal(), string2)) {
                bl2 = true;
                if (!bl) {
                    this.setSecurityPrincipal(string2.length() > 0 ? string2 : null);
                }
            }
        } else if (string.equals("proxool.security-credentials") && ConnectionPoolDefinition.isChanged(this.getSecurityCredentials(), string2)) {
            bl2 = true;
            if (!bl) {
                this.setSecurityCredentials(string2.length() > 0 ? string2 : null);
            }
        }
        return bl2;
    }

    private int getInt(String string, String string2) throws ProxoolException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProxoolException("'" + string + "' property must be an integer. Found '" + string2 + "' instead.");
        }
    }

    private static boolean isChanged(String string, String string2) {
        boolean bl = false;
        if (string == null) {
            if (string2 != null) {
                bl = true;
            }
        } else if (string2 == null) {
            bl = true;
        } else if (!string.equals(string2)) {
            bl = true;
        }
        return bl;
    }

    private void reset() {
        this.completeUrl = null;
        this.delegateProperties.clear();
        this.completeInfo.clear();
        this.changedInfo.clear();
        this.url = null;
        this.driver = null;
        this.maximumConnectionLifetime = 14400000;
        this.prototypeCount = 0;
        this.minimumConnectionCount = 0;
        this.maximumConnectionCount = 15;
        this.houseKeepingSleepTime = 30000;
        this.houseKeepingTestSql = null;
        this.testAfterUse = false;
        this.testBeforeUse = false;
        this.simultaneousBuildThrottle = 10;
        this.recentlyStartedThreshold = 60000;
        this.overloadWithoutRefusalLifetime = 60000;
        this.maximumActiveTime = 300000;
        this.verbose = false;
        this.trace = false;
        this.statistics = null;
        this.statisticsLogLevel = null;
        this.fatalSqlExceptions.clear();
        this.fatalSqlExceptionWrapper = null;
    }

    protected Properties getCompleteInfo() {
        return this.completeInfo;
    }

    public String getUser() {
        return this.getDelegateProperty("user");
    }

    public void setUser(String string) {
        this.setDelegateProperty("user", string);
    }

    public String getPassword() {
        return this.getDelegateProperty("password");
    }

    public void setPassword(String string) {
        this.setDelegateProperty("password", string);
    }

    public String getJdbcDriverVersion() {
        try {
            Driver driver = DriverManager.getDriver(this.getUrl());
            return driver.getMajorVersion() + "." + driver.getMinorVersion();
        }
        catch (SQLException sQLException) {
            return "Trying to locate driver version for '" + this.getUrl() + "' caused: " + sQLException.toString();
        }
        catch (NullPointerException nullPointerException) {
            return "Couldn't locate driver for '" + this.getUrl() + "'!";
        }
    }

    public String toString() {
        return this.getCompleteUrl();
    }

    public String getName() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public int getMaximumConnectionLifetime() {
        return this.maximumConnectionLifetime;
    }

    public void setMaximumConnectionLifetime(int n) {
        this.maximumConnectionLifetime = n;
    }

    public int getPrototypeCount() {
        return this.prototypeCount;
    }

    public void setPrototypeCount(int n) {
        this.prototypeCount = n;
    }

    public int getMinimumConnectionCount() {
        return this.minimumConnectionCount;
    }

    public void setMinimumConnectionCount(int n) {
        this.minimumConnectionCount = n;
    }

    public int getMaximumConnectionCount() {
        return this.maximumConnectionCount;
    }

    public void setMaximumConnectionCount(int n) {
        this.maximumConnectionCount = n;
    }

    public int getHouseKeepingSleepTime() {
        return this.houseKeepingSleepTime;
    }

    public void setHouseKeepingSleepTime(int n) {
        this.houseKeepingSleepTime = n;
    }

    public int getMaximumNewConnections() {
        return this.simultaneousBuildThrottle;
    }

    public void setMaximumNewConnections(int n) {
        this.simultaneousBuildThrottle = n;
    }

    public int getSimultaneousBuildThrottle() {
        return this.simultaneousBuildThrottle;
    }

    public void setSimultaneousBuildThrottle(int n) {
        this.simultaneousBuildThrottle = n;
    }

    public Properties getProperties() {
        return this.delegateProperties;
    }

    public Properties getDelegateProperties() {
        return this.delegateProperties;
    }

    public String getDelegateProperty(String string) {
        return this.getDelegateProperties().getProperty(string);
    }

    public void setDelegateProperty(String string, String string2) {
        this.connectionPropertiesChanged = true;
        this.getDelegateProperties().setProperty(string, string2);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
        this.connectionPropertiesChanged = true;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
        this.connectionPropertiesChanged = true;
    }

    public int getRecentlyStartedThreshold() {
        return this.recentlyStartedThreshold;
    }

    public void setRecentlyStartedThreshold(int n) {
        this.recentlyStartedThreshold = n;
    }

    public int getOverloadWithoutRefusalLifetime() {
        return this.overloadWithoutRefusalLifetime;
    }

    public void setOverloadWithoutRefusalLifetime(int n) {
        this.overloadWithoutRefusalLifetime = n;
    }

    public int getMaximumActiveTime() {
        return this.maximumActiveTime;
    }

    public void setMaximumActiveTime(int n) {
        this.maximumActiveTime = n;
    }

    public int getDebugLevel() {
        return this.verbose ? 1 : 0;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public String getCompleteUrl() {
        return this.completeUrl;
    }

    public void setCompleteUrl(String string) {
        this.completeUrl = string;
    }

    public void setFatalSqlExceptionsAsString(String string) {
        this.fatalSqlExceptionsAsString = string;
        this.fatalSqlExceptions.clear();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.fatalSqlExceptions.add(stringTokenizer.nextToken().trim());
            }
        }
    }

    public Set getFatalSqlExceptions() {
        return this.fatalSqlExceptions;
    }

    public String getFatalSqlExceptionWrapper() {
        return this.fatalSqlExceptionWrapper;
    }

    public void setFatalSqlExceptionWrapper(String string) throws ProxoolException {
        try {
            FatalSqlExceptionHelper.throwFatalSQLException(string, new SQLException("Test"));
        }
        catch (SQLException sQLException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.fatalSqlExceptionWrapper = string;
    }

    public String getHouseKeepingTestSql() {
        return this.houseKeepingTestSql;
    }

    public void setHouseKeepingTestSql(String string) {
        this.houseKeepingTestSql = string;
    }

    public boolean isTestBeforeUse() {
        return this.testBeforeUse;
    }

    public void setTestBeforeUse(boolean bl) {
        this.testBeforeUse = bl;
    }

    public boolean isTestAfterUse() {
        return this.testAfterUse;
    }

    public void setTestAfterUse(boolean bl) {
        this.testAfterUse = bl;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String string) {
        this.statistics = string;
    }

    public String getStatisticsLogLevel() {
        return this.statisticsLogLevel;
    }

    public void setStatisticsLogLevel(String string) {
        this.statisticsLogLevel = string;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String string) {
        this.initialContextFactory = string;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String string) {
        this.providerUrl = string;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public void setSecurityAuthentication(String string) {
        this.securityAuthentication = string;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public void setSecurityPrincipal(String string) {
        this.securityPrincipal = string;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String string) {
        this.securityCredentials = string;
    }

    public boolean isEqual(String string, Properties properties) {
        try {
            return !this.doChange(string, properties, true, false);
        }
        catch (ProxoolException proxoolException) {
            LOG.error("Problem checking equality", proxoolException);
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

