/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.logicalcobwebs.concurrent.ReaderPreferenceReadWriteLock;
import org.logicalcobwebs.concurrent.WriterPreferenceReadWriteLock;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.CompositeConnectionListener;
import org.logicalcobwebs.proxool.CompositeStateListener;
import org.logicalcobwebs.proxool.ConnectionInfo;
import org.logicalcobwebs.proxool.ConnectionInfoIF;
import org.logicalcobwebs.proxool.ConnectionListenerIF;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.ConnectionPoolStatisticsIF;
import org.logicalcobwebs.proxool.ConnectionResetter;
import org.logicalcobwebs.proxool.FormatHelper;
import org.logicalcobwebs.proxool.HouseKeeperController;
import org.logicalcobwebs.proxool.Prototyper;
import org.logicalcobwebs.proxool.PrototyperController;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnection;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.logicalcobwebs.proxool.ProxyFactory;
import org.logicalcobwebs.proxool.ShutdownHook;
import org.logicalcobwebs.proxool.StateListenerIF;
import org.logicalcobwebs.proxool.admin.Admin;
import org.logicalcobwebs.proxool.util.FastArrayList;

class ConnectionPool
implements ConnectionPoolStatisticsIF {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ConnectionPool == null ? (class$org$logicalcobwebs$proxool$ConnectionPool = ConnectionPool.class$("org.logicalcobwebs.proxool.ConnectionPool")) : class$org$logicalcobwebs$proxool$ConnectionPool);
    private Log log;
    private ReaderPreferenceReadWriteLock connectionStatusReadWriteLock = new ReaderPreferenceReadWriteLock();
    private WriterPreferenceReadWriteLock primaryReadWriteLock = new WriterPreferenceReadWriteLock();
    private static final String[] STATUS_DESCRIPTIONS = new String[]{"NULL", "AVAILABLE", "ACTIVE", "OFFLINE"};
    private static final String MSG_MAX_CONNECTION_COUNT = "Couldn't get connection because we are at maximum connection count and there are none available";
    private List proxyConnections;
    private int nextAvailableConnection = 0;
    private int connectionCount = 0;
    private long connectionsServedCount = 0L;
    private long connectionsRefusedCount = 0L;
    private int[] connectionCountByState = new int[4];
    private ConnectionPoolDefinition definition;
    private CompositeConnectionListener compositeConnectionListener = new CompositeConnectionListener();
    private CompositeStateListener compositeStateListener = new CompositeStateListener();
    private long timeOfLastRefusal = 0L;
    private int upState;
    private static boolean loggedLegend;
    private Admin admin;
    private boolean locked = false;
    private Date dateStarted = new Date();
    private boolean connectionPoolUp = false;
    private Thread shutdownThread;
    private Prototyper prototyper;
    private ConnectionResetter connectionResetter;
    protected static final boolean FORCE_EXPIRY = true;
    protected static final boolean REQUEST_EXPIRY = false;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ConnectionPool;

    protected ConnectionPool(ConnectionPoolDefinition connectionPoolDefinition) throws ProxoolException {
        FastArrayList fastArrayList = new FastArrayList();
        fastArrayList.setFast(true);
        this.proxyConnections = fastArrayList;
        this.log = LogFactory.getLog("org.logicalcobwebs.proxool." + connectionPoolDefinition.getAlias());
        this.connectionResetter = new ConnectionResetter(this.log, connectionPoolDefinition.getDriver());
        this.setDefinition(connectionPoolDefinition);
        if (connectionPoolDefinition.getStatistics() != null) {
            try {
                this.admin = new Admin(connectionPoolDefinition);
            }
            catch (ProxoolException proxoolException) {
                this.log.error("Failed to initialise statistics", proxoolException);
            }
        }
        ShutdownHook.init();
    }

    protected void start() throws ProxoolException {
        this.connectionPoolUp = true;
        this.prototyper = new Prototyper(this);
        HouseKeeperController.register(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection getConnection() throws SQLException {
        ProxyConnectionIF proxyConnectionIF;
        block26: {
            String string = Thread.currentThread().getName();
            if (this.connectionCount >= this.getDefinition().getMaximumConnectionCount() && this.getAvailableConnectionCount() < 1) {
                ++this.connectionsRefusedCount;
                if (this.admin != null) {
                    this.admin.connectionRefused();
                }
                this.log.info(this.displayStatistics() + " - " + MSG_MAX_CONNECTION_COUNT);
                this.timeOfLastRefusal = System.currentTimeMillis();
                this.setUpState(2);
                throw new SQLException(MSG_MAX_CONNECTION_COUNT);
            }
            try {
                PrototyperController.checkSimultaneousBuildThrottle(this.getDefinition().getAlias());
            }
            catch (ProxoolException proxoolException) {
                this.log.error("Unexpected problem", proxoolException);
                throw new SQLException(proxoolException.getMessage());
            }
            proxyConnectionIF = null;
            try {
                try {
                    for (int i = 0; i < this.proxyConnections.size(); ++this.nextAvailableConnection, ++i) {
                        try {
                            proxyConnectionIF = (ProxyConnectionIF)this.proxyConnections.get(this.nextAvailableConnection);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            this.nextAvailableConnection = 0;
                            proxyConnectionIF = (ProxyConnectionIF)this.proxyConnections.get(this.nextAvailableConnection);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            this.nextAvailableConnection = 0;
                            proxyConnectionIF = (ProxyConnectionIF)this.proxyConnections.get(this.nextAvailableConnection);
                        }
                        if (proxyConnectionIF != null && proxyConnectionIF.setStatus(1, 2)) {
                            if (this.getDefinition().isTestBeforeUse() && !this.testConnection(proxyConnectionIF)) {
                                proxyConnectionIF = null;
                            }
                            if (proxyConnectionIF == null) continue;
                            ++this.nextAvailableConnection;
                            break;
                        }
                        proxyConnectionIF = null;
                    }
                    if (proxyConnectionIF == null) {
                        try {
                            proxyConnectionIF = PrototyperController.buildConnection(this.getDefinition().getAlias(), 2, "on demand");
                            if (this.getDefinition().isTestBeforeUse() && !this.testConnection(proxyConnectionIF)) {
                                throw new SQLException("Created a new connection but it failed its test");
                            }
                        }
                        catch (SQLException sQLException) {
                            throw sQLException;
                        }
                        catch (ProxoolException proxoolException) {
                            this.log.debug("Couldn't get connection", proxoolException);
                            throw new SQLException(proxoolException.toString());
                        }
                        catch (Throwable throwable) {
                            this.log.error("Couldn't get connection", throwable);
                            throw new SQLException(throwable.toString());
                        }
                    }
                    Object var6_13 = null;
                    if (proxyConnectionIF != null) {
                        ++this.connectionsServedCount;
                        proxyConnectionIF.setRequester(string);
                        break block26;
                    }
                    ++this.connectionsRefusedCount;
                    if (this.admin != null) {
                        this.admin.connectionRefused();
                    }
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    this.log.error("Problem getting connection", throwable);
                    throw new SQLException(throwable.toString());
                }
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                if (proxyConnectionIF != null) {
                    ++this.connectionsServedCount;
                    proxyConnectionIF.setRequester(string);
                    throw throwable;
                }
                ++this.connectionsRefusedCount;
                if (this.admin != null) {
                    this.admin.connectionRefused();
                }
                this.timeOfLastRefusal = System.currentTimeMillis();
                this.setUpState(2);
                throw throwable;
            }
            this.timeOfLastRefusal = System.currentTimeMillis();
            this.setUpState(2);
        }
        if (proxyConnectionIF == null) {
            throw new SQLException("Unknown reason for not getting connection. Sorry.");
        }
        if (!this.log.isDebugEnabled()) return ProxyFactory.getConnection(proxyConnectionIF);
        if (!this.getDefinition().isVerbose()) return ProxyFactory.getConnection(proxyConnectionIF);
        this.log.debug(this.displayStatistics() + " - Connection #" + proxyConnectionIF.getId() + " served");
        return ProxyFactory.getConnection(proxyConnectionIF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean testConnection(ProxyConnectionIF proxyConnectionIF) {
        Statement statement;
        boolean bl;
        block8: {
            bl = false;
            String string = this.getDefinition().getHouseKeepingTestSql();
            if (string == null) return bl;
            if (string.length() <= 0) return bl;
            statement = null;
            statement = proxyConnectionIF.getConnection().createStatement();
            statement.execute(string);
            bl = true;
            if (!LOG.isDebugEnabled()) break block8;
            LOG.debug(this.displayStatistics() + " - Connection #" + proxyConnectionIF.getId() + " tested: OK");
        }
        Object var7_5 = null;
        if (statement == null) return bl;
        try {
            statement.close();
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
        {
            catch (Throwable throwable) {
                proxyConnectionIF.setStatus(0);
                this.removeProxyConnection(proxyConnectionIF, "it has problems: " + throwable, false, true);
                Object var7_6 = null;
                if (statement == null) return bl;
                try {
                    statement.close();
                    return bl;
                }
                catch (Throwable throwable2) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Throwable throwable3) {
                bl = false;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxyConnection(ProxyConnectionIF proxyConnectionIF) {
        try {
            this.acquireConnectionStatusWriteLock();
            this.proxyConnections.add(proxyConnectionIF);
            int n = proxyConnectionIF.getStatus();
            this.connectionCountByState[n] = this.connectionCountByState[n] + 1;
        }
        finally {
            this.releaseConnectionStatusWriteLock();
        }
    }

    protected static String getStatusDescription(int n) {
        try {
            return STATUS_DESCRIPTIONS[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "Unknown status: " + n;
        }
    }

    protected void putConnection(ProxyConnectionIF proxyConnectionIF) {
        if (this.admin != null) {
            long l;
            long l2 = System.currentTimeMillis();
            if (l2 - (l = proxyConnectionIF.getTimeLastStartActive()) < 0L) {
                this.log.warn("Future start time detected. #" + proxyConnectionIF.getId() + " start = " + new Date(l) + " (" + (l2 - l) + " milliseconds)");
            } else if (l2 - l > 1000000L) {
                this.log.warn("Suspiciously long active time. #" + proxyConnectionIF.getId() + " start = " + new Date(l));
            }
            this.admin.connectionReturned(l2 - l);
        }
        if (proxyConnectionIF.isMarkedForExpiry()) {
            if (proxyConnectionIF.setStatus(2, 0)) {
                this.expireProxyConnection(proxyConnectionIF, proxyConnectionIF.getReasonForMark(), false);
            }
        } else {
            if (this.getDefinition().isTestAfterUse()) {
                this.testConnection(proxyConnectionIF);
            }
            if (!proxyConnectionIF.setStatus(2, 1)) {
                this.log.warn("Unable to set status of connection " + proxyConnectionIF.getId() + " from " + ConnectionPool.getStatusDescription(2) + "to " + ConnectionPool.getStatusDescription(1) + ". It remains " + ConnectionPool.getStatusDescription(proxyConnectionIF.getStatus()));
            }
        }
        if (this.log.isDebugEnabled() && this.getDefinition().isVerbose()) {
            this.log.debug(this.displayStatistics() + " - Connection #" + proxyConnectionIF.getId() + " returned (now " + ConnectionPool.getStatusDescription(proxyConnectionIF.getStatus()) + ")");
        }
    }

    protected void throwConnection(ProxyConnectionIF proxyConnectionIF, String string) {
        this.expireConnectionAsSoonAsPossible(proxyConnectionIF, string, true);
    }

    private ProxyConnectionIF getProxyConnection(int n) {
        return (ProxyConnectionIF)this.proxyConnections.get(n);
    }

    protected ProxyConnectionIF[] getProxyConnections() {
        return this.proxyConnections.toArray(new ProxyConnectionIF[this.proxyConnections.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProxyConnection(ProxyConnectionIF proxyConnectionIF, String string, boolean bl, boolean bl2) {
        if (bl || proxyConnectionIF.isNull()) {
            proxyConnectionIF.setStatus(0);
            try {
                this.onDeath(proxyConnectionIF.getConnection());
            }
            catch (SQLException sQLException) {
                this.log.error("Problem during onDeath (ignored)", sQLException);
            }
            try {
                proxyConnectionIF.reallyClose();
            }
            catch (SQLException sQLException) {
                this.log.error(sQLException);
            }
            try {
                if (this.isConnectionPoolUp()) {
                    this.acquireConnectionStatusWriteLock();
                }
                this.proxyConnections.remove(proxyConnectionIF);
            }
            finally {
                if (this.isConnectionPoolUp()) {
                    this.releaseConnectionStatusWriteLock();
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnectionIF.getId()) + " removed because " + string + ".");
            }
            if (bl2) {
                PrototyperController.triggerSweep(this.getDefinition().getAlias());
            }
        } else {
            this.log.error(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnectionIF.getId()) + " was not removed because isNull() was false.");
        }
    }

    protected void expireProxyConnection(ProxyConnectionIF proxyConnectionIF, String string, boolean bl) {
        this.removeProxyConnection(proxyConnectionIF, string, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void shutdown(int n, String string) throws Throwable {
        String string2 = this.getDefinition().getAlias();
        try {
            this.acquirePrimaryWriteLock();
            if (this.connectionPoolUp) {
                block34: {
                    this.connectionPoolUp = false;
                    long l = System.currentTimeMillis();
                    this.shutdownThread = Thread.currentThread();
                    if (n > 0) {
                        this.log.info("Shutting down '" + string2 + "' pool started at " + this.dateStarted + " - waiting for " + n + " milliseconds for everything to stop.  [ " + string + "]");
                    } else {
                        this.log.info("Shutting down '" + string2 + "' pool immediately [" + string + "]");
                    }
                    boolean bl = false;
                    try {
                        try {
                            block33: {
                                try {
                                    HouseKeeperController.cancel(string2);
                                }
                                catch (ProxoolException proxoolException) {
                                    this.log.error("Shutdown couldn't cancel house keeper", proxoolException);
                                }
                                if (this.admin != null) {
                                    this.admin.cancelAll();
                                }
                                if (this.connectionCountByState[2] != 0) {
                                    int n2;
                                    long l2 = l + (long)n;
                                    LOG.info("Waiting until " + new Date(l2) + " for all connections to become inactive (active count is " + this.connectionCountByState[2] + ").");
                                    while (true) {
                                        long l3;
                                        if ((l3 = l2 - System.currentTimeMillis()) > 0L) {
                                            Thread thread = Thread.currentThread();
                                            synchronized (thread) {
                                                try {
                                                    Thread.currentThread().wait(l3);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    this.log.debug("Interrupted whilst sleeping.");
                                                }
                                            }
                                        }
                                        if ((n2 = this.connectionCountByState[2]) == 0) break block33;
                                        if (System.currentTimeMillis() >= l2) break;
                                        LOG.info("Still waiting for active count to reach zero (currently " + n2 + ").");
                                        Thread.sleep(100L);
                                    }
                                    LOG.warn("Shutdown waited for " + (System.currentTimeMillis() - l) + " milliseconds for all " + "the connections to become inactive but the active count is still " + n2 + ". Shutting down anyway.");
                                }
                            }
                            try {
                                PrototyperController.cancel(string2);
                            }
                            catch (NullPointerException nullPointerException) {
                                this.log.error("PrototypingThread already dead", nullPointerException);
                            }
                            catch (Exception exception) {
                                this.log.error("Can't wake prototypingThread", exception);
                            }
                            for (int i = this.proxyConnections.size() - 1; i >= 0; --i) {
                                long l2 = this.getProxyConnection(i).getId();
                                try {
                                    bl = true;
                                    this.removeProxyConnection(this.getProxyConnection(i), "of shutdown", true, false);
                                    if (!this.log.isDebugEnabled()) continue;
                                    this.log.debug("Connection #" + l2 + " closed");
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    if (!this.log.isDebugEnabled()) continue;
                                    this.log.debug("Problem closing connection #" + l2, throwable);
                                }
                            }
                            Object var15_20 = null;
                            ConnectionPoolManager.getInstance().removeConnectionPool(string2);
                            if (!this.log.isDebugEnabled()) break block34;
                            this.log.info("'" + string2 + "' pool has been closed down by " + string + " in " + (System.currentTimeMillis() - l) + " milliseconds.");
                            if (!bl) {
                                this.log.debug("No connections required manual removal.");
                            }
                        }
                        catch (Throwable throwable) {
                            this.log.error("Unknown problem finalizing pool", throwable);
                            Object var15_21 = null;
                            ConnectionPoolManager.getInstance().removeConnectionPool(string2);
                            if (this.log.isDebugEnabled()) {
                                this.log.info("'" + string2 + "' pool has been closed down by " + string + " in " + (System.currentTimeMillis() - l) + " milliseconds.");
                                if (!bl) {
                                    this.log.debug("No connections required manual removal.");
                                }
                            }
                            super.finalize();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_22 = null;
                        ConnectionPoolManager.getInstance().removeConnectionPool(string2);
                        if (this.log.isDebugEnabled()) {
                            this.log.info("'" + string2 + "' pool has been closed down by " + string + " in " + (System.currentTimeMillis() - l) + " milliseconds.");
                            if (!bl) {
                                this.log.debug("No connections required manual removal.");
                            }
                        }
                        super.finalize();
                        throw throwable;
                    }
                }
                super.finalize();
                return;
            }
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("Ignoring duplicate attempt to shutdown '" + string2 + "' pool by " + string);
            return;
        }
        catch (Throwable throwable) {
            this.log.error(string + " couldn't shutdown pool", throwable);
            return;
        }
        finally {
            this.releasePrimaryWriteLock();
        }
    }

    public int getAvailableConnectionCount() {
        return this.connectionCountByState[1];
    }

    public int getActiveConnectionCount() {
        return this.connectionCountByState[2];
    }

    public int getOfflineConnectionCount() {
        return this.connectionCountByState[3];
    }

    protected String displayStatistics() {
        if (!loggedLegend) {
            this.log.info("Proxool statistics legend: \"s - r  (a/t/o)\" > s=served, r=refused (only shown if non-zero), a=active, t=total, o=offline (being tested)");
            loggedLegend = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FormatHelper.formatBigNumber(this.getConnectionsServedCount()));
        if (this.getConnectionsRefusedCount() > 0L) {
            stringBuffer.append(" -");
            stringBuffer.append(FormatHelper.formatBigNumber(this.getConnectionsRefusedCount()));
        }
        stringBuffer.append(" (");
        stringBuffer.append(FormatHelper.formatSmallNumber(this.getActiveConnectionCount()));
        stringBuffer.append("/");
        stringBuffer.append(FormatHelper.formatSmallNumber(this.getAvailableConnectionCount() + this.getActiveConnectionCount()));
        stringBuffer.append("/");
        stringBuffer.append(FormatHelper.formatSmallNumber(this.getOfflineConnectionCount()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected void expireAllConnections(String string, boolean bl) {
        HashSet hashSet = new HashSet();
        for (int i = this.proxyConnections.size() - 1; i >= 0; --i) {
            hashSet.add(this.proxyConnections.get(i));
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ProxyConnectionIF proxyConnectionIF = (ProxyConnectionIF)iterator.next();
            this.expireConnectionAsSoonAsPossible(proxyConnectionIF, string, bl);
        }
    }

    protected void expireConnectionAsSoonAsPossible(ProxyConnectionIF proxyConnectionIF, String string, boolean bl) {
        if (proxyConnectionIF.setStatus(1, 3)) {
            if (proxyConnectionIF.setStatus(3, 0)) {
                this.expireProxyConnection(proxyConnectionIF, string, false);
            }
        } else if (bl) {
            proxyConnectionIF.markForExpiry(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.displayStatistics() + " - #" + FormatHelper.formatMediumNumber(proxyConnectionIF.getId()) + " marked for expiry.");
            }
        } else {
            this.expireProxyConnection(proxyConnectionIF, string, true);
        }
    }

    protected void registerRemovedConnection(int n) {
        --this.connectionCount;
        PrototyperController.connectionRemoved(this.getDefinition().getAlias());
        int n2 = n;
        this.connectionCountByState[n2] = this.connectionCountByState[n2] - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeStatus(int n, int n2) {
        int n3 = n;
        this.connectionCountByState[n3] = this.connectionCountByState[n3] - 1;
        int n4 = n2;
        this.connectionCountByState[n4] = this.connectionCountByState[n4] + 1;
        if (this.shutdownThread != null && this.connectionCountByState[2] == 0) {
            Thread thread = this.shutdownThread;
            synchronized (thread) {
                this.shutdownThread.notify();
            }
        }
    }

    public long getConnectionsServedCount() {
        return this.connectionsServedCount;
    }

    public long getConnectionsRefusedCount() {
        return this.connectionsRefusedCount;
    }

    protected ConnectionPoolDefinition getDefinition() {
        return this.definition;
    }

    protected synchronized void setDefinition(ConnectionPoolDefinition connectionPoolDefinition) throws ProxoolException {
        this.definition = connectionPoolDefinition;
        try {
            Class.forName(connectionPoolDefinition.getDriver());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error("Couldn't load class " + connectionPoolDefinition.getDriver(), classNotFoundException);
            throw new ProxoolException("Couldn't load class " + connectionPoolDefinition.getDriver());
        }
        catch (NullPointerException nullPointerException) {
            this.log.error("Definition did not contain driver", nullPointerException);
            throw new ProxoolException("Definition did not contain driver");
        }
    }

    public void setStateListener(StateListenerIF stateListenerIF) {
        this.addStateListener(stateListenerIF);
    }

    public void addStateListener(StateListenerIF stateListenerIF) {
        this.compositeStateListener.addListener(stateListenerIF);
    }

    public boolean removeStateListener(StateListenerIF stateListenerIF) {
        return this.compositeStateListener.removeListener(stateListenerIF);
    }

    public void setConnectionListener(ConnectionListenerIF connectionListenerIF) {
        this.addConnectionListener(connectionListenerIF);
    }

    public void addConnectionListener(ConnectionListenerIF connectionListenerIF) {
        this.compositeConnectionListener.addListener(connectionListenerIF);
    }

    public boolean removeConnectionListener(ConnectionListenerIF connectionListenerIF) {
        return this.compositeConnectionListener.removeListener(connectionListenerIF);
    }

    protected void onBirth(Connection connection) throws SQLException {
        this.compositeConnectionListener.onBirth(connection);
    }

    protected void onDeath(Connection connection) throws SQLException {
        this.compositeConnectionListener.onDeath(connection);
    }

    protected void onExecute(String string, long l, Exception exception) throws SQLException {
        if (exception == null) {
            this.compositeConnectionListener.onExecute(string, l);
        } else {
            this.compositeConnectionListener.onFail(string, exception);
        }
    }

    protected boolean isConnectionListenedTo() {
        return !this.compositeConnectionListener.isEmpty();
    }

    public String toString() {
        return this.getDefinition().toString();
    }

    public int getUpState() {
        return this.upState;
    }

    public void setUpState(int n) {
        if (this.upState != n) {
            this.compositeStateListener.upStateChanged(n);
            this.upState = n;
        }
    }

    protected Collection getConnectionInfos() {
        TreeSet<ConnectionInfo> treeSet = null;
        treeSet = new TreeSet<ConnectionInfo>();
        Iterator iterator = this.proxyConnections.iterator();
        while (iterator.hasNext()) {
            ConnectionInfoIF connectionInfoIF = (ConnectionInfoIF)iterator.next();
            ConnectionInfo connectionInfo = new ConnectionInfo();
            connectionInfo.setAge(connectionInfoIF.getAge());
            connectionInfo.setBirthDate(connectionInfoIF.getBirthDate());
            connectionInfo.setId(connectionInfoIF.getId());
            connectionInfo.setMark(connectionInfoIF.getMark());
            connectionInfo.setRequester(connectionInfoIF.getRequester());
            connectionInfo.setStatus(connectionInfoIF.getStatus());
            connectionInfo.setTimeLastStartActive(connectionInfoIF.getTimeLastStartActive());
            connectionInfo.setTimeLastStopActive(connectionInfoIF.getTimeLastStopActive());
            connectionInfo.setDelegateUrl(connectionInfoIF.getDelegateUrl());
            connectionInfo.setProxyHashcode(connectionInfoIF.getProxyHashcode());
            connectionInfo.setDelegateHashcode(connectionInfoIF.getDelegateHashcode());
            treeSet.add(connectionInfo);
        }
        return treeSet;
    }

    public boolean expireConnection(long l, boolean bl) {
        boolean bl2 = false;
        ProxyConnection proxyConnection = null;
        for (int i = 0; i < this.proxyConnections.size(); ++i) {
            try {
                proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.nextAvailableConnection = 0;
                proxyConnection = (ProxyConnection)this.proxyConnections.get(this.nextAvailableConnection);
            }
            if (proxyConnection.getId() == l) {
                proxyConnection.setStatus(1, 3);
                proxyConnection.setStatus(3, 0);
                this.removeProxyConnection(proxyConnection, "it was manually killed", bl, true);
                bl2 = true;
                break;
            }
            ++this.nextAvailableConnection;
        }
        if (!bl2 && this.log.isDebugEnabled()) {
            this.log.debug(this.displayStatistics() + " - couldn't find " + FormatHelper.formatMediumNumber(proxyConnection.getId()) + " and I've just been asked to expire it");
        }
        return bl2;
    }

    public Log getLog() {
        return this.log;
    }

    protected void initialiseConnectionResetter(Connection connection) {
        this.connectionResetter.initialise(connection);
    }

    protected boolean resetConnection(Connection connection, String string) {
        return this.connectionResetter.reset(connection, string);
    }

    public Date getDateStarted() {
        return this.dateStarted;
    }

    protected Admin getAdmin() {
        return this.admin;
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void lock() {
        this.locked = true;
    }

    protected void unlock() {
        this.locked = false;
    }

    protected void acquirePrimaryReadLock() throws InterruptedException {
        this.primaryReadWriteLock.readLock().acquire();
    }

    protected void releasePrimaryReadLock() {
        this.primaryReadWriteLock.readLock().release();
    }

    protected void acquirePrimaryWriteLock() throws InterruptedException {
        boolean bl = false;
        this.primaryReadWriteLock.writeLock().acquire();
        bl = true;
    }

    protected void releasePrimaryWriteLock() {
        this.primaryReadWriteLock.writeLock().release();
    }

    protected boolean isConnectionPoolUp() {
        return this.connectionPoolUp;
    }

    protected long getTimeOfLastRefusal() {
        return this.timeOfLastRefusal;
    }

    protected void acquireConnectionStatusWriteLock() {
        try {
            this.connectionStatusReadWriteLock.writeLock().acquire();
        }
        catch (InterruptedException interruptedException) {
            this.log.error("Couldn't acquire connectionStatus write lock", interruptedException);
        }
    }

    protected void releaseConnectionStatusWriteLock() {
        this.connectionStatusReadWriteLock.writeLock().release();
    }

    protected void acquireConnectionStatusReadLock() {
        try {
            this.connectionStatusReadWriteLock.readLock().acquire();
        }
        catch (InterruptedException interruptedException) {
            this.log.error("Couldn't acquire connectionStatus read lock", interruptedException);
        }
    }

    protected void releaseConnectionStatusReadLock() {
        this.connectionStatusReadWriteLock.readLock().release();
    }

    protected Prototyper getPrototyper() {
        return this.prototyper;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

