/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.FatalSqlExceptionHelper;
import org.logicalcobwebs.proxool.HouseKeeperController;
import org.logicalcobwebs.proxool.ProxyConnectionIF;

abstract class AbstractProxyStatement {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$ProxyStatement == null ? (class$org$logicalcobwebs$proxool$ProxyStatement = AbstractProxyStatement.class$("org.logicalcobwebs.proxool.ProxyStatement")) : class$org$logicalcobwebs$proxool$ProxyStatement);
    private Statement statement;
    private ConnectionPool connectionPool;
    private ProxyConnectionIF proxyConnection;
    private Map parameters;
    private String sqlStatement;
    private StringBuffer sqlLog = new StringBuffer();
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$ProxyStatement;

    public AbstractProxyStatement(Statement statement, ConnectionPool connectionPool, ProxyConnectionIF proxyConnectionIF, String string) {
        this.statement = statement;
        this.connectionPool = connectionPool;
        this.proxyConnection = proxyConnectionIF;
        this.sqlStatement = string;
    }

    protected boolean testException(Throwable throwable) {
        if (FatalSqlExceptionHelper.testException(this.connectionPool.getDefinition(), throwable)) {
            try {
                this.statement.close();
                this.connectionPool.throwConnection(this.proxyConnection, "Fatal SQL Exception has been detected");
                HouseKeeperController.sweepNow(this.connectionPool.getDefinition().getAlias());
                LOG.warn("Connection has been thrown away because fatal exception was detected", throwable);
            }
            catch (SQLException sQLException) {
                LOG.error("Problem trying to throw away suspect connection", sQLException);
            }
            return true;
        }
        return false;
    }

    public Statement getDelegateStatement() {
        return this.statement;
    }

    protected ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    protected Statement getStatement() {
        return this.statement;
    }

    public void close() throws SQLException {
        this.statement.close();
        this.proxyConnection.registerClosedStatement(this.statement);
    }

    public boolean equals(Object object) {
        return this.statement.hashCode() == object.hashCode();
    }

    protected void putParameter(int n, Object object) {
        if (this.parameters == null) {
            this.parameters = new TreeMap(new Comparator(){

                public int compare(Object object, Object object2) {
                    int n = 0;
                    if (object instanceof Integer && object2 instanceof Integer) {
                        n = ((Integer)object).compareTo((Integer)object2);
                    }
                    return n;
                }
            });
        }
        Integer n2 = new Integer(n);
        if (object == null) {
            this.parameters.put(n2, "NULL");
        } else if (object instanceof String) {
            this.parameters.put(n2, "'" + object + "'");
        } else if (object instanceof Number) {
            this.parameters.put(n2, object);
        } else {
            String string = object.getClass().getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            this.parameters.put(n2, string);
        }
    }

    protected void trace(long l, Exception exception) throws SQLException {
        if (this.isTrace()) {
            if (this.connectionPool.getLog().isDebugEnabled() && this.connectionPool.getDefinition().isTrace()) {
                this.connectionPool.getLog().debug(this.sqlLog.toString() + " (" + (System.currentTimeMillis() - l) + " milliseconds" + (exception != null ? ", threw a " + exception.getClass().getName() + ": " + exception.getMessage() + ")" : ")"));
            }
            this.connectionPool.onExecute(this.sqlLog.toString(), System.currentTimeMillis() - l, exception);
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
        this.sqlStatement = null;
        this.sqlLog.setLength(0);
    }

    protected void appendToSqlLog() {
        if (this.sqlStatement != null && this.sqlStatement.length() > 0 && this.isTrace()) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(this.sqlStatement, "?");
            while (stringTokenizer.hasMoreTokens()) {
                if (n > 0) {
                    if (this.parameters != null) {
                        Object v = this.parameters.get(new Integer(n));
                        if (v != null) {
                            this.sqlLog.append(v);
                        } else {
                            this.sqlLog.append("?");
                        }
                    } else {
                        this.sqlLog.append("?");
                    }
                }
                ++n;
                this.sqlLog.append(stringTokenizer.nextToken());
            }
            this.sqlLog.append("; ");
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    protected boolean isTrace() {
        boolean bl = this.getConnectionPool().isConnectionListenedTo() || this.getConnectionPool().getDefinition().isTrace() && this.getConnectionPool().getLog().isDebugEnabled();
        return bl;
    }

    protected void setSqlStatementIfNull(String string) {
        if (this.sqlStatement == null) {
            this.sqlStatement = string;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

