/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.logging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.logicalcobwebs.logging.Log;

public class SimpleLog
implements Log {
    protected static final String SYSTEM_PREFIX = "org.apache.commons.logging.simplelog.";
    protected static final Properties SIMLE_LOG_PROPS = new Properties();
    private static boolean showLogName = false;
    private static boolean showShortName = true;
    private static boolean showDateTime = false;
    private static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    private String logName = null;
    private int currentLogLevel;
    private String prefix = null;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$logicalcobwebs$logging$impl$SimpleLog;

    public SimpleLog(String string) {
        this.logName = string;
        this.setLevel(3);
        String string2 = SIMLE_LOG_PROPS.getProperty("org.apache.commons.logging.simplelog.log." + this.logName);
        int n = String.valueOf(string).lastIndexOf(".");
        while (null == string2 && n > -1) {
            string = string.substring(0, n);
            string2 = SIMLE_LOG_PROPS.getProperty("org.apache.commons.logging.simplelog.log." + string);
            n = String.valueOf(string).lastIndexOf(".");
        }
        if (null == string2) {
            string2 = SIMLE_LOG_PROPS.getProperty("org.apache.commons.logging.simplelog.defaultlog");
        }
        if ("all".equalsIgnoreCase(string2)) {
            this.setLevel(0);
        } else if ("trace".equalsIgnoreCase(string2)) {
            this.setLevel(1);
        } else if ("debug".equalsIgnoreCase(string2)) {
            this.setLevel(2);
        } else if ("info".equalsIgnoreCase(string2)) {
            this.setLevel(3);
        } else if ("warn".equalsIgnoreCase(string2)) {
            this.setLevel(4);
        } else if ("error".equalsIgnoreCase(string2)) {
            this.setLevel(5);
        } else if ("fatal".equalsIgnoreCase(string2)) {
            this.setLevel(6);
        } else if ("off".equalsIgnoreCase(string2)) {
            this.setLevel(7);
        }
    }

    public void setLevel(int n) {
        this.currentLogLevel = n;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    protected void log(int n, Object object, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (showDateTime) {
            stringBuffer.append(dateFormatter.format(new Date()));
            stringBuffer.append(" ");
        }
        switch (n) {
            case 1: {
                stringBuffer.append("[TRACE] ");
                break;
            }
            case 2: {
                stringBuffer.append("[DEBUG] ");
                break;
            }
            case 3: {
                stringBuffer.append("[INFO] ");
                break;
            }
            case 4: {
                stringBuffer.append("[WARN] ");
                break;
            }
            case 5: {
                stringBuffer.append("[ERROR] ");
                break;
            }
            case 6: {
                stringBuffer.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.prefix == null) {
                this.prefix = this.logName.substring(this.logName.lastIndexOf(".") + 1) + " - ";
                this.prefix = this.prefix.substring(this.prefix.lastIndexOf("/") + 1) + "-";
            }
            stringBuffer.append(this.prefix);
        } else if (showLogName) {
            stringBuffer.append(String.valueOf(this.logName)).append(" - ");
        }
        stringBuffer.append(String.valueOf(object));
        if (throwable != null) {
            stringBuffer.append(" <");
            stringBuffer.append(throwable.toString());
            stringBuffer.append(">");
            throwable.printStackTrace();
        }
        System.err.println(stringBuffer.toString());
    }

    protected boolean isLevelEnabled(int n) {
        return n >= this.currentLogLevel;
    }

    public final void debug(Object object) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, null);
        }
    }

    public final void debug(Object object, Throwable throwable) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, throwable);
        }
    }

    public final void trace(Object object) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, null);
        }
    }

    public final void trace(Object object, Throwable throwable) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, throwable);
        }
    }

    public final void info(Object object) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, null);
        }
    }

    public final void info(Object object, Throwable throwable) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, throwable);
        }
    }

    public final void warn(Object object) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, null);
        }
    }

    public final void warn(Object object, Throwable throwable) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, throwable);
        }
    }

    public final void error(Object object) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, null);
        }
    }

    public final void error(Object object, Throwable throwable) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, throwable);
        }
    }

    public final void fatal(Object object) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, null);
        }
    }

    public final void fatal(Object object, Throwable throwable) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, throwable);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string;
            Object object;
            Object object2;
            Enumeration<?> enumeration = System.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                if (null == object2 || !((String)object2).startsWith(SYSTEM_PREFIX)) continue;
                SIMLE_LOG_PROPS.setProperty((String)object2, System.getProperty((String)object2));
            }
            object2 = null;
            try {
                object = (class$java$lang$Thread == null ? (class$java$lang$Thread = SimpleLog.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
                object2 = (ClassLoader)((Method)object).invoke((Object)Thread.currentThread(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 == null) {
                object2 = (class$org$logicalcobwebs$logging$impl$SimpleLog == null ? (class$org$logicalcobwebs$logging$impl$SimpleLog = SimpleLog.class$("org.logicalcobwebs.logging.impl.SimpleLog")) : class$org$logicalcobwebs$logging$impl$SimpleLog).getClassLoader();
            }
            if (null != (object = ((ClassLoader)object2).getResourceAsStream("simplelog.properties"))) {
                try {
                    SIMLE_LOG_PROPS.load((InputStream)object);
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((string = SIMLE_LOG_PROPS.getProperty("org.apache.commons.logging.simplelog.showlogname")) != null) {
                showLogName = "true".equalsIgnoreCase(string);
            }
            if ((string = SIMLE_LOG_PROPS.getProperty("org.apache.commons.logging.simplelog.showShortLogname")) != null) {
                showShortName = "true".equalsIgnoreCase(string);
            }
            if ((string = SIMLE_LOG_PROPS.getProperty("org.apache.commons.logging.simplelog.showdatetime")) != null) {
                showDateTime = "true".equalsIgnoreCase(string);
            }
            if (showDateTime) {
                dateFormatter = new SimpleDateFormat(SIMLE_LOG_PROPS.getProperty("org.apache.commons.logging.simplelog.dateformat", "yyyy/MM/dd HH:mm:ss:SSS zzz"));
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

