/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.logging.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogConfigurationException;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.logging.impl.MyPrivilegedAction;

public class LogFactoryImpl
extends LogFactory {
    public static final String LOG_DEFAULT = "org.logicalcobwebs.logging.impl.SimpleLog";
    public static final String LOG_PROPERTY = "org.logicalcobwebs.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "org.apache.commons.logging.log";
    private Hashtable attributes = new Hashtable();
    private Hashtable instances = new Hashtable();
    private Constructor logConstructor = null;
    private LogFactory proxyFactory = null;
    private Class[] logConstructorSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LogFactoryImpl.class$("java.lang.String")) : class$java$lang$String};
    private Method logMethod = null;
    private Class[] logMethodSignature = new Class[]{class$org$logicalcobwebs$logging$LogFactory == null ? (class$org$logicalcobwebs$logging$LogFactory = LogFactoryImpl.class$("org.logicalcobwebs.logging.LogFactory")) : class$org$logicalcobwebs$logging$LogFactory};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$logicalcobwebs$logging$LogFactory;
    static /* synthetic */ Class class$org$logicalcobwebs$logging$Log;

    public LogFactoryImpl() {
        this.guessConfig();
    }

    public Object getAttribute(String string) {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getAttribute(string);
        }
        return this.attributes.get(string);
    }

    public String[] getAttributeNames() {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getAttributeNames();
        }
        Vector vector = new Vector();
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getInstance(clazz);
        }
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String string) throws LogConfigurationException {
        if (this.proxyFactory != null) {
            return this.proxyFactory.getInstance(string);
        }
        Log log = (Log)this.instances.get(string);
        if (log == null) {
            log = this.newInstance(string);
            this.instances.put(string, log);
        }
        return log;
    }

    public void release() {
        if (this.proxyFactory != null) {
            this.proxyFactory.release();
        }
        this.instances.clear();
    }

    public void removeAttribute(String string) {
        if (this.proxyFactory != null) {
            this.proxyFactory.removeAttribute(string);
        }
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (this.proxyFactory != null) {
            this.proxyFactory.setAttribute(string, object);
        }
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
    }

    protected Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor != null) {
            return this.logConstructor;
        }
        String string = null;
        if (string == null) {
            string = (String)this.getAttribute(LOG_PROPERTY);
        }
        if (string == null) {
            string = (String)this.getAttribute(LOG_PROPERTY_OLD);
        }
        if (string == null) {
            try {
                string = System.getProperty(LOG_PROPERTY);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (string == null) {
            try {
                string = System.getProperty(LOG_PROPERTY_OLD);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (string == null && this.isLog4JAvailable()) {
            string = "org.logicalcobwebs.logging.impl.Log4JCategoryLog";
        }
        if (string == null && this.isJdk14Available()) {
            string = "org.logicalcobwebs.logging.impl.Jdk14Logger";
        }
        if (string == null) {
            string = LOG_DEFAULT;
        }
        Class clazz = null;
        try {
            clazz = LogFactoryImpl.loadClass(string);
            if (clazz == null) {
                throw new LogConfigurationException("No suitable Log implementation for " + string);
            }
            if (!(class$org$logicalcobwebs$logging$Log == null ? (class$org$logicalcobwebs$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$logicalcobwebs$logging$Log).isAssignableFrom(clazz)) {
                throw new LogConfigurationException("Class " + string + " does not implement Log");
            }
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException(throwable);
        }
        try {
            this.logMethod = clazz.getMethod("setLogFactory", this.logMethodSignature);
        }
        catch (Throwable throwable) {
            this.logMethod = null;
        }
        try {
            this.logConstructor = clazz.getConstructor(this.logConstructorSignature);
            return this.logConstructor;
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException("No suitable Log constructor " + this.logConstructorSignature + " for " + string, throwable);
        }
    }

    private static Class loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = LogFactoryImpl.getContextClassLoader();
        Object t = AccessController.doPrivileged(new MyPrivilegedAction(classLoader, string));
        if (t instanceof Class) {
            return (Class)t;
        }
        throw (ClassNotFoundException)t;
    }

    protected void guessConfig() {
        if (this.isLog4JAvailable()) {
            this.proxyFactory = null;
            try {
                Class clazz = LogFactoryImpl.loadClass("org.logicalcobwebs.logging.impl.Log4jFactory");
                if (clazz != null) {
                    this.proxyFactory = (LogFactory)clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected boolean isJdk14Available() {
        try {
            LogFactoryImpl.loadClass("java.util.logging.Logger");
            LogFactoryImpl.loadClass("org.logicalcobwebs.logging.impl.Jdk14Logger");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean isLog4JAvailable() {
        try {
            LogFactoryImpl.loadClass("org.apache.log4j.Category");
            LogFactoryImpl.loadClass("org.logicalcobwebs.logging.impl.Log4JCategoryLog");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected Log newInstance(String string) throws LogConfigurationException {
        Log log = null;
        try {
            Object[] objectArray = new Object[]{string};
            log = (Log)this.getLogConstructor().newInstance(objectArray);
            if (this.logMethod != null) {
                objectArray[0] = this;
                this.logMethod.invoke((Object)log, objectArray);
            }
            return log;
        }
        catch (Throwable throwable) {
            throw new LogConfigurationException(throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

