/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.logging.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.logicalcobwebs.logging.Log;

public final class Jdk14Logger
implements Log {
    private Object logger = null;
    private Method logpMethod = null;
    private Method logpExMethod = null;
    private Method isLoggableMethod = null;
    private Method getStackTraceMethod = null;
    private Method getClassNameMethod = null;
    private Method getMethodNameMethod = null;
    private Object levelFINEST = null;
    private Object levelFINE = null;
    private Object levelINFO = null;
    private Object levelWARNING = null;
    private Object levelSEVERE = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;

    public Jdk14Logger(String string) {
        try {
            Class<?> clazz = Class.forName("java.util.logging.Logger");
            Class<?> clazz2 = Class.forName("java.util.logging.Level");
            Method method = clazz.getMethod("getLogger", class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String);
            this.logger = method.invoke(null, string);
            this.logpMethod = this.logger.getClass().getMethod("logp", clazz2, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String);
            this.logpExMethod = this.logger.getClass().getMethod("logp", clazz2, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Jdk14Logger.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            this.isLoggableMethod = clazz.getMethod("isLoggable", clazz2);
            this.getStackTraceMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = Jdk14Logger.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getStackTrace", null);
            Class<?> clazz3 = Class.forName("java.lang.StackTraceElement");
            this.getClassNameMethod = clazz3.getMethod("getClassName", null);
            this.getMethodNameMethod = clazz3.getMethod("getMethodName", null);
            this.levelFINEST = clazz2.getField("FINEST").get(null);
            this.levelFINE = clazz2.getField("FINE").get(null);
            this.levelINFO = clazz2.getField("INFO").get(null);
            this.levelWARNING = clazz2.getField("WARNING").get(null);
            this.levelSEVERE = clazz2.getField("SEVERE").get(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException("Could not create Jdk14Logger: " + throwable.getMessage());
        }
    }

    private void log(Object object, String string, Throwable throwable) {
        Throwable throwable2 = new Throwable();
        String string2 = "unknown";
        String string3 = "unknown";
        try {
            Object[] objectArray = (Object[])this.getStackTraceMethod.invoke((Object)throwable2, null);
            if (objectArray != null && objectArray.length > 2) {
                string2 = (String)this.getClassNameMethod.invoke(objectArray[2], null);
                string3 = (String)this.getMethodNameMethod.invoke(objectArray[2], null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        try {
            if (throwable == null) {
                this.logpMethod.invoke(this.logger, object, string2, string3, string);
            } else {
                this.logpExMethod.invoke(this.logger, object, string2, string3, string, throwable);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Logging of message '" + string + "' failed" + (throwable != null ? ":" + throwable.getMessage() : "."));
        }
    }

    public void debug(Object object) {
        this.log(this.levelFINE, String.valueOf(object), null);
    }

    public void debug(Object object, Throwable throwable) {
        this.log(this.levelFINE, String.valueOf(object), throwable);
    }

    public void error(Object object) {
        this.log(this.levelSEVERE, String.valueOf(object), null);
    }

    public void error(Object object, Throwable throwable) {
        this.log(this.levelSEVERE, String.valueOf(object), throwable);
    }

    public void fatal(Object object) {
        this.log(this.levelSEVERE, String.valueOf(object), null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log(this.levelSEVERE, String.valueOf(object), throwable);
    }

    public void info(Object object) {
        this.log(this.levelINFO, String.valueOf(object), null);
    }

    public void info(Object object, Throwable throwable) {
        this.log(this.levelINFO, String.valueOf(object), throwable);
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(this.levelFINE);
    }

    public boolean isErrorEnabled() {
        return this.isLoggable(this.levelSEVERE);
    }

    public boolean isFatalEnabled() {
        return this.isLoggable(this.levelSEVERE);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(this.levelINFO);
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(this.levelFINEST);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(this.levelWARNING);
    }

    public void trace(Object object) {
        this.log(this.levelFINEST, String.valueOf(object), null);
    }

    public void trace(Object object, Throwable throwable) {
        this.log(this.levelFINEST, String.valueOf(object), throwable);
    }

    public void warn(Object object) {
        this.log(this.levelWARNING, String.valueOf(object), null);
    }

    public void warn(Object object, Throwable throwable) {
        this.log(this.levelWARNING, String.valueOf(object), throwable);
    }

    private boolean isLoggable(Object object) {
        try {
            return (Boolean)this.isLoggableMethod.invoke(this.logger, object);
        }
        catch (Exception exception) {
            throw new RuntimeException("isLoggable call failed: " + exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

