/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogConfigurationException;

public abstract class LogFactory {
    public static final String FACTORY_PROPERTY = "org.logicalcobwebs.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.logicalcobwebs.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.logicalcobwebs.logging.LogFactory";
    private static Hashtable factories = new Hashtable();
    static /* synthetic */ Class class$org$logicalcobwebs$logging$LogFactory;
    static /* synthetic */ Class class$java$lang$Thread;

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public static LogFactory getFactory() throws LogConfigurationException {
        String string;
        Object object;
        Object object2;
        LogFactory logFactory;
        ClassLoader classLoader;
        block20: {
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return LogFactory.getContextClassLoader();
                }
            });
            logFactory = LogFactory.getCachedFactory(classLoader);
            if (logFactory != null) {
                return logFactory;
            }
            try {
                object2 = System.getProperty(FACTORY_PROPERTY);
                if (object2 != null) {
                    logFactory = LogFactory.newFactory((String)object2, classLoader);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (logFactory == null) {
                try {
                    Object object3 = object2 = classLoader == null ? ClassLoader.getSystemResourceAsStream(SERVICE_ID) : classLoader.getResourceAsStream(SERVICE_ID);
                    if (object2 == null) break block20;
                    try {
                        object = new BufferedReader(new InputStreamReader((InputStream)object2, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        object = new BufferedReader(new InputStreamReader((InputStream)object2));
                    }
                    string = ((BufferedReader)object).readLine();
                    ((BufferedReader)object).close();
                    if (string != null && !"".equals(string)) {
                        logFactory = LogFactory.newFactory(string, classLoader);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object2 = null;
        try {
            Object object4 = object = classLoader == null ? ClassLoader.getSystemResourceAsStream(FACTORY_PROPERTIES) : classLoader.getResourceAsStream(FACTORY_PROPERTIES);
            if (object != null) {
                object2 = new Properties();
                ((Properties)object2).load((InputStream)object);
                ((InputStream)object).close();
                string = ((Properties)object2).getProperty(FACTORY_PROPERTY);
                if (logFactory == null) {
                    if (string == null) {
                        string = FACTORY_DEFAULT;
                    }
                    logFactory = LogFactory.newFactory(string, classLoader);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (logFactory == null) {
            logFactory = LogFactory.newFactory(FACTORY_DEFAULT, (class$org$logicalcobwebs$logging$LogFactory == null ? (class$org$logicalcobwebs$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$logicalcobwebs$logging$LogFactory).getClassLoader());
        }
        if (logFactory != null) {
            LogFactory.cacheFactory(classLoader, logFactory);
        }
        if (object2 != null) {
            object = ((Properties)object2).propertyNames();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                String string2 = ((Properties)object2).getProperty(string);
                logFactory.setAttribute(string, string2);
            }
        }
        return logFactory;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            Enumeration enumeration = factories.elements();
            while (enumeration.hasMoreElements()) {
                LogFactory logFactory = (LogFactory)enumeration.nextElement();
                logFactory.release();
            }
            factories.clear();
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = LogFactory.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new LogConfigurationException("Unexpected IllegalAccessException", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!(invocationTargetException.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", invocationTargetException.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classLoader = (class$org$logicalcobwebs$logging$LogFactory == null ? (class$org$logicalcobwebs$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$logicalcobwebs$logging$LogFactory).getClassLoader();
        }
        return classLoader;
    }

    private static LogFactory getCachedFactory(ClassLoader classLoader) {
        LogFactory logFactory = null;
        if (classLoader != null) {
            logFactory = (LogFactory)factories.get(classLoader);
        }
        return logFactory;
    }

    private static void cacheFactory(ClassLoader classLoader, LogFactory logFactory) {
        if (classLoader != null && logFactory != null) {
            factories.put(classLoader, logFactory);
        }
    }

    protected static LogFactory newFactory(String string, ClassLoader classLoader) throws LogConfigurationException {
        try {
            Class<?> clazz;
            block5: {
                if (classLoader == null) {
                    classLoader = (class$org$logicalcobwebs$logging$LogFactory == null ? (class$org$logicalcobwebs$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$logicalcobwebs$logging$LogFactory).getClassLoader();
                }
                clazz = null;
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (classLoader == (class$org$logicalcobwebs$logging$LogFactory == null ? (class$org$logicalcobwebs$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$logicalcobwebs$logging$LogFactory).getClassLoader()) break block5;
                    classLoader = (class$org$logicalcobwebs$logging$LogFactory == null ? (class$org$logicalcobwebs$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$logicalcobwebs$logging$LogFactory).getClassLoader();
                    clazz = classLoader.loadClass(string);
                }
            }
            LogFactory logFactory = (LogFactory)clazz.newInstance();
            return logFactory;
        }
        catch (Exception exception) {
            throw new LogConfigurationException(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

