/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.Block;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.CollectionUtils;
import org.logicalcobwebs.cglib.core.Constants;
import org.logicalcobwebs.cglib.core.DuplicatesPredicate;
import org.logicalcobwebs.cglib.core.EmitUtils;
import org.logicalcobwebs.cglib.core.ObjectSwitchCallback;
import org.logicalcobwebs.cglib.core.Predicate;
import org.logicalcobwebs.cglib.core.ProcessSwitchCallback;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.Transformer;
import org.logicalcobwebs.cglib.core.TypeUtils;
import org.logicalcobwebs.cglib.core.VisibilityPredicate;

class FastClassEmitter
extends ClassEmitter {
    private static final Signature CSTRUCT_CLASS = TypeUtils.parseConstructor("Class");
    private static final Signature METHOD_GET_INDEX = TypeUtils.parseSignature("int getIndex(String, Class[])");
    private static final Signature SIGNATURE_GET_INDEX = TypeUtils.parseSignature("int getIndex(org.logicalcobwebs.cglib.core.Signature)");
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature CONSTRUCTOR_GET_INDEX = TypeUtils.parseSignature("int getIndex(Class[])");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(int, Object, Object[])");
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(int, Object[])");
    private static final Signature GET_MAX_INDEX = TypeUtils.parseSignature("int getMaxIndex()");
    private static final Signature GET_SIGNATURE_WITHOUT_RETURN_TYPE = TypeUtils.parseSignature("String getSignatureWithoutReturnType(String, Class[])");
    private static final Type FAST_CLASS = TypeUtils.parseType("org.logicalcobwebs.cglib.reflect.FastClass");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type INVOCATION_TARGET_EXCEPTION = TypeUtils.parseType("java.lang.reflect.InvocationTargetException");
    private static final Type[] INVOCATION_TARGET_EXCEPTION_ARRAY = new Type[]{INVOCATION_TARGET_EXCEPTION};
    private static final int TOO_MANY_METHODS = 100;

    public FastClassEmitter(ClassVisitor classVisitor, String string, Class clazz) {
        super(classVisitor);
        this.begin_class(1, string, FAST_CLASS, null, "<generated>");
        CodeEmitter codeEmitter = this.begin_method(1, CSTRUCT_CLASS, null, null);
        codeEmitter.load_this();
        codeEmitter.load_args();
        codeEmitter.super_invoke_constructor(CSTRUCT_CLASS);
        codeEmitter.return_value();
        codeEmitter.end_method();
        VisibilityPredicate visibilityPredicate = new VisibilityPredicate(clazz, false);
        List list = ReflectUtils.addAllMethods(clazz, new ArrayList());
        CollectionUtils.filter(list, (Predicate)visibilityPredicate);
        CollectionUtils.filter(list, (Predicate)new DuplicatesPredicate());
        Object[] objectArray = list.toArray(new Method[list.size()]);
        Object[] objectArray2 = (Constructor[])CollectionUtils.filter(clazz.getDeclaredConstructors(), (Predicate)visibilityPredicate);
        this.emitIndexBySignature((Method[])objectArray);
        this.emitIndexByClassArray((Method[])objectArray);
        codeEmitter = this.begin_method(1, CONSTRUCTOR_GET_INDEX, null, null);
        codeEmitter.load_args();
        EmitUtils.constructor_switch(codeEmitter, (Constructor[])objectArray2, new GetIndexCallback(codeEmitter, objectArray2));
        codeEmitter.end_method();
        codeEmitter = this.begin_method(1, INVOKE, INVOCATION_TARGET_EXCEPTION_ARRAY, null);
        codeEmitter.load_arg(1);
        codeEmitter.checkcast(Type.getType(clazz));
        codeEmitter.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(codeEmitter, objectArray, 2);
        codeEmitter.end_method();
        codeEmitter = this.begin_method(1, NEW_INSTANCE, INVOCATION_TARGET_EXCEPTION_ARRAY, null);
        codeEmitter.new_instance(Type.getType(clazz));
        codeEmitter.dup();
        codeEmitter.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(codeEmitter, objectArray2, 1);
        codeEmitter.end_method();
        codeEmitter = this.begin_method(1, GET_MAX_INDEX, null, null);
        codeEmitter.push(objectArray.length - 1);
        codeEmitter.return_value();
        codeEmitter.end_method();
        this.end_class();
    }

    private void emitIndexBySignature(Method[] methodArray) {
        CodeEmitter codeEmitter = this.begin_method(1, SIGNATURE_GET_INDEX, null, null);
        List list = CollectionUtils.transform(Arrays.asList(methodArray), new Transformer(){

            public Object transform(Object object) {
                return ReflectUtils.getSignature((Method)object).toString();
            }
        });
        codeEmitter.load_arg(0);
        codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        this.signatureSwitchHelper(codeEmitter, list);
        codeEmitter.end_method();
    }

    private void emitIndexByClassArray(Method[] methodArray) {
        CodeEmitter codeEmitter = this.begin_method(1, METHOD_GET_INDEX, null, null);
        if (methodArray.length > 100) {
            List list = CollectionUtils.transform(Arrays.asList(methodArray), new Transformer(){

                public Object transform(Object object) {
                    String string = ReflectUtils.getSignature((Method)object).toString();
                    return string.substring(0, string.lastIndexOf(41) + 1);
                }
            });
            codeEmitter.load_args();
            codeEmitter.invoke_static(FAST_CLASS, GET_SIGNATURE_WITHOUT_RETURN_TYPE);
            this.signatureSwitchHelper(codeEmitter, list);
        } else {
            codeEmitter.load_args();
            EmitUtils.method_switch(codeEmitter, methodArray, new GetIndexCallback(codeEmitter, methodArray));
        }
        codeEmitter.end_method();
    }

    private void signatureSwitchHelper(final CodeEmitter codeEmitter, final List list) {
        ObjectSwitchCallback objectSwitchCallback = new ObjectSwitchCallback(){

            public void processCase(Object object, Label label) {
                codeEmitter.push(list.indexOf(object));
                codeEmitter.return_value();
            }

            public void processDefault() {
                codeEmitter.push(-1);
                codeEmitter.return_value();
            }
        };
        EmitUtils.string_switch(codeEmitter, list.toArray(new String[list.size()]), 1, objectSwitchCallback);
    }

    private static void invokeSwitchHelper(final CodeEmitter codeEmitter, final Object[] objectArray, final int n) {
        final Label label = codeEmitter.make_label();
        Block block = codeEmitter.begin_block();
        codeEmitter.process_switch(FastClassEmitter.getIntRange(objectArray.length), new ProcessSwitchCallback(){

            public void processCase(int n2, Label label2) {
                Member member = (Member)objectArray[n2];
                Signature signature = ReflectUtils.getSignature(member);
                Type[] typeArray = signature.getArgumentTypes();
                for (int i = 0; i < typeArray.length; ++i) {
                    codeEmitter.load_arg(n);
                    codeEmitter.aaload(i);
                    codeEmitter.unbox(typeArray[i]);
                }
                if (member instanceof Method) {
                    codeEmitter.invoke((Method)member);
                    codeEmitter.box(Type.getType(((Method)member).getReturnType()));
                } else {
                    codeEmitter.invoke_constructor(Type.getType(member.getDeclaringClass()), signature);
                }
                codeEmitter.return_value();
            }

            public void processDefault() {
                codeEmitter.goTo(label);
            }
        });
        block.end();
        EmitUtils.wrap_throwable(block, INVOCATION_TARGET_EXCEPTION);
        codeEmitter.mark(label);
        codeEmitter.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Cannot find matching method/constructor");
    }

    private static int[] getIntRange(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private static class GetIndexCallback
    implements ObjectSwitchCallback {
        private CodeEmitter e;
        private Map indexes = new HashMap();

        public GetIndexCallback(CodeEmitter codeEmitter, Object[] objectArray) {
            this.e = codeEmitter;
            for (int i = 0; i < objectArray.length; ++i) {
                this.indexes.put(objectArray[i], new Integer(i));
            }
        }

        public void processCase(Object object, Label label) {
            this.e.push((Integer)this.indexes.get(object));
            this.e.return_value();
        }

        public void processDefault() {
            this.e.push(-1);
            this.e.return_value();
        }
    }
}

