/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.Constants;
import org.logicalcobwebs.cglib.core.EmitUtils;
import org.logicalcobwebs.cglib.core.Local;
import org.logicalcobwebs.cglib.core.ObjectSwitchCallback;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;
import org.logicalcobwebs.cglib.proxy.CallbackGenerator;

class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String FIND_PROXY_NAME = "CGLIB$findMethodProxy";
    static final Class[] FIND_PROXY_TYPES = new Class[]{class$org$logicalcobwebs$cglib$core$Signature == null ? (class$org$logicalcobwebs$cglib$core$Signature = MethodInterceptorGenerator.class$("org.logicalcobwebs.cglib.core.Signature")) : class$org$logicalcobwebs$cglib$core$Signature};
    private static final Signature FIND_PROXY = new Signature("CGLIB$findMethodProxy", TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.MethodProxy"), TypeUtils.getTypes(FIND_PROXY_TYPES));
    private static final Type ABSTRACT_METHOD_ERROR = TypeUtils.parseType("AbstractMethodError");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Type METHOD_PROXY = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.MethodProxy");
    private static final Type METHOD_INTERCEPTOR = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.MethodInterceptor");
    private static final Signature GET_DECLARING_CLASS = TypeUtils.parseSignature("Class getDeclaringClass()");
    private static final Signature GET_CLASS_LOADER = TypeUtils.parseSignature("ClassLoader getClassLoader()");
    private static final Signature MAKE_PROXY = TypeUtils.parseSignature("org.logicalcobwebs.cglib.proxy.MethodProxy create(ClassLoader, Class, Class, String, String, String)");
    private static final Signature INTERCEPT = TypeUtils.parseSignature("Object intercept(Object, java.lang.reflect.Method, Object[], org.logicalcobwebs.cglib.proxy.MethodProxy)");
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    static /* synthetic */ Class class$org$logicalcobwebs$cglib$core$Signature;

    MethodInterceptorGenerator() {
    }

    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = context.getMethods();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            String string = this.getAccessName(context, method);
            String string2 = this.getFieldName(context, method);
            hashMap.put(ReflectUtils.getSignature(method).toString(), string);
            classEmitter.declare_field(26, string2, METHOD, null, null);
            classEmitter.declare_field(26, string, METHOD_PROXY, null, null);
            CodeEmitter codeEmitter = classEmitter.begin_method(16, new Signature(this.getAccessName(context, method), ReflectUtils.getSignature(method).getDescriptor()), ReflectUtils.getExceptionTypes(method), null);
            if (Modifier.isAbstract(method.getModifiers())) {
                codeEmitter.throw_exception(ABSTRACT_METHOD_ERROR, method.toString() + " is abstract");
            } else {
                codeEmitter.load_this();
                codeEmitter.load_args();
                codeEmitter.super_invoke(ReflectUtils.getSignature(method));
            }
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = classEmitter.begin_method(context.getModifiers(method), ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            Label label = codeEmitter.make_label();
            context.emitCallback(codeEmitter, context.getIndex(method));
            codeEmitter.dup();
            codeEmitter.ifnull(label);
            codeEmitter.load_this();
            codeEmitter.getfield(string2);
            codeEmitter.create_arg_array();
            codeEmitter.getfield(string);
            codeEmitter.invoke_interface(METHOD_INTERCEPTOR, INTERCEPT);
            codeEmitter.unbox_or_zero(Type.getType(method.getReturnType()));
            codeEmitter.return_value();
            codeEmitter.mark(label);
            codeEmitter.load_this();
            codeEmitter.load_args();
            codeEmitter.super_invoke(ReflectUtils.getSignature(method));
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
        this.generateFindProxy(classEmitter, hashMap);
    }

    private String getFieldName(CallbackGenerator.Context context, Method method) {
        return "CGLIB$$METHOD_" + context.getUniqueName(method);
    }

    private String getAccessName(CallbackGenerator.Context context, Method method) {
        return "CGLIB$$ACCESS_" + context.getUniqueName(method);
    }

    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context) {
        Local local = codeEmitter.make_local();
        EmitUtils.load_class_this(codeEmitter);
        codeEmitter.dup();
        codeEmitter.store_local(local);
        codeEmitter.invoke_virtual(Constants.TYPE_CLASS, GET_CLASS_LOADER);
        Iterator iterator = context.getMethods();
        while (iterator.hasNext()) {
            codeEmitter.dup();
            Method method = (Method)iterator.next();
            EmitUtils.load_method(codeEmitter, method);
            codeEmitter.dup();
            codeEmitter.putfield(this.getFieldName(context, method));
            String string = this.getAccessName(context, method);
            Signature signature = ReflectUtils.getSignature(method);
            codeEmitter.invoke_virtual(METHOD, GET_DECLARING_CLASS);
            codeEmitter.load_local(local);
            codeEmitter.push(signature.getDescriptor());
            codeEmitter.push(signature.getName());
            codeEmitter.push(string);
            codeEmitter.invoke_static(METHOD_PROXY, MAKE_PROXY);
            codeEmitter.putfield(string);
        }
    }

    public void generateFindProxy(ClassEmitter classEmitter, final Map map) {
        final CodeEmitter codeEmitter = classEmitter.begin_method(9, FIND_PROXY, null, null);
        codeEmitter.load_arg(0);
        codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        ObjectSwitchCallback objectSwitchCallback = new ObjectSwitchCallback(){

            public void processCase(Object object, Label label) {
                codeEmitter.getfield((String)map.get(object));
                codeEmitter.return_value();
            }

            public void processDefault() {
                codeEmitter.aconst_null();
                codeEmitter.return_value();
            }
        };
        EmitUtils.string_switch(codeEmitter, map.keySet().toArray(new String[0]), 1, objectSwitchCallback);
        codeEmitter.end_method();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

