/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.Constants;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;
import org.logicalcobwebs.cglib.proxy.CallbackGenerator;

class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Type LAZY_LOADER = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.LazyLoader");

    LazyLoaderGenerator() {
    }

    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context) {
        CodeEmitter codeEmitter;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = context.getMethods();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (Modifier.isProtected(method.getModifiers())) continue;
            int n = context.getIndex(method);
            hashSet.add(new Integer(n));
            codeEmitter = classEmitter.begin_method(context.getModifiers(method), ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            codeEmitter.load_this();
            codeEmitter.dup();
            codeEmitter.invoke_virtual_this(this.loadMethod(n));
            codeEmitter.checkcast(Type.getType(method.getDeclaringClass()));
            codeEmitter.load_args();
            codeEmitter.invoke(method);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            String string = "CGLIB$LAZY_LOADER_" + n;
            classEmitter.declare_field(2, string, Constants.TYPE_OBJECT, null, null);
            codeEmitter = classEmitter.begin_method(50, this.loadMethod(n), null, null);
            codeEmitter.load_this();
            codeEmitter.getfield(string);
            codeEmitter.dup();
            Label label = codeEmitter.make_label();
            codeEmitter.ifnonnull(label);
            codeEmitter.pop();
            codeEmitter.load_this();
            context.emitCallback(codeEmitter, n);
            codeEmitter.invoke_interface(LAZY_LOADER, LOAD_OBJECT);
            codeEmitter.dup_x1();
            codeEmitter.putfield(string);
            codeEmitter.mark(label);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    private Signature loadMethod(int n) {
        return new Signature("CGLIB$LOAD_PRIVATE_" + n, Constants.TYPE_OBJECT, Constants.TYPES_EMPTY);
    }

    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context) {
    }
}

