/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.CodeGenerationException;
import org.logicalcobwebs.cglib.core.CollectionUtils;
import org.logicalcobwebs.cglib.core.DuplicatesPredicate;
import org.logicalcobwebs.cglib.core.EmitUtils;
import org.logicalcobwebs.cglib.core.MethodWrapper;
import org.logicalcobwebs.cglib.core.ObjectSwitchCallback;
import org.logicalcobwebs.cglib.core.Predicate;
import org.logicalcobwebs.cglib.core.ProcessSwitchCallback;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;
import org.logicalcobwebs.cglib.core.VisibilityPredicate;
import org.logicalcobwebs.cglib.proxy.Callback;
import org.logicalcobwebs.cglib.proxy.CallbackFilter;
import org.logicalcobwebs.cglib.proxy.CallbackGenerator;
import org.logicalcobwebs.cglib.proxy.CallbackUtils;

class EnhancerEmitter
extends ClassEmitter {
    private static final String CONSTRUCTED_FIELD = "CGLIB$CONSTRUCTED";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type THREAD_LOCAL = TypeUtils.parseType("ThreadLocal");
    private static final Type FACTORY = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.Factory");
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature SET_THREAD_CALLBACKS = TypeUtils.parseSignature("void CGLIB$SET_THREAD_CALLBACKS(org.logicalcobwebs.cglib.proxy.Callback[])");
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(org.logicalcobwebs.cglib.proxy.Callback[])");
    private static final Signature MULTIARG_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(Class[], Object[], org.logicalcobwebs.cglib.proxy.Callback[])");
    private static final Signature SINGLE_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(org.logicalcobwebs.cglib.proxy.Callback)");
    private static final Signature COPY_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance()");
    private static final Signature COPY_MULTIARG_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(Class[], Object[])");
    private static final Signature SET_CALLBACK = TypeUtils.parseSignature("void setCallback(int, org.logicalcobwebs.cglib.proxy.Callback)");
    private static final Signature GET_CALLBACK = TypeUtils.parseSignature("org.logicalcobwebs.cglib.proxy.Callback getCallback(int)");
    private static final Signature SET_CALLBACKS = TypeUtils.parseSignature("void setCallbacks(org.logicalcobwebs.cglib.proxy.Callback[])");
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature("Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature("void set(Object)");
    private Class[] callbackTypes;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$logicalcobwebs$cglib$proxy$Factory;
    static /* synthetic */ Class array$Lorg$logicalcobwebs$cglib$proxy$Callback;

    public EnhancerEmitter(ClassVisitor classVisitor, String string, Class clazz, Class[] classArray, CallbackFilter callbackFilter, Class[] classArray2, boolean bl) throws Exception {
        super(classVisitor);
        if (clazz == null) {
            clazz = class$java$lang$Object == null ? (class$java$lang$Object = EnhancerEmitter.class$("java.lang.Object")) : class$java$lang$Object;
        }
        this.callbackTypes = classArray2;
        this.begin_class(1, string, Type.getType(clazz), bl ? TypeUtils.add(TypeUtils.getTypes(classArray), FACTORY) : TypeUtils.getTypes(classArray), "<generated>");
        ArrayList arrayList = new ArrayList(Arrays.asList(clazz.getDeclaredConstructors()));
        CollectionUtils.filter(arrayList, (Predicate)new VisibilityPredicate(clazz, true));
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("No visible constructors in " + clazz);
        }
        Constructor[] constructorArray = arrayList.toArray(new Constructor[arrayList.size()]);
        ArrayList arrayList2 = new ArrayList();
        ReflectUtils.addAllMethods(clazz, arrayList2);
        ArrayList arrayList3 = new ArrayList();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == (class$org$logicalcobwebs$cglib$proxy$Factory == null ? EnhancerEmitter.class$("org.logicalcobwebs.cglib.proxy.Factory") : class$org$logicalcobwebs$cglib$proxy$Factory)) continue;
                ReflectUtils.addAllMethods(classArray[i], arrayList3);
            }
        }
        Set set = MethodWrapper.createSet(arrayList3);
        arrayList2.addAll(arrayList3);
        CollectionUtils.filter(arrayList2, (Predicate)new VisibilityPredicate(clazz, true));
        CollectionUtils.filter(arrayList2, (Predicate)new DuplicatesPredicate());
        EnhancerEmitter.removeFinal(arrayList2);
        HashMap<CallbackGenerator, ArrayList<Method>> hashMap = new HashMap<CallbackGenerator, ArrayList<Method>>();
        HashMap<Method, Integer> hashMap2 = new HashMap<Method, Integer>();
        Object object = arrayList2.iterator();
        while (object.hasNext()) {
            Method method = (Method)object.next();
            int n = callbackFilter.accept(method);
            if (n >= classArray2.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + n);
            }
            hashMap2.put(method, new Integer(n));
            CallbackGenerator callbackGenerator = CallbackUtils.getGenerator(classArray2[n]);
            ArrayList<Method> arrayList4 = (ArrayList<Method>)hashMap.get(callbackGenerator);
            if (arrayList4 == null) {
                arrayList4 = new ArrayList<Method>(arrayList2.size());
                hashMap.put(callbackGenerator, arrayList4);
            }
            arrayList4.add(method);
        }
        this.declare_field(2, CONSTRUCTED_FIELD, Type.BOOLEAN_TYPE, null, null);
        this.emitMethods(hashMap, hashMap2, set);
        this.emitConstructors(constructorArray);
        this.emitSetThreadCallbacks();
        if (bl) {
            object = this.getCallbackKeys();
            this.emitNewInstanceCallbacks();
            this.emitNewInstanceCallback();
            this.emitNewInstanceMultiarg(constructorArray);
            this.emitNewInstanceCopy();
            this.emitNewInstanceMultiargCopy(constructorArray);
            this.emitGetCallback((int[])object);
            this.emitSetCallback((int[])object);
            this.emitSetCallbacks();
        }
        this.end_class();
    }

    static void setThreadCallbacks(Class clazz, Callback[] callbackArray) {
        try {
            Method method = clazz.getDeclaredMethod(SET_THREAD_CALLBACKS_NAME, array$Lorg$logicalcobwebs$cglib$proxy$Callback == null ? (array$Lorg$logicalcobwebs$cglib$proxy$Callback = EnhancerEmitter.class$("[Lorg.logicalcobwebs.cglib.proxy.Callback;")) : array$Lorg$logicalcobwebs$cglib$proxy$Callback);
            method.invoke(null, new Object[]{callbackArray});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(clazz + " is not an enhanced class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CodeGenerationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CodeGenerationException(invocationTargetException);
        }
    }

    private void emitConstructors(Constructor[] constructorArray) {
        for (int i = 0; i < constructorArray.length; ++i) {
            Signature signature = ReflectUtils.getSignature(constructorArray[i]);
            CodeEmitter codeEmitter = this.begin_method(1, signature, ReflectUtils.getExceptionTypes(constructorArray[i]), null);
            codeEmitter.load_this();
            codeEmitter.dup();
            codeEmitter.load_args();
            codeEmitter.super_invoke_constructor(signature);
            codeEmitter.push(1);
            codeEmitter.putfield(CONSTRUCTED_FIELD);
            for (int j = 0; j < this.callbackTypes.length; ++j) {
                codeEmitter.load_this();
                codeEmitter.dup();
                codeEmitter.getfield(EnhancerEmitter.getThreadLocal(j));
                codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
                codeEmitter.checkcast(Type.getType(this.callbackTypes[j]));
                codeEmitter.putfield(EnhancerEmitter.getCallbackField(j));
                codeEmitter.getfield(EnhancerEmitter.getThreadLocal(j));
                codeEmitter.aconst_null();
                codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
            }
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    private int[] getCallbackKeys() {
        int[] nArray = new int[this.callbackTypes.length];
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private void emitGetCallback(int[] nArray) {
        final CodeEmitter codeEmitter = this.begin_method(1, GET_CALLBACK, null, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        codeEmitter.process_switch(nArray, new ProcessSwitchCallback(){

            public void processCase(int n, Label label) {
                codeEmitter.getfield(EnhancerEmitter.getCallbackField(n));
                codeEmitter.goTo(label);
            }

            public void processDefault() {
                codeEmitter.pop();
                codeEmitter.aconst_null();
            }
        });
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitSetCallback(int[] nArray) {
        final CodeEmitter codeEmitter = this.begin_method(1, SET_CALLBACK, null, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(1);
        codeEmitter.dup();
        codeEmitter.load_arg(0);
        codeEmitter.process_switch(nArray, new ProcessSwitchCallback(){

            public void processCase(int n, Label label) {
                codeEmitter.getfield(EnhancerEmitter.getThreadLocal(n));
                codeEmitter.swap();
                codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
                codeEmitter.checkcast(Type.getType(EnhancerEmitter.this.callbackTypes[n]));
                codeEmitter.putfield(EnhancerEmitter.getCallbackField(n));
                codeEmitter.goTo(label);
            }

            public void processDefault() {
                codeEmitter.pop2();
                codeEmitter.pop();
            }
        });
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitSetCallbacks() {
        CodeEmitter codeEmitter = this.begin_method(1, SET_CALLBACKS, null, null);
        this.emitSetThreadCallbacks(codeEmitter);
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            codeEmitter.dup2();
            codeEmitter.aaload(i);
            codeEmitter.checkcast(Type.getType(this.callbackTypes[i]));
            codeEmitter.putfield(EnhancerEmitter.getCallbackField(i));
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitNewInstanceCallbacks() {
        CodeEmitter codeEmitter = this.begin_method(1, NEW_INSTANCE, null, null);
        codeEmitter.load_arg(0);
        codeEmitter.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonNewInstance(codeEmitter);
    }

    private void emitNewInstanceCopy() {
        CodeEmitter codeEmitter = this.begin_method(1, COPY_NEW_INSTANCE, null, null);
        this.emitCopyCallbacks(codeEmitter);
        this.emitCommonNewInstance(codeEmitter);
    }

    private void emitCopyCallbacks(CodeEmitter codeEmitter) {
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            codeEmitter.getfield(EnhancerEmitter.getThreadLocal(i));
            codeEmitter.load_this();
            codeEmitter.getfield(EnhancerEmitter.getCallbackField(i));
            codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        }
    }

    private void emitCommonNewInstance(CodeEmitter codeEmitter) {
        codeEmitter.new_instance_this();
        codeEmitter.dup();
        codeEmitter.invoke_constructor_this();
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitNewInstanceCallback() {
        CodeEmitter codeEmitter = this.begin_method(1, SINGLE_NEW_INSTANCE, null, null);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                codeEmitter.getfield(EnhancerEmitter.getThreadLocal(0));
                codeEmitter.load_arg(0);
                codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
                break;
            }
            default: {
                codeEmitter.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        this.emitCommonNewInstance(codeEmitter);
    }

    private void emitNewInstanceMultiarg(Constructor[] constructorArray) {
        CodeEmitter codeEmitter = this.begin_method(1, MULTIARG_NEW_INSTANCE, null, null);
        codeEmitter.load_arg(2);
        codeEmitter.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonMultiarg(constructorArray, codeEmitter);
    }

    private void emitNewInstanceMultiargCopy(Constructor[] constructorArray) {
        CodeEmitter codeEmitter = this.begin_method(1, COPY_MULTIARG_NEW_INSTANCE, null, null);
        this.emitCopyCallbacks(codeEmitter);
        this.emitCommonMultiarg(constructorArray, codeEmitter);
    }

    private void emitCommonMultiarg(Constructor[] constructorArray, final CodeEmitter codeEmitter) {
        codeEmitter.new_instance_this();
        codeEmitter.dup();
        codeEmitter.load_arg(0);
        EmitUtils.constructor_switch(codeEmitter, constructorArray, new ObjectSwitchCallback(){

            public void processCase(Object object, Label label) {
                Constructor constructor = (Constructor)object;
                Type[] typeArray = TypeUtils.getTypes(constructor.getParameterTypes());
                for (int i = 0; i < typeArray.length; ++i) {
                    codeEmitter.load_arg(1);
                    codeEmitter.push(i);
                    codeEmitter.aaload();
                    codeEmitter.unbox(typeArray[i]);
                }
                codeEmitter.invoke_constructor_this(ReflectUtils.getSignature(constructor));
                codeEmitter.goTo(label);
            }

            public void processDefault() {
                codeEmitter.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitMethods(Map map, final Map map2, final Set set) throws Exception {
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            this.declare_field(2, EnhancerEmitter.getCallbackField(i), Type.getType(this.callbackTypes[i]), null, null);
            this.declare_field(26, EnhancerEmitter.getThreadLocal(i), THREAD_LOCAL, null, null);
        }
        HashSet<CallbackGenerator> hashSet = new HashSet<CallbackGenerator>();
        CodeEmitter codeEmitter = this.begin_static();
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            codeEmitter.new_instance(THREAD_LOCAL);
            codeEmitter.dup();
            codeEmitter.invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
            codeEmitter.putfield(EnhancerEmitter.getThreadLocal(i));
            CallbackGenerator callbackGenerator = CallbackUtils.getGenerator(this.callbackTypes[i]);
            if (hashSet.contains(callbackGenerator)) continue;
            hashSet.add(callbackGenerator);
            final List list = (List)map.get(callbackGenerator);
            CallbackGenerator.Context context = new CallbackGenerator.Context(){

                public Iterator getMethods() {
                    return list.iterator();
                }

                public int getIndex(Method method) {
                    return (Integer)map2.get(method);
                }

                public void emitCallback(CodeEmitter codeEmitter, int n) {
                    EnhancerEmitter.this.emitCurrentCallback(codeEmitter, n);
                }

                public int getModifiers(Method method) {
                    int n = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
                    if (set.contains(MethodWrapper.create(method))) {
                        n = n & 0xFFFFFFFB | 1;
                    }
                    return n;
                }

                public String getUniqueName(Method method) {
                    return method.getName() + "_" + list.indexOf(method);
                }
            };
            callbackGenerator.generate(this, context);
            callbackGenerator.generateStatic(codeEmitter, context);
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitSetThreadCallbacks() {
        CodeEmitter codeEmitter = this.begin_method(9, SET_THREAD_CALLBACKS, null, null);
        this.emitSetThreadCallbacks(codeEmitter);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void emitSetThreadCallbacks(CodeEmitter codeEmitter) {
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            codeEmitter.getfield(EnhancerEmitter.getThreadLocal(i));
            codeEmitter.load_arg(0);
            codeEmitter.aaload(i);
            codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        }
    }

    private void emitCurrentCallback(CodeEmitter codeEmitter, int n) {
        codeEmitter.load_this();
        codeEmitter.getfield(EnhancerEmitter.getCallbackField(n));
        codeEmitter.dup();
        Label label = codeEmitter.make_label();
        codeEmitter.ifnonnull(label);
        codeEmitter.load_this();
        codeEmitter.getfield(CONSTRUCTED_FIELD);
        codeEmitter.if_jump(154, label);
        codeEmitter.pop();
        codeEmitter.getfield(EnhancerEmitter.getThreadLocal(n));
        codeEmitter.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        codeEmitter.checkcast(Type.getType(this.callbackTypes[n]));
        codeEmitter.mark(label);
    }

    private static String getCallbackField(int n) {
        return "CGLIB$CALLBACK_" + n;
    }

    private static String getThreadLocal(int n) {
        return "CGLIB$TL_CALLBACK_" + n;
    }

    private static void removeFinal(List list) {
        CollectionUtils.filter(list, new Predicate(){

            public boolean evaluate(Object object) {
                return !Modifier.isFinal(((Method)object).getModifiers());
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

