/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.cglib.core.AbstractClassGenerator;
import org.logicalcobwebs.cglib.core.KeyFactory;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.proxy.Callback;
import org.logicalcobwebs.cglib.proxy.CallbackFilter;
import org.logicalcobwebs.cglib.proxy.CallbackUtils;
import org.logicalcobwebs.cglib.proxy.EnhancerEmitter;
import org.logicalcobwebs.cglib.proxy.Factory;

public class Enhancer
extends AbstractClassGenerator {
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$org$logicalcobwebs$cglib$proxy$Enhancer == null ? (class$org$logicalcobwebs$cglib$proxy$Enhancer = Enhancer.class$("org.logicalcobwebs.cglib.proxy.Enhancer")) : class$org$logicalcobwebs$cglib$proxy$Enhancer).getName());
    private static final EnhancerKey KEY_FACTORY = (EnhancerKey)((Object)KeyFactory.create(class$org$logicalcobwebs$cglib$proxy$Enhancer$EnhancerKey == null ? (class$org$logicalcobwebs$cglib$proxy$Enhancer$EnhancerKey = Enhancer.class$("org.logicalcobwebs.cglib.proxy.Enhancer$EnhancerKey")) : class$org$logicalcobwebs$cglib$proxy$Enhancer$EnhancerKey, KeyFactory.CLASS_BY_NAME));
    private Class[] interfaces;
    private CallbackFilter filter;
    private Callback[] callbacks;
    private Class[] callbackTypes;
    private boolean classOnly;
    private Class superclass;
    private Class[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    static /* synthetic */ Class class$org$logicalcobwebs$cglib$proxy$Enhancer;
    static /* synthetic */ Class class$org$logicalcobwebs$cglib$proxy$Enhancer$EnhancerKey;
    static /* synthetic */ Class class$java$lang$Object;

    public Enhancer() {
        super(SOURCE);
    }

    public void setSuperclass(Class clazz) {
        if (clazz != null && clazz.isInterface()) {
            this.setInterfaces(new Class[]{clazz});
        } else {
            this.superclass = clazz != null && clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object) ? null : clazz;
        }
    }

    public void setInterfaces(Class[] classArray) {
        this.interfaces = classArray;
    }

    public void setCallbackFilter(CallbackFilter callbackFilter) {
        this.filter = callbackFilter;
    }

    public void setCallback(Callback callback) {
        this.setCallbacks(new Callback[]{callback});
    }

    public void setCallbacks(Callback[] callbackArray) {
        if (callbackArray != null && callbackArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbackArray;
    }

    public void setUseFactory(boolean bl) {
        this.useFactory = bl;
    }

    public void setCallbackType(Class clazz) {
        this.setCallbackTypes(new Class[]{clazz});
    }

    public void setCallbackTypes(Class[] classArray) {
        if (classArray != null && classArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = classArray;
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    public Object create(Class[] classArray, Object[] objectArray) {
        this.classOnly = false;
        if (classArray == null || objectArray == null || classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        this.argumentTypes = classArray;
        this.arguments = objectArray;
        return this.createHelper();
    }

    public Class createClass() {
        this.classOnly = true;
        return (Class)this.createHelper();
    }

    private Object createHelper() {
        int n;
        if (this.classOnly ^ this.callbacks == null) {
            if (this.classOnly) {
                throw new IllegalStateException("createClass does not accept callbacks");
            }
            throw new IllegalStateException("callbacks are required unless using createClass");
        }
        if (this.callbacks == null && this.callbackTypes == null) {
            throw new IllegalStateException("Either callbacks or callback types are always required");
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            for (n = 0; n < this.callbacks.length; ++n) {
                CallbackUtils.getGenerator(this.callbackTypes[n]);
                if (this.callbacks[n] == null) {
                    throw new IllegalStateException("Callback cannot be null");
                }
                if (this.callbackTypes[n].isAssignableFrom(this.callbacks[n].getClass())) continue;
                throw new IllegalStateException("Callback " + this.callbacks[n] + " is not assignable to " + this.callbackTypes[n]);
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = new Class[this.callbacks.length];
            for (n = 0; n < this.callbacks.length; ++n) {
                this.callbackTypes[n] = CallbackUtils.determineType(this.callbacks[n]);
            }
        } else {
            for (n = 0; n < this.callbackTypes.length; ++n) {
                CallbackUtils.getGenerator(this.callbackTypes[n]);
            }
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = CallbackFilter.ALL_ZERO;
        }
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[ReflectUtils.findPackageProtected(this.interfaces)].getName());
        }
        Object object = KEY_FACTORY.newInstance(this.superclass, this.interfaces, this.filter, this.callbackTypes, this.useFactory);
        return super.create(object);
    }

    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        if (this.interfaces != null) {
            return this.interfaces[0].getClassLoader();
        }
        return null;
    }

    public void generateClass(ClassVisitor classVisitor) throws Exception {
        new EnhancerEmitter(classVisitor, this.getClassName(), this.superclass, this.interfaces, this.filter, this.callbackTypes, this.useFactory);
    }

    protected Object firstInstance(Class clazz) throws Exception {
        if (this.classOnly) {
            return clazz;
        }
        return this.createUsingReflection(clazz);
    }

    protected Object nextInstance(Object object) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (this.classOnly) {
            return clazz;
        }
        if (object instanceof Factory) {
            if (this.argumentTypes != null) {
                return ((Factory)object).newInstance(this.argumentTypes, this.arguments, this.callbacks);
            }
            return ((Factory)object).newInstance(this.callbacks);
        }
        return this.createUsingReflection(clazz);
    }

    private Object createUsingReflection(Class clazz) {
        EnhancerEmitter.setThreadCallbacks(clazz, this.callbacks);
        if (this.argumentTypes != null) {
            return ReflectUtils.newInstance(clazz, this.argumentTypes, this.arguments);
        }
        return ReflectUtils.newInstance(clazz);
    }

    public static Object create(Class clazz, Callback callback) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback(callback);
        return enhancer.create();
    }

    public static Object create(Class clazz, Class[] classArray, Callback callback) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setInterfaces(classArray);
        enhancer.setCallback(callback);
        return enhancer.create();
    }

    public static Object create(Class clazz, Class[] classArray, CallbackFilter callbackFilter, Callback[] callbackArray) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setInterfaces(classArray);
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(callbackArray);
        return enhancer.create();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface EnhancerKey {
        public Object newInstance(Class var1, Class[] var2, CallbackFilter var3, Class[] var4, boolean var5);
    }
}

