/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;
import org.logicalcobwebs.cglib.proxy.CallbackGenerator;

class DispatcherGenerator
implements CallbackGenerator {
    public static final DispatcherGenerator INSTANCE = new DispatcherGenerator();
    private static final Type DISPATCHER = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.Dispatcher");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");

    DispatcherGenerator() {
    }

    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context) {
        Iterator iterator = context.getMethods();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (Modifier.isProtected(method.getModifiers())) continue;
            CodeEmitter codeEmitter = classEmitter.begin_method(context.getModifiers(method), ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            context.emitCallback(codeEmitter, context.getIndex(method));
            codeEmitter.invoke_interface(DISPATCHER, LOAD_OBJECT);
            codeEmitter.checkcast(Type.getType(method.getDeclaringClass()));
            codeEmitter.load_args();
            codeEmitter.invoke(method);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context) {
    }
}

