/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.CodeGenerationException;
import org.logicalcobwebs.cglib.core.Constants;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;

public class ReflectUtils {
    private static final Map primitives = new HashMap(8);
    private static final Map transforms = new HashMap(8);
    private static final ClassLoader defaultLoader = (class$org$logicalcobwebs$cglib$core$ReflectUtils == null ? (class$org$logicalcobwebs$cglib$core$ReflectUtils = ReflectUtils.class$("org.logicalcobwebs.cglib.core.ReflectUtils")) : class$org$logicalcobwebs$cglib$core$ReflectUtils).getClassLoader();
    private static final RuntimePermission DEFINE_CGLIB_CLASS_IN_JAVA_PACKAGE_PERMISSION = new RuntimePermission("defineCGLIBClassInJavaPackage");
    private static final Method DEFINE_CLASS;
    private static final String[] CGLIB_PACKAGES;
    static /* synthetic */ Class class$org$logicalcobwebs$cglib$core$ReflectUtils;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Object;

    private ReflectUtils() {
    }

    public static Type[] getExceptionTypes(Member member) {
        if (member instanceof Method) {
            return TypeUtils.getTypes(((Method)member).getExceptionTypes());
        }
        if (member instanceof Constructor) {
            return TypeUtils.getTypes(((Constructor)member).getExceptionTypes());
        }
        throw new IllegalArgumentException("Cannot get exception types of a field");
    }

    public static Signature getSignature(Member member) {
        if (member instanceof Method) {
            return new Signature(member.getName(), Type.getMethodDescriptor((Method)member));
        }
        if (member instanceof Constructor) {
            Type[] typeArray = TypeUtils.getTypes(((Constructor)member).getParameterTypes());
            return new Signature("<init>", Type.getMethodDescriptor(Type.VOID_TYPE, typeArray));
        }
        throw new IllegalArgumentException("Cannot get signature of a field");
    }

    public static Constructor findConstructor(String string) {
        return ReflectUtils.findConstructor(string, defaultLoader);
    }

    public static Constructor findConstructor(String string, ClassLoader classLoader) {
        try {
            int n = string.indexOf(40);
            String string2 = string.substring(0, n).trim();
            return ReflectUtils.getClass(string2, classLoader).getConstructor(ReflectUtils.parseTypes(string, classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CodeGenerationException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CodeGenerationException(noSuchMethodException);
        }
    }

    public static Method findMethod(String string) {
        return ReflectUtils.findMethod(string, defaultLoader);
    }

    public static Method findMethod(String string, ClassLoader classLoader) {
        try {
            int n = string.indexOf(40);
            int n2 = string.lastIndexOf(46, n);
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2 + 1, n).trim();
            return ReflectUtils.getClass(string2, classLoader).getDeclaredMethod(string3, ReflectUtils.parseTypes(string, classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CodeGenerationException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CodeGenerationException(noSuchMethodException);
        }
    }

    private static Class[] parseTypes(String string, ClassLoader classLoader) throws ClassNotFoundException {
        int n;
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41, n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = n2 + 1;
        while ((n = string.indexOf(44, n4)) >= 0) {
            arrayList.add(string.substring(n4, n).trim());
            n4 = n + 1;
        }
        if (n4 < n3) {
            arrayList.add(string.substring(n4, n3).trim());
        }
        Class[] classArray = new Class[arrayList.size()];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = ReflectUtils.getClass((String)arrayList.get(i), classLoader);
        }
        return classArray;
    }

    private static Class getClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return ReflectUtils.getClass(string, classLoader, CGLIB_PACKAGES);
    }

    private static Class getClass(String string, ClassLoader classLoader, String[] stringArray) throws ClassNotFoundException {
        String string2 = string;
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("[]", n2) + 1) > 0) {
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() - n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[');
        }
        string = string.substring(0, string.length() - 2 * n);
        String string3 = n > 0 ? stringBuffer + "L" : "";
        String string4 = n > 0 ? ";" : "";
        try {
            return Class.forName(string3 + string + string4, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    return Class.forName(string3 + stringArray[i] + '.' + string + string4, false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    continue;
                }
            }
            if (n == 0) {
                Class clazz = (Class)primitives.get(string);
                if (clazz != null) {
                    return clazz;
                }
            } else {
                String string5 = (String)transforms.get(string);
                if (string5 != null) {
                    try {
                        return Class.forName(stringBuffer + string5, false, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        // empty catch block
                    }
                }
            }
            throw new ClassNotFoundException(string2);
        }
    }

    public static Object newInstance(Class clazz) {
        return ReflectUtils.newInstance(clazz, Constants.EMPTY_CLASS_ARRAY, null);
    }

    public static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray) {
        return ReflectUtils.newInstance(ReflectUtils.getConstructor(clazz, classArray), objectArray);
    }

    public static Object newInstance(Constructor constructor, Object[] objectArray) {
        boolean bl = constructor.isAccessible();
        try {
            Object t;
            constructor.setAccessible(true);
            Object t2 = t = constructor.newInstance(objectArray);
            return t2;
        }
        catch (InstantiationException instantiationException) {
            throw new CodeGenerationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CodeGenerationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CodeGenerationException(invocationTargetException.getTargetException());
        }
        finally {
            constructor.setAccessible(bl);
        }
    }

    public static Constructor getConstructor(Class clazz, Class[] classArray) {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CodeGenerationException(noSuchMethodException);
        }
    }

    public static Class[] getClasses(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return classArray;
    }

    public static Method findNewInstance(Class clazz) {
        Method method = ReflectUtils.findInterfaceMethod(clazz);
        if (!method.getName().equals("newInstance")) {
            throw new IllegalArgumentException(clazz + " missing newInstance method");
        }
        return method;
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] propertyDescriptorArray, boolean bl, boolean bl2) {
        HashSet<Method> hashSet = new HashSet<Method>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (bl) {
                hashSet.add(propertyDescriptor.getReadMethod());
            }
            if (!bl2) continue;
            hashSet.add(propertyDescriptor.getWriteMethod());
        }
        hashSet.remove(null);
        return hashSet.toArray(new Method[hashSet.size()]);
    }

    public static PropertyDescriptor[] getBeanProperties(Class clazz) {
        return ReflectUtils.getPropertiesHelper(clazz, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class clazz) {
        return ReflectUtils.getPropertiesHelper(clazz, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class clazz) {
        return ReflectUtils.getPropertiesHelper(clazz, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class clazz, boolean bl, boolean bl2) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = ReflectUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (bl && bl2) {
                return propertyDescriptorArray;
            }
            ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>(propertyDescriptorArray.length);
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if ((!bl || propertyDescriptor.getReadMethod() == null) && (!bl2 || propertyDescriptor.getWriteMethod() == null)) continue;
                arrayList.add(propertyDescriptor);
            }
            return arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
        }
        catch (IntrospectionException introspectionException) {
            throw new CodeGenerationException(introspectionException);
        }
    }

    public static Method findDeclaredMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                return clazz2.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new NoSuchMethodException(string);
    }

    public static List addAllMethods(Class clazz, List list) {
        list.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            ReflectUtils.addAllMethods(clazz2, list);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            ReflectUtils.addAllMethods(classArray[i], list);
        }
        return list;
    }

    public static Method findInterfaceMethod(Class clazz) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException(clazz + " is not an interface");
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length != 1) {
            throw new IllegalArgumentException("expecting exactly 1 method in " + clazz);
        }
        return methodArray[0];
    }

    public static Class defineClass(String string, byte[] byArray, ClassLoader classLoader) throws Exception {
        SecurityManager securityManager = System.getSecurityManager();
        if (string != null && string.startsWith("java.") && securityManager != null) {
            securityManager.checkPermission(DEFINE_CGLIB_CLASS_IN_JAVA_PACKAGE_PERMISSION);
        }
        Object[] objectArray = new Object[]{byArray, new Integer(0), new Integer(byArray.length)};
        DEFINE_CLASS.setAccessible(true);
        return (Class)DEFINE_CLASS.invoke((Object)classLoader, objectArray);
    }

    public static int findPackageProtected(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (Modifier.isPublic(classArray[i].getModifiers())) continue;
            return i;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DEFINE_CLASS = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ReflectUtils.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", array$B == null ? (array$B = ReflectUtils.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CodeGenerationException(noSuchMethodException);
        }
        CGLIB_PACKAGES = new String[]{"java.lang"};
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

