/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.Block;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.CodeGenerationException;
import org.logicalcobwebs.cglib.core.CollectionUtils;
import org.logicalcobwebs.cglib.core.Constants;
import org.logicalcobwebs.cglib.core.Customizer;
import org.logicalcobwebs.cglib.core.Local;
import org.logicalcobwebs.cglib.core.ObjectSwitchCallback;
import org.logicalcobwebs.cglib.core.ProcessArrayCallback;
import org.logicalcobwebs.cglib.core.ProcessSwitchCallback;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.Transformer;
import org.logicalcobwebs.cglib.core.TypeUtils;

public class EmitUtils {
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature CSTRUCT_THROWABLE = TypeUtils.parseConstructor("Throwable");
    private static final Signature GET_NAME = TypeUtils.parseSignature("String getName()");
    private static final Signature HASH_CODE = TypeUtils.parseSignature("int hashCode()");
    private static final Signature EQUALS = TypeUtils.parseSignature("boolean equals(Object)");
    private static final Signature STRING_LENGTH = TypeUtils.parseSignature("int length()");
    private static final Signature STRING_CHAR_AT = TypeUtils.parseSignature("char charAt(int)");
    private static final Signature FOR_NAME = TypeUtils.parseSignature("Class forName(String)");
    private static final Signature DOUBLE_TO_LONG_BITS = TypeUtils.parseSignature("long doubleToLongBits(double)");
    private static final Signature FLOAT_TO_INT_BITS = TypeUtils.parseSignature("int floatToIntBits(float)");
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature APPEND_STRING = TypeUtils.parseSignature("StringBuffer append(String)");
    private static final Signature APPEND_INT = TypeUtils.parseSignature("StringBuffer append(int)");
    private static final Signature APPEND_DOUBLE = TypeUtils.parseSignature("StringBuffer append(double)");
    private static final Signature APPEND_FLOAT = TypeUtils.parseSignature("StringBuffer append(float)");
    private static final Signature APPEND_CHAR = TypeUtils.parseSignature("StringBuffer append(char)");
    private static final Signature APPEND_LONG = TypeUtils.parseSignature("StringBuffer append(long)");
    private static final Signature APPEND_BOOLEAN = TypeUtils.parseSignature("StringBuffer append(boolean)");
    private static final Signature LENGTH = TypeUtils.parseSignature("int length()");
    private static final Signature SET_LENGTH = TypeUtils.parseSignature("void setLength(int)");
    private static final Signature GET_DECLARED_METHOD = TypeUtils.parseSignature("java.lang.reflect.Method getDeclaredMethod(String, Class[])");
    public static final ArrayDelimiters DEFAULT_DELIMITERS = new ArrayDelimiters("{", ", ", "}");

    private EmitUtils() {
    }

    public static void factory_method(ClassEmitter classEmitter, Signature signature) {
        CodeEmitter codeEmitter = classEmitter.begin_method(1, signature, null, null);
        codeEmitter.new_instance_this();
        codeEmitter.dup();
        codeEmitter.load_args();
        codeEmitter.invoke_constructor_this(TypeUtils.parseConstructor(signature.getArgumentTypes()));
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    public static void null_constructor(ClassEmitter classEmitter) {
        CodeEmitter codeEmitter = classEmitter.begin_method(1, CSTRUCT_NULL, null, null);
        codeEmitter.load_this();
        codeEmitter.super_invoke_constructor();
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    public static void process_array(CodeEmitter codeEmitter, Type type, ProcessArrayCallback processArrayCallback) {
        Type type2 = TypeUtils.getComponentType(type);
        Local local = codeEmitter.make_local();
        Local local2 = codeEmitter.make_local(Type.INT_TYPE);
        Label label = codeEmitter.make_label();
        Label label2 = codeEmitter.make_label();
        codeEmitter.store_local(local);
        codeEmitter.push(0);
        codeEmitter.store_local(local2);
        codeEmitter.goTo(label2);
        codeEmitter.mark(label);
        codeEmitter.load_local(local);
        codeEmitter.load_local(local2);
        codeEmitter.array_load(type2);
        processArrayCallback.processElement(type2);
        codeEmitter.iinc(local2, 1);
        codeEmitter.mark(label2);
        codeEmitter.load_local(local2);
        codeEmitter.load_local(local);
        codeEmitter.arraylength();
        codeEmitter.if_icmp(155, label);
    }

    public static void process_arrays(CodeEmitter codeEmitter, Type type, ProcessArrayCallback processArrayCallback) {
        Type type2 = TypeUtils.getComponentType(type);
        Local local = codeEmitter.make_local();
        Local local2 = codeEmitter.make_local();
        Local local3 = codeEmitter.make_local(Type.INT_TYPE);
        Label label = codeEmitter.make_label();
        Label label2 = codeEmitter.make_label();
        codeEmitter.store_local(local);
        codeEmitter.store_local(local2);
        codeEmitter.push(0);
        codeEmitter.store_local(local3);
        codeEmitter.goTo(label2);
        codeEmitter.mark(label);
        codeEmitter.load_local(local);
        codeEmitter.load_local(local3);
        codeEmitter.array_load(type2);
        codeEmitter.load_local(local2);
        codeEmitter.load_local(local3);
        codeEmitter.array_load(type2);
        processArrayCallback.processElement(type2);
        codeEmitter.iinc(local3, 1);
        codeEmitter.mark(label2);
        codeEmitter.load_local(local3);
        codeEmitter.load_local(local);
        codeEmitter.arraylength();
        codeEmitter.if_icmp(155, label);
    }

    public static void string_switch(CodeEmitter codeEmitter, String[] stringArray, int n, ObjectSwitchCallback objectSwitchCallback) {
        try {
            switch (n) {
                case 0: {
                    EmitUtils.string_switch_trie(codeEmitter, stringArray, objectSwitchCallback);
                    break;
                }
                case 1: {
                    EmitUtils.string_switch_hash(codeEmitter, stringArray, objectSwitchCallback, false);
                    break;
                }
                case 2: {
                    EmitUtils.string_switch_hash(codeEmitter, stringArray, objectSwitchCallback, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown switch style " + n);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    private static void string_switch_trie(final CodeEmitter codeEmitter, String[] stringArray, final ObjectSwitchCallback objectSwitchCallback) throws Exception {
        final Label label = codeEmitter.make_label();
        final Label label2 = codeEmitter.make_label();
        final Map map = CollectionUtils.bucket(Arrays.asList(stringArray), new Transformer(){

            public Object transform(Object object) {
                return new Integer(((String)object).length());
            }
        });
        codeEmitter.dup();
        codeEmitter.invoke_virtual(Constants.TYPE_STRING, STRING_LENGTH);
        codeEmitter.process_switch(EmitUtils.getSwitchKeys(map), new ProcessSwitchCallback(){

            public void processCase(int n, Label label3) throws Exception {
                List list = (List)map.get(new Integer(n));
                EmitUtils.stringSwitchHelper(codeEmitter, list, objectSwitchCallback, label, label2, 0);
            }

            public void processDefault() {
                codeEmitter.goTo(label);
            }
        });
        codeEmitter.mark(label);
        codeEmitter.pop();
        objectSwitchCallback.processDefault();
        codeEmitter.mark(label2);
    }

    private static void stringSwitchHelper(final CodeEmitter codeEmitter, List list, final ObjectSwitchCallback objectSwitchCallback, final Label label, final Label label2, final int n) throws Exception {
        final int n2 = ((String)list.get(0)).length();
        final Map map = CollectionUtils.bucket(list, new Transformer(){

            public Object transform(Object object) {
                return new Integer(((String)object).charAt(n));
            }
        });
        codeEmitter.dup();
        codeEmitter.push(n);
        codeEmitter.invoke_virtual(Constants.TYPE_STRING, STRING_CHAR_AT);
        codeEmitter.process_switch(EmitUtils.getSwitchKeys(map), new ProcessSwitchCallback(){

            public void processCase(int n3, Label label3) throws Exception {
                List list = (List)map.get(new Integer(n3));
                if (n + 1 == n2) {
                    codeEmitter.pop();
                    objectSwitchCallback.processCase(list.get(0), label2);
                } else {
                    EmitUtils.stringSwitchHelper(codeEmitter, list, objectSwitchCallback, label, label2, n + 1);
                }
            }

            public void processDefault() {
                codeEmitter.goTo(label);
            }
        });
    }

    static int[] getSwitchKeys(Map map) {
        int[] nArray = new int[map.size()];
        int n = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            nArray[n++] = (Integer)iterator.next();
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private static void string_switch_hash(final CodeEmitter codeEmitter, String[] stringArray, final ObjectSwitchCallback objectSwitchCallback, final boolean bl) throws Exception {
        final Map map = CollectionUtils.bucket(Arrays.asList(stringArray), new Transformer(){

            public Object transform(Object object) {
                return new Integer(object.hashCode());
            }
        });
        final Label label = codeEmitter.make_label();
        final Label label2 = codeEmitter.make_label();
        codeEmitter.dup();
        codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, HASH_CODE);
        codeEmitter.process_switch(EmitUtils.getSwitchKeys(map), new ProcessSwitchCallback(){

            public void processCase(int n, Label label3) throws Exception {
                List list = (List)map.get(new Integer(n));
                Label label22 = null;
                if (bl && list.size() == 1) {
                    objectSwitchCallback.processCase((String)list.get(0), label2);
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (label22 != null) {
                            codeEmitter.mark(label22);
                        }
                        if (iterator.hasNext()) {
                            codeEmitter.dup();
                        }
                        codeEmitter.push(string);
                        codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                        if (iterator.hasNext()) {
                            label22 = codeEmitter.make_label();
                            codeEmitter.if_jump(153, label22);
                            codeEmitter.pop();
                        } else {
                            codeEmitter.if_jump(153, label);
                        }
                        objectSwitchCallback.processCase(string, label2);
                    }
                }
            }

            public void processDefault() {
                codeEmitter.pop();
            }
        });
        codeEmitter.mark(label);
        objectSwitchCallback.processDefault();
        codeEmitter.mark(label2);
    }

    public static void load_class_this(CodeEmitter codeEmitter) {
        EmitUtils.load_class_helper(codeEmitter, codeEmitter.getClassEmitter().getClassType());
    }

    public static void load_class(CodeEmitter codeEmitter, Type type) {
        if (TypeUtils.isPrimitive(type)) {
            if (type == Type.VOID_TYPE) {
                throw new IllegalArgumentException("cannot load void type");
            }
            codeEmitter.getstatic(TypeUtils.getBoxedType(type), "TYPE", Constants.TYPE_CLASS);
        } else {
            EmitUtils.load_class_helper(codeEmitter, type);
        }
    }

    private static void load_class_helper(CodeEmitter codeEmitter, Type type) {
        if (codeEmitter.isStaticHook()) {
            codeEmitter.push(TypeUtils.emulateClassGetName(type));
            codeEmitter.invoke_static(Constants.TYPE_CLASS, FOR_NAME);
        } else {
            String string;
            String string2;
            ClassEmitter classEmitter = codeEmitter.getClassEmitter();
            if (!classEmitter.isFieldDeclared(string2 = EmitUtils.getFieldName(string = TypeUtils.emulateClassGetName(type)))) {
                classEmitter.declare_field(26, string2, Constants.TYPE_CLASS, null, null);
                CodeEmitter codeEmitter2 = classEmitter.getStaticHook();
                codeEmitter2.push(string);
                codeEmitter2.invoke_static(Constants.TYPE_CLASS, FOR_NAME);
                codeEmitter2.putstatic(classEmitter.getClassType(), string2, Constants.TYPE_CLASS);
            }
            codeEmitter.getfield(string2);
        }
    }

    private static String getFieldName(String string) {
        return "CGLIB$load_class$" + EmitUtils.escapeType(string);
    }

    private static String escapeType(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': {
                    stringBuffer.append("$24");
                    continue block6;
                }
                case '.': {
                    stringBuffer.append("$2E");
                    continue block6;
                }
                case '[': {
                    stringBuffer.append("$5B");
                    continue block6;
                }
                case ';': {
                    stringBuffer.append("$3B");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void push_array(CodeEmitter codeEmitter, Object[] objectArray) {
        codeEmitter.push(objectArray.length);
        codeEmitter.newarray(Type.getType(objectArray.getClass().getComponentType()));
        for (int i = 0; i < objectArray.length; ++i) {
            codeEmitter.dup();
            codeEmitter.push(i);
            EmitUtils.push_object(codeEmitter, objectArray[i]);
            codeEmitter.aastore();
        }
    }

    public static void push_object(CodeEmitter codeEmitter, Object object) {
        if (object == null) {
            codeEmitter.aconst_null();
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                EmitUtils.push_array(codeEmitter, (Object[])object);
            } else if (object instanceof String) {
                codeEmitter.push((String)object);
            } else if (object instanceof Class) {
                EmitUtils.load_class(codeEmitter, Type.getType((Class)object));
            } else if (object instanceof BigInteger) {
                codeEmitter.new_instance(Constants.TYPE_BIG_INTEGER);
                codeEmitter.dup();
                codeEmitter.push(object.toString());
                codeEmitter.invoke_constructor(Constants.TYPE_BIG_INTEGER);
            } else if (object instanceof BigDecimal) {
                codeEmitter.new_instance(Constants.TYPE_BIG_DECIMAL);
                codeEmitter.dup();
                codeEmitter.push(object.toString());
                codeEmitter.invoke_constructor(Constants.TYPE_BIG_DECIMAL);
            } else {
                throw new IllegalArgumentException("unknown type: " + object.getClass());
            }
        }
    }

    public static void hash_code(CodeEmitter codeEmitter, Type type, int n, Customizer customizer) {
        if (TypeUtils.isArray(type)) {
            EmitUtils.hash_array(codeEmitter, type, n, customizer);
        } else {
            codeEmitter.swap(Type.INT_TYPE, type);
            codeEmitter.push(n);
            codeEmitter.math(104, Type.INT_TYPE);
            codeEmitter.swap(type, Type.INT_TYPE);
            if (TypeUtils.isPrimitive(type)) {
                EmitUtils.hash_primitive(codeEmitter, type);
            } else {
                EmitUtils.hash_object(codeEmitter, type, customizer);
            }
            codeEmitter.math(96, Type.INT_TYPE);
        }
    }

    private static void hash_array(final CodeEmitter codeEmitter, Type type, final int n, final Customizer customizer) {
        Label label = codeEmitter.make_label();
        Label label2 = codeEmitter.make_label();
        codeEmitter.dup();
        codeEmitter.ifnull(label);
        EmitUtils.process_array(codeEmitter, type, new ProcessArrayCallback(){

            public void processElement(Type type) {
                EmitUtils.hash_code(codeEmitter, type, n, customizer);
            }
        });
        codeEmitter.goTo(label2);
        codeEmitter.mark(label);
        codeEmitter.pop();
        codeEmitter.mark(label2);
    }

    private static void hash_object(CodeEmitter codeEmitter, Type type, Customizer customizer) {
        Label label = codeEmitter.make_label();
        Label label2 = codeEmitter.make_label();
        codeEmitter.dup();
        codeEmitter.ifnull(label);
        if (customizer != null) {
            customizer.customize(codeEmitter, type);
        }
        codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, HASH_CODE);
        codeEmitter.goTo(label2);
        codeEmitter.mark(label);
        codeEmitter.pop();
        codeEmitter.push(0);
        codeEmitter.mark(label2);
    }

    private static void hash_primitive(CodeEmitter codeEmitter, Type type) {
        switch (type.getSort()) {
            case 1: {
                codeEmitter.push(1);
                codeEmitter.math(130, Type.INT_TYPE);
                break;
            }
            case 6: {
                codeEmitter.invoke_static(Constants.TYPE_FLOAT, FLOAT_TO_INT_BITS);
                break;
            }
            case 8: {
                codeEmitter.invoke_static(Constants.TYPE_DOUBLE, DOUBLE_TO_LONG_BITS);
            }
            case 7: {
                EmitUtils.hash_long(codeEmitter);
            }
        }
    }

    private static void hash_long(CodeEmitter codeEmitter) {
        codeEmitter.dup2();
        codeEmitter.push(32);
        codeEmitter.math(124, Type.LONG_TYPE);
        codeEmitter.math(130, Type.LONG_TYPE);
        codeEmitter.cast_numeric(Type.LONG_TYPE, Type.INT_TYPE);
    }

    public static void not_equals(final CodeEmitter codeEmitter, Type type, final Label label, final Customizer customizer) {
        new ProcessArrayCallback(){

            public void processElement(Type type) {
                EmitUtils.not_equals_helper(codeEmitter, type, label, customizer, this);
            }
        }.processElement(type);
    }

    private static void not_equals_helper(CodeEmitter codeEmitter, Type type, Label label, Customizer customizer, ProcessArrayCallback processArrayCallback) {
        if (TypeUtils.isPrimitive(type)) {
            codeEmitter.if_cmp(type, 154, label);
        } else {
            Label label2 = codeEmitter.make_label();
            EmitUtils.nullcmp(codeEmitter, label, label2);
            if (TypeUtils.isArray(type)) {
                Label label3 = codeEmitter.make_label();
                codeEmitter.dup2();
                codeEmitter.arraylength();
                codeEmitter.swap();
                codeEmitter.arraylength();
                codeEmitter.if_icmp(153, label3);
                codeEmitter.pop2();
                codeEmitter.goTo(label);
                codeEmitter.mark(label3);
                EmitUtils.process_arrays(codeEmitter, type, processArrayCallback);
            } else {
                if (customizer != null) {
                    customizer.customize(codeEmitter, type);
                    codeEmitter.swap();
                    customizer.customize(codeEmitter, type);
                }
                codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                codeEmitter.if_jump(153, label);
            }
            codeEmitter.mark(label2);
        }
    }

    private static void nullcmp(CodeEmitter codeEmitter, Label label, Label label2) {
        codeEmitter.dup2();
        Label label3 = codeEmitter.make_label();
        Label label4 = codeEmitter.make_label();
        Label label5 = codeEmitter.make_label();
        codeEmitter.ifnonnull(label3);
        codeEmitter.ifnonnull(label4);
        codeEmitter.pop2();
        codeEmitter.goTo(label2);
        codeEmitter.mark(label3);
        codeEmitter.ifnull(label4);
        codeEmitter.goTo(label5);
        codeEmitter.mark(label4);
        codeEmitter.pop2();
        codeEmitter.goTo(label);
        codeEmitter.mark(label5);
    }

    public static void append_string(final CodeEmitter codeEmitter, Type type, ArrayDelimiters arrayDelimiters, final Customizer customizer) {
        final ArrayDelimiters arrayDelimiters2 = arrayDelimiters != null ? arrayDelimiters : DEFAULT_DELIMITERS;
        ProcessArrayCallback processArrayCallback = new ProcessArrayCallback(){

            public void processElement(Type type) {
                EmitUtils.append_string_helper(codeEmitter, type, arrayDelimiters2, customizer, this);
                codeEmitter.push(arrayDelimiters2.inside);
                codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
            }
        };
        EmitUtils.append_string_helper(codeEmitter, type, arrayDelimiters2, customizer, processArrayCallback);
    }

    private static void append_string_helper(CodeEmitter codeEmitter, Type type, ArrayDelimiters arrayDelimiters, Customizer customizer, ProcessArrayCallback processArrayCallback) {
        Label label = codeEmitter.make_label();
        Label label2 = codeEmitter.make_label();
        if (TypeUtils.isPrimitive(type)) {
            switch (type.getSort()) {
                case 3: 
                case 4: 
                case 5: {
                    codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_INT);
                    break;
                }
                case 8: {
                    codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_DOUBLE);
                    break;
                }
                case 6: {
                    codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_FLOAT);
                    break;
                }
                case 7: {
                    codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_LONG);
                    break;
                }
                case 1: {
                    codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_BOOLEAN);
                    break;
                }
                case 2: {
                    codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_CHAR);
                }
            }
        } else if (TypeUtils.isArray(type)) {
            codeEmitter.dup();
            codeEmitter.ifnull(label);
            codeEmitter.swap();
            if (arrayDelimiters != null && arrayDelimiters.before != null && !"".equals(arrayDelimiters.before)) {
                codeEmitter.push(arrayDelimiters.before);
                codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
                codeEmitter.swap();
            }
            EmitUtils.process_array(codeEmitter, type, processArrayCallback);
            EmitUtils.shrinkStringBuffer(codeEmitter, 2);
            if (arrayDelimiters != null && arrayDelimiters.after != null && !"".equals(arrayDelimiters.after)) {
                codeEmitter.push(arrayDelimiters.after);
                codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
            }
        } else {
            codeEmitter.dup();
            codeEmitter.ifnull(label);
            if (customizer != null) {
                customizer.customize(codeEmitter, type);
            }
            codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
            codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
        }
        codeEmitter.goTo(label2);
        codeEmitter.mark(label);
        codeEmitter.pop();
        codeEmitter.push("null");
        codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, APPEND_STRING);
        codeEmitter.mark(label2);
    }

    private static void shrinkStringBuffer(CodeEmitter codeEmitter, int n) {
        codeEmitter.dup();
        codeEmitter.dup();
        codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, LENGTH);
        codeEmitter.push(n);
        codeEmitter.math(100, Type.INT_TYPE);
        codeEmitter.invoke_virtual(Constants.TYPE_STRING_BUFFER, SET_LENGTH);
    }

    public static void load_method(CodeEmitter codeEmitter, Method method) {
        EmitUtils.load_class(codeEmitter, Type.getType(method.getDeclaringClass()));
        codeEmitter.push(method.getName());
        EmitUtils.push_object(codeEmitter, method.getParameterTypes());
        codeEmitter.invoke_virtual(Constants.TYPE_CLASS, GET_DECLARED_METHOD);
    }

    public static void method_switch(CodeEmitter codeEmitter, Method[] methodArray, ObjectSwitchCallback objectSwitchCallback) {
        EmitUtils.member_switch_helper(codeEmitter, Arrays.asList(methodArray), objectSwitchCallback, true, new ParameterTyper(){

            public Class[] getParameterTypes(Object object) {
                return ((Method)object).getParameterTypes();
            }
        });
    }

    public static void constructor_switch(CodeEmitter codeEmitter, Constructor[] constructorArray, ObjectSwitchCallback objectSwitchCallback) {
        EmitUtils.member_switch_helper(codeEmitter, Arrays.asList(constructorArray), objectSwitchCallback, false, new ParameterTyper(){

            public Class[] getParameterTypes(Object object) {
                return ((Constructor)object).getParameterTypes();
            }
        });
    }

    private static void member_switch_helper(final CodeEmitter codeEmitter, List list, final ObjectSwitchCallback objectSwitchCallback, boolean bl, final ParameterTyper parameterTyper) {
        try {
            final HashMap hashMap = new HashMap();
            final ParameterTyper parameterTyper2 = new ParameterTyper(){

                public Class[] getParameterTypes(Object object) {
                    Class[] classArray = (Class[])hashMap.get(object);
                    if (classArray == null) {
                        classArray = parameterTyper.getParameterTypes(object);
                        hashMap.put(object, classArray);
                    }
                    return classArray;
                }
            };
            final Label label = codeEmitter.make_label();
            final Label label2 = codeEmitter.make_label();
            if (bl) {
                codeEmitter.swap();
                final Map map = CollectionUtils.bucket(list, new Transformer(){

                    public Object transform(Object object) {
                        return ((Member)object).getName();
                    }
                });
                String[] stringArray = map.keySet().toArray(new String[map.size()]);
                EmitUtils.string_switch(codeEmitter, stringArray, 1, new ObjectSwitchCallback(){

                    public void processCase(Object object, Label label3) throws Exception {
                        EmitUtils.member_helper_size(codeEmitter, (List)map.get(object), objectSwitchCallback, parameterTyper2, label, label2);
                    }

                    public void processDefault() throws Exception {
                        codeEmitter.goTo(label);
                    }
                });
            } else {
                EmitUtils.member_helper_size(codeEmitter, list, objectSwitchCallback, parameterTyper2, label, label2);
            }
            codeEmitter.mark(label);
            codeEmitter.pop();
            objectSwitchCallback.processDefault();
            codeEmitter.mark(label2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    private static void member_helper_size(final CodeEmitter codeEmitter, List list, final ObjectSwitchCallback objectSwitchCallback, final ParameterTyper parameterTyper, final Label label, final Label label2) throws Exception {
        final Map map = CollectionUtils.bucket(list, new Transformer(){

            public Object transform(Object object) {
                return new Integer(parameterTyper.getParameterTypes(object).length);
            }
        });
        codeEmitter.dup();
        codeEmitter.arraylength();
        codeEmitter.process_switch(EmitUtils.getSwitchKeys(map), new ProcessSwitchCallback(){

            public void processCase(int n, Label label3) throws Exception {
                List list = (List)map.get(new Integer(n));
                EmitUtils.member_helper_type(codeEmitter, list, objectSwitchCallback, parameterTyper, label, label2, new BitSet());
            }

            public void processDefault() throws Exception {
                codeEmitter.goTo(label);
            }
        });
    }

    private static void member_helper_type(final CodeEmitter codeEmitter, List list, final ObjectSwitchCallback objectSwitchCallback, final ParameterTyper parameterTyper, final Label label, final Label label2, final BitSet bitSet) throws Exception {
        if (list.size() == 1) {
            Member member = (Member)list.get(0);
            Class[] classArray = parameterTyper.getParameterTypes(member);
            for (int i = 0; i < classArray.length; ++i) {
                if (bitSet != null && bitSet.get(i)) continue;
                codeEmitter.dup();
                codeEmitter.aaload(i);
                codeEmitter.invoke_virtual(Constants.TYPE_CLASS, GET_NAME);
                codeEmitter.push(classArray[i].getName());
                codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, EQUALS);
                codeEmitter.if_jump(153, label);
            }
            codeEmitter.pop();
            objectSwitchCallback.processCase(member, label2);
        } else {
            Class[] classArray = parameterTyper.getParameterTypes(list.get(0));
            Map map = null;
            int n = -1;
            for (int i = 0; i < classArray.length; ++i) {
                final int n2 = i;
                Map map2 = CollectionUtils.bucket(list, new Transformer(){

                    public Object transform(Object object) {
                        return parameterTyper.getParameterTypes(object)[n2].getName();
                    }
                });
                if (map != null && map2.size() <= map.size()) continue;
                map = map2;
                n = i;
            }
            if (map == null) {
                codeEmitter.goTo(label);
            } else {
                bitSet.set(n);
                codeEmitter.dup();
                codeEmitter.aaload(n);
                codeEmitter.invoke_virtual(Constants.TYPE_CLASS, GET_NAME);
                final Map map3 = map;
                String[] stringArray = map.keySet().toArray(new String[map.size()]);
                EmitUtils.string_switch(codeEmitter, stringArray, 1, new ObjectSwitchCallback(){

                    public void processCase(Object object, Label label3) throws Exception {
                        EmitUtils.member_helper_type(codeEmitter, (List)map3.get(object), objectSwitchCallback, parameterTyper, label, label2, bitSet);
                    }

                    public void processDefault() throws Exception {
                        codeEmitter.goTo(label);
                    }
                });
            }
        }
    }

    public static void wrap_throwable(Block block, Type type) {
        CodeEmitter codeEmitter = block.getCodeEmitter();
        codeEmitter.catch_exception(block, Constants.TYPE_THROWABLE);
        codeEmitter.new_instance(type);
        codeEmitter.dup_x1();
        codeEmitter.swap();
        codeEmitter.invoke_constructor(type, CSTRUCT_THROWABLE);
        codeEmitter.athrow();
    }

    public static void add_properties(ClassEmitter classEmitter, String[] stringArray, Type[] typeArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "$cglib_prop_" + stringArray[i];
            classEmitter.declare_field(2, string, typeArray[i], null, null);
            EmitUtils.add_property(classEmitter, stringArray[i], typeArray[i], string);
        }
    }

    public static void add_property(ClassEmitter classEmitter, String string, Type type, String string2) {
        String string3 = TypeUtils.upperFirst(string);
        CodeEmitter codeEmitter = classEmitter.begin_method(1, new Signature("get" + string3, type, Constants.TYPES_EMPTY), null, null);
        codeEmitter.load_this();
        codeEmitter.getfield(string2);
        codeEmitter.return_value();
        codeEmitter.end_method();
        codeEmitter = classEmitter.begin_method(1, new Signature("set" + string3, Type.VOID_TYPE, new Type[]{type}), null, null);
        codeEmitter.load_this();
        codeEmitter.load_arg(0);
        codeEmitter.putfield(string2);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    public static class ArrayDelimiters {
        private String before;
        private String inside;
        private String after;

        public ArrayDelimiters(String string, String string2, String string3) {
            this.before = string;
            this.inside = string2;
            this.after = string3;
        }
    }

    private static interface ParameterTyper {
        public Class[] getParameterTypes(Object var1);
    }
}

