/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.logicalcobwebs.asm.ClassReader;
import org.logicalcobwebs.asm.ClassWriter;
import org.logicalcobwebs.asm.util.TraceClassVisitor;
import org.logicalcobwebs.cglib.core.CodeGenerationException;

public class DebuggingClassWriter
extends ClassWriter {
    public static final String DEBUG_LOCATION_PROPERTY = "cglib.debugLocation";
    private static String debugLocation = System.getProperty("cglib.debugLocation");
    private static boolean traceEnabled;
    private String className;
    private String superName;

    public DebuggingClassWriter(boolean bl) {
        super(bl);
    }

    public void visit(int n, String string, String string2, String[] stringArray, String string3) {
        this.className = string.replace('/', '.');
        this.superName = string2.replace('/', '.');
        super.visit(n, string, string2, stringArray, string3);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        byte[] byArray;
        block10: {
            byArray = super.toByteArray();
            if (debugLocation != null) {
                String string = this.className.replace('.', File.separatorChar);
                try {
                    new File(debugLocation + File.separatorChar + string).getParentFile().mkdirs();
                    File file = new File(new File(debugLocation), string + ".class");
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        ((OutputStream)bufferedOutputStream).write(byArray);
                    }
                    finally {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                    if (!traceEnabled) break block10;
                    file = new File(new File(debugLocation), string + ".asm");
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        ClassReader classReader = new ClassReader(byArray);
                        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(bufferedOutputStream));
                        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, printWriter);
                        classReader.accept(traceClassVisitor, false);
                        printWriter.flush();
                    }
                    finally {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    throw new CodeGenerationException(iOException);
                }
            }
        }
        return byArray;
    }

    static {
        if (debugLocation != null) {
            System.err.println("CGLIB debugging enabled, writing to '" + debugLocation + "'");
            try {
                Class.forName("org.logicalcobwebs.asm.util.TraceClassVisitor");
                traceEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

