/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.logicalcobwebs.cglib.core.Predicate;
import org.logicalcobwebs.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map bucket(Collection collection, Transformer transformer) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = transformer.transform(e);
            LinkedList linkedList = (LinkedList)hashMap.get(object);
            if (linkedList == null) {
                linkedList = new LinkedList();
                hashMap.put(object, linkedList);
            }
            linkedList.add(e);
        }
        return hashMap;
    }

    public static void reverse(Map map, Map map2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            map2.put(map.get(k), k);
        }
    }

    public static Object[] filter(Object[] objectArray, Predicate predicate) {
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
        CollectionUtils.filter(arrayList, predicate);
        return arrayList.toArray((Object[])Array.newInstance(objectArray.getClass().getComponentType(), arrayList.size()));
    }

    public static Collection filter(Collection collection, Predicate predicate) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (predicate.evaluate(iterator.next())) continue;
            iterator.remove();
        }
        return collection;
    }

    public static List transform(List list, Transformer transformer) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(transformer.transform(iterator.next()));
        }
        return arrayList;
    }
}

