/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.util.HashMap;
import java.util.Map;
import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.ClassAdapter;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.Constants;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;

public class ClassEmitter
extends ClassAdapter {
    private static final Signature STATIC_HOOK = TypeUtils.parseSignature("void CGLIB$STATIC_HOOK()");
    private static final String STATIC_HOOK_FLAG = "CGLIB$STATIC_HOOK_FLAG";
    private int access;
    private Type classType;
    private Type superType;
    private Map fieldInfo;
    private boolean seenStatic;
    private CodeEmitter hook;
    private boolean ended;
    private ClassVisitor outer;

    public ClassEmitter(ClassVisitor classVisitor) {
        super(null);
        this.setTarget(classVisitor, this);
    }

    public ClassEmitter() {
        super(null);
    }

    public void setTarget(ClassVisitor classVisitor, ClassVisitor classVisitor2) {
        this.cv = classVisitor;
        this.outer = classVisitor2;
        this.fieldInfo = new HashMap();
        this.seenStatic = false;
        this.hook = null;
        this.ended = false;
    }

    public void begin_class(int n, String string, Type type, Type[] typeArray, String string2) {
        this.access = n;
        this.classType = Type.getType("L" + string.replace('.', '/') + ";");
        this.superType = type != null ? type : Constants.TYPE_OBJECT;
        this.cv.visit(n, this.classType.getInternalName(), this.superType.getInternalName(), TypeUtils.toInternalNames(typeArray), string2);
        this.init();
    }

    public CodeEmitter getStaticHook() {
        if (TypeUtils.isInterface(this.access)) {
            throw new IllegalStateException("static hook is invalid for this class");
        }
        if (this.hook == null) {
            ClassEmitter classEmitter = new ClassEmitter(this.outer);
            classEmitter.declare_field(26, STATIC_HOOK_FLAG, Type.BOOLEAN_TYPE, null, null);
            CodeEmitter codeEmitter = classEmitter.begin_method(8, STATIC_HOOK, null, null);
            Label label = codeEmitter.make_label();
            codeEmitter.getstatic(this.classType, STATIC_HOOK_FLAG, Type.BOOLEAN_TYPE);
            codeEmitter.if_jump(153, label);
            codeEmitter.return_value();
            codeEmitter.mark(label);
            codeEmitter.push(true);
            codeEmitter.putstatic(this.classType, STATIC_HOOK_FLAG, Type.BOOLEAN_TYPE);
        }
        return this.hook;
    }

    protected void init() {
    }

    public int getAccess() {
        return this.access;
    }

    public Type getClassType() {
        return this.classType;
    }

    public Type getSuperType() {
        return this.superType;
    }

    public void end_class() {
        if (this.seenStatic && this.hook == null) {
            this.getStaticHook();
        }
        if (this.hook != null) {
            if (!this.seenStatic) {
                CodeVisitor codeVisitor = this.outer.visitMethod(8, Constants.SIG_STATIC.getName(), Constants.SIG_STATIC.getDescriptor(), null, null);
                codeVisitor.visitInsn(177);
                codeVisitor.visitMaxs(0, 0);
            }
            this.ended = true;
            this.hook.return_value();
            this.hook.end_method();
        }
        this.cv.visitEnd();
    }

    public CodeEmitter begin_method(int n, Signature signature, Type[] typeArray, Attribute attribute) {
        CodeVisitor codeVisitor = this.cv.visitMethod(n, signature.getName(), signature.getDescriptor(), TypeUtils.toInternalNames(typeArray), attribute);
        if (signature.equals(STATIC_HOOK)) {
            this.hook = new CodeEmitter(this, codeVisitor, n, signature, typeArray){

                public boolean isStaticHook() {
                    return true;
                }

                public void visitMaxs(int n, int n2) {
                    if (ClassEmitter.this.ended) {
                        super.visitMaxs(n, n2);
                    }
                }

                public void visitInsn(int n) {
                    if (n != 177 || ClassEmitter.this.ended) {
                        super.visitInsn(n);
                    }
                }
            };
            return this.hook;
        }
        CodeEmitter codeEmitter = new CodeEmitter(this, codeVisitor, n, signature, typeArray);
        if (signature.equals(Constants.SIG_STATIC) && !TypeUtils.isInterface(this.access)) {
            this.seenStatic = true;
            codeEmitter.invoke_static_this(STATIC_HOOK);
        }
        return codeEmitter;
    }

    public CodeEmitter begin_static() {
        return this.begin_method(8, Constants.SIG_STATIC, null, null);
    }

    public void declare_field(int n, String string, Type type, Object object, Attribute attribute) {
        FieldInfo fieldInfo = (FieldInfo)this.fieldInfo.get(string);
        FieldInfo fieldInfo2 = new FieldInfo(n, string, type, object);
        if (fieldInfo != null) {
            if (!fieldInfo2.equals(fieldInfo)) {
                throw new IllegalArgumentException("Field \"" + string + "\" has been declared differently");
            }
        } else {
            this.fieldInfo.put(string, fieldInfo2);
            this.cv.visitField(n, string, type.getDescriptor(), object, attribute);
        }
    }

    public void define_attribute(Attribute attribute) {
        this.cv.visitAttribute(attribute);
    }

    boolean isFieldDeclared(String string) {
        return this.fieldInfo.get(string) != null;
    }

    FieldInfo getFieldInfo(String string) {
        FieldInfo fieldInfo = (FieldInfo)this.fieldInfo.get(string);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("Field " + string + " is not declared in " + this.classType.getClassName());
        }
        return fieldInfo;
    }

    public void visit(int n, String string, String string2, String[] stringArray, String string3) {
        this.begin_class(n, string.replace('/', '.'), TypeUtils.fromInternalName(string2), TypeUtils.fromInternalNames(stringArray), string3);
    }

    public void visitEnd() {
        this.end_class();
    }

    public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        this.declare_field(n, string, Type.getType(string2), object, attribute);
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        return this.begin_method(n, new Signature(string, string2), TypeUtils.fromInternalNames(stringArray), attribute);
    }

    public void visitAttribute(Attribute attribute) {
        this.define_attribute(attribute);
    }

    static class FieldInfo {
        int access;
        String name;
        Type type;
        Object value;

        public FieldInfo(int n, String string, Type type, Object object) {
            this.access = n;
            this.name = string;
            this.type = type;
            this.value = object;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof FieldInfo)) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)object;
            if (this.access != fieldInfo.access || !this.name.equals(fieldInfo.name) || !this.type.equals(fieldInfo.type)) {
                return false;
            }
            if (this.value == null ^ fieldInfo.value == null) {
                return false;
            }
            return this.value == null || this.value.equals(fieldInfo.value);
        }

        public int hashCode() {
            return this.access ^ this.name.hashCode() ^ this.type.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

