/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.logicalcobwebs.asm.ClassReader;
import org.logicalcobwebs.cglib.core.ClassGenerator;
import org.logicalcobwebs.cglib.core.ClassNameReader;
import org.logicalcobwebs.cglib.core.CodeGenerationException;
import org.logicalcobwebs.cglib.core.DefaultGeneratorStrategy;
import org.logicalcobwebs.cglib.core.DefaultNamingPolicy;
import org.logicalcobwebs.cglib.core.GeneratorStrategy;
import org.logicalcobwebs.cglib.core.NamingPolicy;
import org.logicalcobwebs.cglib.core.Predicate;
import org.logicalcobwebs.cglib.core.ReflectUtils;

public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Object NAME_KEY = new Object();
    private GeneratorStrategy strategy = DefaultGeneratorStrategy.INSTANCE;
    private NamingPolicy namingPolicy;
    private Source source;
    private ClassLoader classLoader;
    private String namePrefix;
    private Object key;
    private boolean useCache = true;

    protected AbstractClassGenerator(Source source) {
        this.source = source;
    }

    protected void setNamePrefix(String string) {
        this.namePrefix = string;
    }

    protected final String getClassName() {
        return this.getClassName(this.getClassLoader());
    }

    private String getClassName(ClassLoader classLoader) {
        NamingPolicy namingPolicy = this.namingPolicy != null ? this.namingPolicy : DefaultNamingPolicy.INSTANCE;
        final Set set = this.getClassNameCache(classLoader);
        return namingPolicy.getClassName(this.namePrefix, this.source.name, this.key, new Predicate(){

            public boolean evaluate(Object object) {
                return set.contains(object);
            }
        });
    }

    private Set getClassNameCache(ClassLoader classLoader) {
        return (Set)((Map)this.source.cache.get(classLoader)).get(NAME_KEY);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setNamingPolicy(NamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
    }

    public void setUseCache(boolean bl) {
        this.useCache = bl;
    }

    public void setStrategy(GeneratorStrategy generatorStrategy) {
        this.strategy = generatorStrategy;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            classLoader = this.getDefaultClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("Cannot determine classloader");
        }
        return classLoader;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object create(Object object) {
        try {
            Object object2 = null;
            Source source = this.source;
            synchronized (source) {
                ClassLoader classLoader = this.getClassLoader();
                HashMap<Object, Object> hashMap = null;
                if (this.useCache) {
                    hashMap = (HashMap<Object, Object>)this.source.cache.get(classLoader);
                    if (hashMap != null) {
                        object2 = hashMap.get(object);
                    } else {
                        hashMap = new HashMap<Object, Object>();
                        hashMap.put(NAME_KEY, new HashSet());
                        this.source.cache.put(classLoader, hashMap);
                    }
                }
                if (object2 == null) {
                    this.key = object;
                    byte[] byArray = this.strategy.generate(this);
                    String string = ClassNameReader.getClassName(new ClassReader(byArray));
                    this.getClassNameCache(classLoader).add(string);
                    object2 = this.firstInstance(ReflectUtils.defineClass(string, byArray, classLoader));
                    if (this.useCache) {
                        hashMap.put(object, object2);
                    }
                    return object2;
                }
            }
            return this.nextInstance(object2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    protected abstract Object firstInstance(Class var1) throws Exception;

    protected abstract Object nextInstance(Object var1) throws Exception;

    protected static class Source {
        String name;
        Map cache = new WeakHashMap();

        public Source(String string) {
            this.name = string;
        }
    }
}

