/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm.util;

import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.ClassAdapter;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.util.CheckCodeAdapter;

public class CheckClassAdapter
extends ClassAdapter {
    private boolean start;
    private boolean end;

    public CheckClassAdapter(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public void visit(int n, String string, String string2, String[] stringArray, String string3) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(n, 198199);
        CheckCodeAdapter.checkInternalName(string, "class name");
        if (string.equals("java/lang/Object")) {
            if (string2 != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckCodeAdapter.checkInternalName(string2, "super class name");
        }
        if ((n & 0x200) != 0 && !string2.equals("java/lang/Object")) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CheckCodeAdapter.checkInternalName(stringArray[i], "interface name at index " + i);
            }
        }
        this.cv.visit(n, string, string2, stringArray, string3);
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.checkState();
        CheckCodeAdapter.checkInternalName(string, "class name");
        if (string2 != null) {
            CheckCodeAdapter.checkInternalName(string2, "outer class name");
        }
        if (string3 != null) {
            CheckCodeAdapter.checkIdentifier(string3, "inner class name");
        }
        CheckClassAdapter.checkAccess(n, 1599);
        this.cv.visitInnerClass(string, string2, string3, n);
    }

    public void visitField(int n, String string, String string2, Object object, Attribute attribute) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 196831);
        CheckCodeAdapter.checkIdentifier(string, "field name");
        CheckCodeAdapter.checkDesc(string2, false);
        if (object != null) {
            CheckCodeAdapter.checkConstant(object);
        }
        this.cv.visitField(n, string, string2, object, attribute);
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 199999);
        CheckCodeAdapter.checkMethodIdentifier(string, "method name");
        CheckCodeAdapter.checkMethodDesc(string2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CheckCodeAdapter.checkInternalName(stringArray[i], "exception name at index " + i);
            }
        }
        return new CheckCodeAdapter(this.cv.visitMethod(n, string, string2, stringArray, attribute));
    }

    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int n, int n2) {
        int n3;
        int n4;
        if ((n & ~n2) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + n);
        }
        int n5 = (n & 1) != 0 ? 1 : 0;
        int n6 = (n & 2) != 0 ? 1 : 0;
        int n7 = n4 = (n & 4) != 0 ? 1 : 0;
        if (n5 + n6 + n4 > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + n);
        }
        int n8 = (n & 0x10) != 0 ? 1 : 0;
        int n9 = n3 = (n & 0x400) != 0 ? 1 : 0;
        if (n8 + n3 > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + n);
        }
    }
}

