/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm;

import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.ByteVector;
import org.logicalcobwebs.asm.ClassWriter;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.Edge;
import org.logicalcobwebs.asm.Item;
import org.logicalcobwebs.asm.Label;

public class CodeWriter
implements CodeVisitor {
    static final boolean CHECK = false;
    CodeWriter next;
    private ClassWriter cw;
    private int name;
    private int desc;
    private int access;
    private int maxStack;
    private int maxLocals;
    private ByteVector code = new ByteVector();
    private int catchCount;
    private ByteVector catchTable;
    private int exceptionCount;
    private int[] exceptions;
    private Attribute attrs;
    private int localVarCount;
    private ByteVector localVar;
    private int lineNumberCount;
    private ByteVector lineNumber;
    private Attribute cattrs;
    private boolean resize;
    private final boolean computeMaxs;
    private int stackSize;
    private int maxStackSize;
    private Label currentBlock;
    private Label blockStack;
    private static final int[] SIZE;
    private Edge head;
    private Edge tail;
    private static Edge pool;

    protected CodeWriter(ClassWriter classWriter, boolean bl) {
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
            classWriter.lastMethod = this;
        } else {
            classWriter.lastMethod.next = this;
            classWriter.lastMethod = this;
        }
        this.cw = classWriter;
        this.computeMaxs = bl;
        if (bl) {
            this.currentBlock = new Label();
            this.currentBlock.pushed = true;
            this.blockStack = this.currentBlock;
        }
    }

    protected void init(int n, String string, String string2, String[] stringArray, Attribute attribute) {
        int n2;
        this.access = n;
        this.name = this.cw.newUTF8(string);
        this.desc = this.cw.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.exceptionCount = stringArray.length;
            this.exceptions = new int[this.exceptionCount];
            for (n2 = 0; n2 < this.exceptionCount; ++n2) {
                this.exceptions[n2] = this.cw.newClass(stringArray[n2]);
            }
        }
        this.attrs = attribute;
        if (this.computeMaxs) {
            n2 = CodeWriter.getArgumentsAndReturnSizes(string2) >> 2;
            if ((n & 8) != 0) {
                --n2;
            }
            if (n2 > this.maxLocals) {
                this.maxLocals = n2;
            }
        }
    }

    public void visitInsn(int n) {
        if (this.computeMaxs) {
            int n2 = this.stackSize + SIZE[n];
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
            if ((n >= 172 && n <= 177 || n == 191) && this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.currentBlock = null;
            }
        }
        this.code.put1(n);
    }

    public void visitIntInsn(int n, int n2) {
        if (this.computeMaxs && n != 188) {
            int n3 = this.stackSize + 1;
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        if (n == 17) {
            this.code.put12(n, n2);
        } else {
            this.code.put11(n, n2);
        }
    }

    public void visitVarInsn(int n, int n2) {
        int n3;
        if (this.computeMaxs) {
            if (n == 169) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.currentBlock = null;
                }
            } else {
                n3 = this.stackSize + SIZE[n];
                if (n3 > this.maxStackSize) {
                    this.maxStackSize = n3;
                }
                this.stackSize = n3;
            }
            if ((n3 = n == 22 || n == 24 || n == 55 || n == 57 ? n2 + 2 : n2 + 1) > this.maxLocals) {
                this.maxLocals = n3;
            }
        }
        if (n2 < 4 && n != 169) {
            n3 = n < 54 ? 26 + (n - 21 << 2) + n2 : 59 + (n - 54 << 2) + n2;
            this.code.put1(n3);
        } else if (n2 >= 256) {
            this.code.put1(196).put12(n, n2);
        } else {
            this.code.put11(n, n2);
        }
    }

    public void visitTypeInsn(int n, String string) {
        if (this.computeMaxs && n == 187) {
            int n2 = this.stackSize + 1;
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
        }
        this.code.put12(n, this.cw.newClass(string));
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        if (this.computeMaxs) {
            int n2;
            char c = string3.charAt(0);
            switch (n) {
                case 178: {
                    n2 = this.stackSize + (c == 'D' || c == 'J' ? 2 : 1);
                    break;
                }
                case 179: {
                    n2 = this.stackSize + (c == 'D' || c == 'J' ? -2 : -1);
                    break;
                }
                case 180: {
                    n2 = this.stackSize + (c == 'D' || c == 'J' ? 1 : 0);
                    break;
                }
                default: {
                    n2 = this.stackSize + (c == 'D' || c == 'J' ? -3 : -2);
                }
            }
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
        }
        this.code.put12(n, this.cw.newField(string, string2, string3));
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        boolean bl = n == 185;
        Item item = this.cw.newMethodItem(string, string2, string3, bl);
        int n2 = item.intVal;
        if (this.computeMaxs) {
            int n3;
            if (n2 == 0) {
                item.intVal = n2 = CodeWriter.getArgumentsAndReturnSizes(string3);
            }
            if ((n3 = n == 184 ? this.stackSize - (n2 >> 2) + (n2 & 3) + 1 : this.stackSize - (n2 >> 2) + (n2 & 3)) > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        if (bl) {
            if (!this.computeMaxs && n2 == 0) {
                item.intVal = n2 = CodeWriter.getArgumentsAndReturnSizes(string3);
            }
            this.code.put12(185, item.index).put11(n2 >> 2, 0);
        } else {
            this.code.put12(n, item.index);
        }
    }

    public void visitJumpInsn(int n, Label label) {
        if (this.computeMaxs) {
            if (n == 167) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.addSuccessor(this.stackSize, label);
                    this.currentBlock = null;
                }
            } else if (n == 168) {
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize + 1, label);
                }
            } else {
                this.stackSize += SIZE[n];
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize, label);
                }
            }
        }
        if (label.resolved && label.position - this.code.length < Short.MIN_VALUE) {
            if (n == 167) {
                this.code.put1(200);
            } else if (n == 168) {
                this.code.put1(201);
            } else {
                this.code.put1(n <= 166 ? (n + 1 ^ 1) - 1 : n ^ 1);
                this.code.put2(8);
                this.code.put1(200);
            }
            label.put(this, this.code, this.code.length - 1, true);
        } else {
            this.code.put1(n);
            label.put(this, this.code, this.code.length - 1, false);
        }
    }

    public void visitLabel(Label label) {
        if (this.computeMaxs) {
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
            }
            this.currentBlock = label;
            this.stackSize = 0;
            this.maxStackSize = 0;
        }
        this.resize |= label.resolve(this, this.code.length, this.code.data);
    }

    public void visitLdcInsn(Object object) {
        int n;
        Item item = this.cw.newConst(object);
        if (this.computeMaxs) {
            n = item.type == 5 || item.type == 6 ? this.stackSize + 2 : this.stackSize + 1;
            if (n > this.maxStackSize) {
                this.maxStackSize = n;
            }
            this.stackSize = n;
        }
        n = item.index;
        if (item.type == 5 || item.type == 6) {
            this.code.put12(20, n);
        } else if (n >= 256) {
            this.code.put12(19, n);
        } else {
            this.code.put11(18, n);
        }
    }

    public void visitIincInsn(int n, int n2) {
        int n3;
        if (this.computeMaxs && (n3 = n + 1) > this.maxLocals) {
            this.maxLocals = n3;
        }
        if (n > 255 || n2 > 127 || n2 < -128) {
            this.code.put1(196).put12(132, n).put2(n2);
        } else {
            this.code.put1(132).put11(n, n2);
        }
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        int n3;
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                for (n3 = 0; n3 < labelArray.length; ++n3) {
                    this.addSuccessor(this.stackSize, labelArray[n3]);
                }
                this.currentBlock = null;
            }
        }
        n3 = this.code.length;
        this.code.put1(170);
        while (this.code.length % 4 != 0) {
            this.code.put1(0);
        }
        label.put(this, this.code, n3, true);
        this.code.put4(n).put4(n2);
        for (int i = 0; i < labelArray.length; ++i) {
            labelArray[i].put(this, this.code, n3, true);
        }
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n;
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                for (n = 0; n < labelArray.length; ++n) {
                    this.addSuccessor(this.stackSize, labelArray[n]);
                }
                this.currentBlock = null;
            }
        }
        n = this.code.length;
        this.code.put1(171);
        while (this.code.length % 4 != 0) {
            this.code.put1(0);
        }
        label.put(this, this.code, n, true);
        this.code.put4(labelArray.length);
        for (int i = 0; i < labelArray.length; ++i) {
            this.code.put4(nArray[i]);
            labelArray[i].put(this, this.code, n, true);
        }
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        if (this.computeMaxs) {
            this.stackSize += 1 - n;
        }
        this.code.put12(197, this.cw.newClass(string)).put1(n);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        if (this.computeMaxs && !label3.pushed) {
            label3.beginStackSize = 1;
            label3.pushed = true;
            label3.next = this.blockStack;
            this.blockStack = label3;
        }
        ++this.catchCount;
        if (this.catchTable == null) {
            this.catchTable = new ByteVector();
        }
        this.catchTable.put2(label.position);
        this.catchTable.put2(label2.position);
        this.catchTable.put2(label3.position);
        this.catchTable.put2(string != null ? this.cw.newClass(string) : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMaxs(int n, int n2) {
        if (this.computeMaxs) {
            Object object;
            int n3 = 0;
            Object object2 = this.blockStack;
            while (object2 != null) {
                object = object2;
                object2 = ((Label)object2).next;
                int n4 = ((Label)object).beginStackSize;
                int n5 = n4 + ((Label)object).maxStackSize;
                if (n5 > n3) {
                    n3 = n5;
                }
                Edge edge = ((Label)object).successors;
                while (edge != null) {
                    object = edge.successor;
                    if (!((Label)object).pushed) {
                        ((Label)object).beginStackSize = n4 + edge.stackSize;
                        ((Label)object).pushed = true;
                        ((Label)object).next = object2;
                        object2 = object;
                    }
                    edge = edge.next;
                }
            }
            this.maxStack = n3;
            object = SIZE;
            synchronized (SIZE) {
                if (this.tail != null) {
                    this.tail.poolNext = pool;
                    pool = this.head;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        } else {
            this.maxStack = n;
            this.maxLocals = n2;
        }
    }

    public void visitLocalVariable(String string, String string2, Label label, Label label2, int n) {
        if (this.localVar == null) {
            this.cw.newUTF8("LocalVariableTable");
            this.localVar = new ByteVector();
        }
        ++this.localVarCount;
        this.localVar.put2(label.position);
        this.localVar.put2(label2.position - label.position);
        this.localVar.put2(this.cw.newUTF8(string));
        this.localVar.put2(this.cw.newUTF8(string2));
        this.localVar.put2(n);
    }

    public void visitLineNumber(int n, Label label) {
        if (this.lineNumber == null) {
            this.cw.newUTF8("LineNumberTable");
            this.lineNumber = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumber.put2(label.position);
        this.lineNumber.put2(n);
    }

    public void visitAttribute(Attribute attribute) {
        attribute.next = this.cattrs;
        this.cattrs = attribute;
    }

    private static int getArgumentsAndReturnSizes(String string) {
        int n = 1;
        int n2 = 1;
        while (true) {
            char c;
            if ((c = string.charAt(n2++)) == ')') {
                c = string.charAt(n2);
                return n << 2 | (c == 'V' ? 0 : (c == 'D' || c == 'J' ? 2 : 1));
            }
            if (c == 'L') {
                while (string.charAt(n2++) != ';') {
                }
                ++n;
                continue;
            }
            if (c == '[') {
                while ((c = string.charAt(n2)) == '[') {
                    ++n2;
                }
                if (c != 'D' && c != 'J') continue;
                --n;
                continue;
            }
            if (c == 'D' || c == 'J') {
                n += 2;
                continue;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSuccessor(int n, Label label) {
        int[] nArray = SIZE;
        synchronized (SIZE) {
            Edge edge;
            if (pool == null) {
                edge = new Edge();
            } else {
                edge = pool;
                pool = CodeWriter.pool.poolNext;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (this.tail == null) {
                this.tail = edge;
            }
            edge.poolNext = this.head;
            this.head = edge;
            edge.stackSize = n;
            edge.successor = label;
            edge.next = this.currentBlock.successors;
            this.currentBlock.successors = edge;
            return;
        }
    }

    final int getSize() {
        if (this.resize) {
            this.resizeInstructions(new int[0], new int[0], 0);
        }
        int n = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n += 18 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n += 8 + this.localVar.length;
            }
            if (this.lineNumber != null) {
                n += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                n += this.cattrs.getSize(this.cw);
            }
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            n += 8 + 2 * this.exceptionCount;
        }
        if ((this.access & 0x10000) != 0) {
            this.cw.newUTF8("Synthetic");
            n += 6;
        }
        if ((this.access & 0x20000) != 0) {
            this.cw.newUTF8("Deprecated");
            n += 6;
        }
        if (this.attrs != null) {
            n += this.attrs.getSize(this.cw);
        }
        return n;
    }

    final void put(ByteVector byteVector) {
        int n;
        byteVector.put2(this.access).put2(this.name).put2(this.desc);
        int n2 = 0;
        if (this.code.length > 0) {
            ++n2;
        }
        if (this.exceptionCount > 0) {
            ++n2;
        }
        if ((this.access & 0x10000) != 0) {
            ++n2;
        }
        if ((this.access & 0x20000) != 0) {
            ++n2;
        }
        if (this.attrs != null) {
            n2 += this.attrs.getCount();
        }
        byteVector.put2(n2);
        if (this.code.length > 0) {
            n = 12 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n += 8 + this.localVar.length;
            }
            if (this.lineNumber != null) {
                n += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                n += this.cattrs.getSize(this.cw);
            }
            byteVector.put2(this.cw.newUTF8("Code")).put4(n);
            byteVector.put2(this.maxStack).put2(this.maxLocals);
            byteVector.put4(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            byteVector.put2(this.catchCount);
            if (this.catchCount > 0) {
                byteVector.putByteArray(this.catchTable.data, 0, this.catchTable.length);
            }
            n2 = 0;
            if (this.localVar != null) {
                ++n2;
            }
            if (this.lineNumber != null) {
                ++n2;
            }
            if (this.cattrs != null) {
                n2 += this.cattrs.getCount();
            }
            byteVector.put2(n2);
            if (this.localVar != null) {
                byteVector.put2(this.cw.newUTF8("LocalVariableTable"));
                byteVector.put4(this.localVar.length + 2).put2(this.localVarCount);
                byteVector.putByteArray(this.localVar.data, 0, this.localVar.length);
            }
            if (this.lineNumber != null) {
                byteVector.put2(this.cw.newUTF8("LineNumberTable"));
                byteVector.put4(this.lineNumber.length + 2).put2(this.lineNumberCount);
                byteVector.putByteArray(this.lineNumber.data, 0, this.lineNumber.length);
            }
            if (this.cattrs != null) {
                this.cattrs.put(this.cw, byteVector);
            }
        }
        if (this.exceptionCount > 0) {
            byteVector.put2(this.cw.newUTF8("Exceptions")).put4(2 * this.exceptionCount + 2);
            byteVector.put2(this.exceptionCount);
            for (n = 0; n < this.exceptionCount; ++n) {
                byteVector.put2(this.exceptions[n]);
            }
        }
        if ((this.access & 0x10000) != 0) {
            byteVector.put2(this.cw.newUTF8("Synthetic")).put4(0);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.put2(this.cw.newUTF8("Deprecated")).put4(0);
        }
        if (this.attrs != null) {
            this.attrs.put(this.cw, byteVector);
        }
    }

    protected int[] resizeInstructions(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray = this.code.data;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray4, 0, n);
        boolean[] blArray = new boolean[this.code.length];
        int n6 = 3;
        do {
            if (n6 == 3) {
                n6 = 2;
            }
            n5 = 0;
            while (n5 < byArray.length) {
                int n7 = byArray[n5] & 0xFF;
                n4 = 0;
                switch (ClassWriter.TYPE[n7]) {
                    case 0: 
                    case 4: {
                        ++n5;
                        break;
                    }
                    case 8: {
                        if (n7 > 201) {
                            n7 = n7 < 218 ? n7 - 49 : n7 - 20;
                            n3 = n5 + CodeWriter.readUnsignedShort(byArray, n5 + 1);
                        } else {
                            n3 = n5 + CodeWriter.readShort(byArray, n5 + 1);
                        }
                        n2 = CodeWriter.getNewOffset(nArray3, nArray4, n5, n3);
                        if (!(n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE || blArray[n5])) {
                            n4 = n7 == 167 || n7 == 168 ? 2 : 5;
                            blArray[n5] = true;
                        }
                        n5 += 3;
                        break;
                    }
                    case 9: {
                        n5 += 5;
                        break;
                    }
                    case 13: {
                        if (n6 == 1) {
                            n2 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n5);
                            n4 = -(n2 & 3);
                        } else if (!blArray[n5]) {
                            n4 = n5 & 3;
                            blArray[n5] = true;
                        }
                        n5 = n5 + 4 - (n5 & 3);
                        n5 += 4 * (CodeWriter.readInt(byArray, n5 + 8) - CodeWriter.readInt(byArray, n5 + 4) + 1) + 12;
                        break;
                    }
                    case 14: {
                        if (n6 == 1) {
                            n2 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n5);
                            n4 = -(n2 & 3);
                        } else if (!blArray[n5]) {
                            n4 = n5 & 3;
                            blArray[n5] = true;
                        }
                        n5 = n5 + 4 - (n5 & 3);
                        n5 += 8 * CodeWriter.readInt(byArray, n5 + 4) + 8;
                        break;
                    }
                    case 16: {
                        n7 = byArray[n5 + 1] & 0xFF;
                        if (n7 == 132) {
                            n5 += 6;
                            break;
                        }
                        n5 += 4;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 10: {
                        n5 += 2;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: {
                        n5 += 3;
                        break;
                    }
                    case 7: {
                        n5 += 5;
                        break;
                    }
                    default: {
                        n5 += 4;
                    }
                }
                if (n4 == 0) continue;
                int[] nArray5 = new int[nArray3.length + 1];
                int[] nArray6 = new int[nArray4.length + 1];
                System.arraycopy(nArray3, 0, nArray5, 0, nArray3.length);
                System.arraycopy(nArray4, 0, nArray6, 0, nArray4.length);
                nArray5[nArray3.length] = n5;
                nArray6[nArray4.length] = n4;
                nArray3 = nArray5;
                nArray4 = nArray6;
                if (n4 <= 0) continue;
                n6 = 3;
            }
            if (n6 >= 3) continue;
            --n6;
        } while (n6 != 0);
        ByteVector byteVector = new ByteVector(this.code.length);
        n5 = 0;
        block24: while (n5 < this.code.length) {
            for (int i = nArray3.length - 1; i >= 0; --i) {
                if (nArray3[i] != n5 || i >= n) continue;
                if (nArray2[i] > 0) {
                    byteVector.putByteArray(null, 0, nArray2[i]);
                } else {
                    byteVector.length += nArray2[i];
                }
                nArray[i] = byteVector.length;
            }
            n4 = byArray[n5] & 0xFF;
            switch (ClassWriter.TYPE[n4]) {
                case 0: 
                case 4: {
                    byteVector.put1(n4);
                    ++n5;
                    continue block24;
                }
                case 8: {
                    if (n4 > 201) {
                        n4 = n4 < 218 ? n4 - 49 : n4 - 20;
                        n3 = n5 + CodeWriter.readUnsignedShort(byArray, n5 + 1);
                    } else {
                        n3 = n5 + CodeWriter.readShort(byArray, n5 + 1);
                    }
                    n2 = CodeWriter.getNewOffset(nArray3, nArray4, n5, n3);
                    if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
                        if (n4 == 167) {
                            byteVector.put1(200);
                        } else if (n4 == 168) {
                            byteVector.put1(201);
                        } else {
                            byteVector.put1(n4 <= 166 ? (n4 + 1 ^ 1) - 1 : n4 ^ 1);
                            byteVector.put2(8);
                            byteVector.put1(200);
                            n2 -= 3;
                        }
                        byteVector.put4(n2);
                    } else {
                        byteVector.put1(n4);
                        byteVector.put2(n2);
                    }
                    n5 += 3;
                    continue block24;
                }
                case 9: {
                    n3 = n5 + CodeWriter.readInt(byArray, n5 + 1);
                    n2 = CodeWriter.getNewOffset(nArray3, nArray4, n5, n3);
                    byteVector.put1(n4);
                    byteVector.put4(n2);
                    n5 += 5;
                    continue block24;
                }
                case 13: {
                    int n8 = n5;
                    n5 = n5 + 4 - (n8 & 3);
                    int n9 = byteVector.length;
                    byteVector.put1(170);
                    while (byteVector.length % 4 != 0) {
                        byteVector.put1(0);
                    }
                    n3 = n8 + CodeWriter.readInt(byArray, n5);
                    n2 = CodeWriter.getNewOffset(nArray3, nArray4, n8, n3);
                    byteVector.put4(n2);
                    int n10 = CodeWriter.readInt(byArray, n5 += 4);
                    byteVector.put4(n10);
                    byteVector.put4(CodeWriter.readInt(byArray, (n5 += 4) - 4));
                    for (n10 = CodeWriter.readInt(byArray, n5 += 4) - n10 + 1; n10 > 0; --n10) {
                        n3 = n8 + CodeWriter.readInt(byArray, n5);
                        n5 += 4;
                        n2 = CodeWriter.getNewOffset(nArray3, nArray4, n8, n3);
                        byteVector.put4(n2);
                    }
                    continue block24;
                }
                case 14: {
                    int n10;
                    int n8 = n5;
                    n5 = n5 + 4 - (n8 & 3);
                    int n9 = byteVector.length;
                    byteVector.put1(171);
                    while (byteVector.length % 4 != 0) {
                        byteVector.put1(0);
                    }
                    n3 = n8 + CodeWriter.readInt(byArray, n5);
                    n2 = CodeWriter.getNewOffset(nArray3, nArray4, n8, n3);
                    byteVector.put4(n2);
                    n5 += 4;
                    byteVector.put4(n10);
                    for (n10 = CodeWriter.readInt(byArray, n5 += 4); n10 > 0; --n10) {
                        byteVector.put4(CodeWriter.readInt(byArray, n5));
                        n3 = n8 + CodeWriter.readInt(byArray, n5 += 4);
                        n5 += 4;
                        n2 = CodeWriter.getNewOffset(nArray3, nArray4, n8, n3);
                        byteVector.put4(n2);
                    }
                    continue block24;
                }
                case 16: {
                    n4 = byArray[n5 + 1] & 0xFF;
                    if (n4 == 132) {
                        byteVector.putByteArray(byArray, n5, 6);
                        n5 += 6;
                        continue block24;
                    }
                    byteVector.putByteArray(byArray, n5, 4);
                    n5 += 4;
                    continue block24;
                }
                case 1: 
                case 3: 
                case 10: {
                    byteVector.putByteArray(byArray, n5, 2);
                    n5 += 2;
                    continue block24;
                }
                case 2: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    byteVector.putByteArray(byArray, n5, 3);
                    n5 += 3;
                    continue block24;
                }
                case 7: {
                    byteVector.putByteArray(byArray, n5, 5);
                    n5 += 5;
                    continue block24;
                }
            }
            byteVector.putByteArray(byArray, n5, 4);
            n5 += 4;
        }
        if (this.catchTable != null) {
            byArray = this.catchTable.data;
            for (n5 = 0; n5 < this.catchTable.length; n5 += 8) {
                CodeWriter.writeShort(byArray, n5, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n5)));
                CodeWriter.writeShort(byArray, n5 + 2, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n5 + 2)));
                CodeWriter.writeShort(byArray, n5 + 4, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n5 + 4)));
            }
        }
        if (this.localVar != null) {
            byArray = this.localVar.data;
            for (n5 = 0; n5 < this.localVar.length; n5 += 10) {
                n3 = CodeWriter.readUnsignedShort(byArray, n5);
                n2 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n3);
                CodeWriter.writeShort(byArray, n5, n2);
                n2 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n3 += CodeWriter.readUnsignedShort(byArray, n5 + 2)) - n2;
                CodeWriter.writeShort(byArray, n5, n2);
            }
        }
        if (this.lineNumber != null) {
            byArray = this.lineNumber.data;
            for (n5 = 0; n5 < this.lineNumber.length; n5 += 4) {
                CodeWriter.writeShort(byArray, n5, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n5)));
            }
        }
        this.code = byteVector;
        return nArray;
    }

    static int readUnsignedShort(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    static short readShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    static int readInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static void writeShort(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)n2;
    }

    static int getNewOffset(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n2 - n;
        for (int i = 0; i < nArray.length; ++i) {
            if (n < nArray[i] && nArray[i] <= n2) {
                n3 += nArray2[i];
                continue;
            }
            if (n2 >= nArray[i] || nArray[i] > n) continue;
            n3 -= nArray2[i];
        }
        return n3;
    }

    protected int getCodeSize() {
        return this.code.length;
    }

    protected byte[] getCode() {
        return this.code.data;
    }

    static {
        int[] nArray = new int[202];
        String string = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = string.charAt(i) - 69;
        }
        SIZE = nArray;
    }
}

