/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm;

import org.logicalcobwebs.asm.ByteVector;
import org.logicalcobwebs.asm.ClassWriter;

public class Attribute {
    public String type;
    public byte[] b;
    public int off;
    public int len;
    public Attribute next;

    public Attribute(String string, byte[] byArray, int n, int n2) {
        this.type = string;
        this.b = byArray;
        this.off = n;
        this.len = n2;
    }

    public Attribute(String string) {
        this(string, null, 0, 0);
    }

    final int getCount() {
        int n = 0;
        Attribute attribute = this;
        while (attribute != null) {
            ++n;
            attribute = attribute.next;
        }
        return n;
    }

    final int getSize(ClassWriter classWriter) {
        int n = 0;
        Attribute attribute = this;
        while (attribute != null) {
            classWriter.newUTF8(attribute.type);
            n += classWriter.writeAttribute(attribute).length + 6;
            attribute = attribute.next;
        }
        return n;
    }

    final void put(ClassWriter classWriter, ByteVector byteVector) {
        Attribute attribute = this;
        while (attribute != null) {
            byte[] byArray = classWriter.writeAttribute(attribute);
            byteVector.put2(classWriter.newUTF8(attribute.type)).put4(byArray.length);
            byteVector.putByteArray(byArray, 0, byArray.length);
            attribute = attribute.next;
        }
    }
}

