/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PropertyUtil {
    private static final Log LOG = LogFactory.getLog((String)PropertyUtil.class.getName());

    private PropertyUtil() {
    }

    public static String extractAndLogProperty(String string, Properties properties) {
        if (properties == null || properties.size() == 0) {
            return null;
        }
        String string2 = (String)properties.get(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value found for " + string + ": " + string2));
        }
        return string2;
    }

    public static String extractAndLogProperty(String string, Map map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        String string2 = (String)map.get(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value found for " + string + ": " + string2));
        }
        return string2;
    }

    public static Properties parseProperties(String string) {
        if (string == null) {
            LOG.debug((Object)"propertiesString is null.");
            return null;
        }
        Properties properties = new Properties();
        String string2 = string.trim();
        string2 = string2.replace(',', '\n');
        try {
            properties.load(new ByteArrayInputStream(string2.getBytes()));
        }
        catch (IOException iOException) {
            LOG.error((Object)("Cannot load properties from " + string));
        }
        return properties;
    }

    public static boolean parseBoolean(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }
}

