/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import net.sf.ehcache.CacheException;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static ClassLoader getStandardClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getFallbackClassLoader() {
        return ClassLoaderUtil.class.getClassLoader();
    }

    public static Object createNewInstance(String string) throws CacheException {
        Object obj;
        Class<?> clazz;
        try {
            clazz = Class.forName(string, true, ClassLoaderUtil.getStandardClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(string, true, ClassLoaderUtil.getFallbackClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new CacheException("Unable to load class " + string + ". Initial cause was " + classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        try {
            obj = clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException("Unable to load class " + string + ". Initial cause was " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new CacheException("Unable to load class " + string + ". Initial cause was " + instantiationException.getMessage(), instantiationException);
        }
        return obj;
    }
}

