/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.FifoMemoryStore;
import net.sf.ehcache.store.LfuMemoryStore;
import net.sf.ehcache.store.LruMemoryStore;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Store;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MemoryStore
implements Store {
    private static final Log LOG = LogFactory.getLog((String)MemoryStore.class.getName());
    protected Ehcache cache;
    protected Map map;
    protected final DiskStore diskStore;
    protected Status status = Status.STATUS_UNINITIALISED;

    protected MemoryStore(Ehcache ehcache, DiskStore diskStore) {
        this.cache = ehcache;
        this.diskStore = diskStore;
        this.status = Status.STATUS_ALIVE;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initialized " + this.getClass().getName() + " for " + ehcache.getName()));
        }
    }

    public static MemoryStore create(Ehcache ehcache, DiskStore diskStore) {
        MemoryStore memoryStore = null;
        MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = ehcache.getMemoryStoreEvictionPolicy();
        if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.LRU)) {
            memoryStore = new LruMemoryStore(ehcache, diskStore);
        } else if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.FIFO)) {
            memoryStore = new FifoMemoryStore(ehcache, diskStore);
        } else if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.LFU)) {
            memoryStore = new LfuMemoryStore(ehcache, diskStore);
        }
        return memoryStore;
    }

    public final synchronized void put(Element element) throws CacheException {
        if (element != null) {
            this.map.put(element.getObjectKey(), element);
            this.doPut(element);
        }
    }

    protected void doPut(Element element) throws CacheException {
    }

    public final synchronized Element get(Object object) {
        Element element = (Element)this.map.get(object);
        if (element != null) {
            element.updateAccessStatistics();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.cache.getName() + "Cache: " + this.cache.getName() + "MemoryStore hit for " + object));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.cache.getName() + "Cache: " + this.cache.getName() + "MemoryStore miss for " + object));
        }
        return element;
    }

    public final synchronized Element getQuiet(Object object) {
        Element element = (Element)this.map.get(object);
        if (element != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.cache.getName() + "Cache: " + this.cache.getName() + "MemoryStore hit for " + object));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.cache.getName() + "Cache: " + this.cache.getName() + "MemoryStore miss for " + object));
        }
        return element;
    }

    public final synchronized Element remove(Object object) {
        Element element = (Element)this.map.remove(object);
        if (element != null) {
            return element;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.cache.getName() + "Cache: Cannot remove entry as key " + object + " was not found"));
        }
        return null;
    }

    public final synchronized void removeAll() throws CacheException {
        this.clear();
    }

    protected final void clear() {
        this.map.clear();
    }

    public final synchronized void dispose() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            return;
        }
        this.status = Status.STATUS_SHUTDOWN;
        this.flush();
        this.cache = null;
    }

    public final synchronized void flush() {
        if (this.cache.isOverflowToDisk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.cache.getName() + " is persistent. Spooling " + this.map.size() + " elements to the disk store."));
            }
            this.spoolAllToDisk();
            this.clear();
        }
    }

    protected final void spoolAllToDisk() {
        Object[] objectArray = this.getKeyArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Element element = (Element)this.map.get(objectArray[i]);
            if (element == null) continue;
            if (!element.isSerializable()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Object with key " + element.getObjectKey() + " is not Serializable and is not being overflowed to disk."));
                continue;
            }
            this.spoolToDisk(element);
            this.remove(objectArray[i]);
        }
    }

    protected final void spoolToDisk(Element element) {
        this.diskStore.put(element);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.cache.getName() + "Cache: spool to disk done for: " + element.getObjectKey()));
        }
    }

    public final Status getStatus() {
        return this.status;
    }

    public final synchronized Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    public final int getSize() {
        return this.map.size();
    }

    public final boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public final synchronized long getSizeInBytes() throws CacheException {
        long l = 0L;
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element == null) continue;
            l += element.getSerializedSize();
        }
        return l;
    }

    protected final void evict(Element element) throws CacheException {
        boolean bl = false;
        if (this.cache.isOverflowToDisk()) {
            if (!element.isSerializable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuffer("Object with key ").append(element.getObjectKey()).append(" is not Serializable and cannot be overflowed to disk"));
                }
            } else {
                this.spoolToDisk(element);
                bl = true;
            }
        }
        if (!bl) {
            this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
        }
    }

    protected final void notifyExpiry(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    protected final boolean isFull() {
        return this.map.size() > this.cache.getMaxElementsInMemory();
    }
}

