/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Random;

public final class LfuPolicy {
    private static final int DEFAULT_SAMPLE_SIZE = 30;
    private static final Random RANDOM = new Random();

    private LfuPolicy() {
    }

    private static int calculateSampleSize(int n) {
        if (n < 30) {
            return n;
        }
        return 30;
    }

    public static Metadata leastHit(Metadata[] metadataArray, Metadata metadata) {
        if (metadataArray.length == 1) {
            return metadata;
        }
        Metadata metadata2 = null;
        for (int i = 0; i < metadataArray.length; ++i) {
            Metadata metadata3 = metadataArray[i];
            if (metadata2 == null) {
                if (metadata3.equals(metadata)) continue;
                metadata2 = metadata3;
                continue;
            }
            if (metadata3.getHitCount() >= metadata2.getHitCount() || metadata3.equals(metadata)) continue;
            metadata2 = metadata3;
        }
        return metadata2;
    }

    public static int[] generateRandomSample(int n) {
        int n2 = LfuPolicy.calculateSampleSize(n);
        int[] nArray = new int[n2];
        int n3 = n / n2;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = RANDOM.nextInt(n3);
        }
        return nArray;
    }

    public static interface Metadata {
        public Object getKey();

        public long getHitCount();
    }
}

