/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.MemoryStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LfuMemoryStore
extends MemoryStore {
    private static final Log LOG = LogFactory.getLog((String)LfuMemoryStore.class.getName());
    private static final int DEFAULT_SAMPLE_SIZE = 30;
    private final Random random = new Random();

    protected LfuMemoryStore(Ehcache ehcache, DiskStore diskStore) {
        super(ehcache, diskStore);
        this.map = new HashMap();
    }

    public final synchronized void doPut(Element element) {
        if (this.isFull()) {
            this.removeLfuElement(element);
        }
    }

    private void removeLfuElement(Element element) {
        Element element2;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Cache is full. Removing LFU element ...");
        }
        if ((element2 = this.findRelativelyUnused(element)).isExpired()) {
            this.remove(element2.getObjectKey());
            this.notifyExpiry(element2);
            return;
        }
        this.evict(element2);
        this.remove(element2.getObjectKey());
    }

    final Element findRelativelyUnused(Element element) {
        LfuPolicy.Metadata[] metadataArray = this.sampleElements(this.map.size());
        LfuPolicy.Metadata metadata = LfuPolicy.leastHit(metadataArray, new ElementMetadata(element));
        return (Element)this.map.get(metadata.getKey());
    }

    LfuPolicy.Metadata[] sampleElements(int n) {
        int[] nArray = LfuPolicy.generateRandomSample(n);
        LfuPolicy.Metadata[] metadataArray = new ElementMetadata[nArray.length];
        Iterator iterator = this.map.values().iterator();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i]; ++j) {
                iterator.next();
            }
            metadataArray[i] = new ElementMetadata((Element)iterator.next());
        }
        return metadataArray;
    }

    private class ElementMetadata
    implements LfuPolicy.Metadata {
        private Element element;

        public ElementMetadata(Element element) {
            this.element = element;
        }

        public Object getKey() {
            return this.element.getKey();
        }

        public long getHitCount() {
            return this.element.getHitCount();
        }

        public int hashCode() {
            if (this.element != null) {
                return this.element.getKey().hashCode();
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof LfuPolicy.Metadata) {
                LfuPolicy.Metadata metadata = (LfuPolicy.Metadata)object;
                return this.getKey().equals(metadata.getKey());
            }
            return false;
        }
    }
}

