/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.Store;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiskStore
implements Store {
    public static final String AUTO_DISK_PATH_DIRECTORY_PREFIX = "ehcache_auto_created";
    private static final Log LOG = LogFactory.getLog((String)DiskStore.class.getName());
    private static final int MS_PER_SECOND = 1000;
    private static final int SPOOL_THREAD_INTERVAL = 200;
    private static final int ESTIMATED_MINIMUM_PAYLOAD_SIZE = 512;
    private long expiryThreadInterval;
    private final String name;
    private boolean active;
    private RandomAccessFile randomAccessFile;
    private Map diskElements = Collections.synchronizedMap(new HashMap());
    private List freeSpace = Collections.synchronizedList(new ArrayList());
    private Map spool = Collections.synchronizedMap(new HashMap());
    private Object spoolLock = new Object();
    private Thread spoolAndExpiryThread;
    private Ehcache cache;
    private final boolean persistent;
    private final String diskPath;
    private File dataFile;
    private File indexFile;
    private Status status = Status.STATUS_UNINITIALISED;
    private long totalSize;
    private long maxElementsOnDisk;
    private boolean eternal;

    public DiskStore(Ehcache ehcache, String string) {
        this.cache = ehcache;
        this.name = ehcache.getName();
        this.diskPath = string;
        this.expiryThreadInterval = ehcache.getDiskExpiryThreadIntervalSeconds();
        this.persistent = ehcache.isDiskPersistent();
        this.maxElementsOnDisk = ehcache.getMaxElementsOnDisk();
        this.eternal = ehcache.isEternal();
        try {
            this.initialiseFiles();
            this.active = true;
            this.spoolAndExpiryThread = new SpoolAndExpiryThread();
            this.spoolAndExpiryThread.start();
            this.status = Status.STATUS_ALIVE;
        }
        catch (Exception exception) {
            this.dispose();
            LOG.error((Object)(this.name + "Cache: Could not create disk store. Initial cause was " + exception.getMessage()), (Throwable)exception);
        }
    }

    private void initialiseFiles() throws Exception {
        File file = new File(this.diskPath);
        if (file.exists() && !file.isDirectory()) {
            throw new Exception("Store directory \"" + file.getCanonicalPath() + "\" exists and is not a directory.");
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new Exception("Could not create cache directory \"" + file.getCanonicalPath() + "\".");
        }
        this.dataFile = new File(file, this.getDataFileName());
        this.indexFile = new File(file, this.getIndexFileName());
        this.deleteIndexIfNoData();
        if (this.persistent) {
            if (this.diskPath.indexOf(AUTO_DISK_PATH_DIRECTORY_PREFIX) != -1) {
                LOG.warn((Object)("Data in persistent disk stores is ignored for stores from automatically created directories (they start with ehcache_auto_created).\nRemove diskPersistent or resolve the conflicting disk paths in cache configuration.\nDeleting data file " + this.getDataFileName()));
                this.dataFile.delete();
            } else if (!this.readIndex()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Index file dirty or empty. Deleting data file " + this.getDataFileName()));
                }
                this.dataFile.delete();
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting data file " + this.getDataFileName()));
            }
            this.dataFile.delete();
            this.indexFile = null;
        }
        this.randomAccessFile = new RandomAccessFile(this.dataFile, "rw");
    }

    private void deleteIndexIfNoData() {
        boolean bl = this.dataFile.exists();
        boolean bl2 = this.indexFile.exists();
        if (!bl && bl2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Matching data file missing for index file. Deleting index file " + this.getIndexFileName()));
            }
            this.indexFile.delete();
        }
    }

    private void checkActive() throws CacheException {
        if (!this.active) {
            throw new CacheException(this.name + " Cache: The Disk store is not active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element get(Object object) {
        try {
            Element element;
            this.checkActive();
            Object object2 = this.spoolLock;
            synchronized (object2) {
                element = (Element)this.spool.remove(object);
            }
            if (element != null) {
                element.updateAccessStatistics();
                return element;
            }
            object2 = (DiskElement)this.diskElements.get(object);
            if (object2 == null) {
                return null;
            }
            element = this.loadElementFromDiskElement((DiskElement)object2);
            element.updateAccessStatistics();
            return element;
        }
        catch (Exception exception) {
            LOG.error((Object)(this.name + "Cache: Could not read disk store element for key " + object + ". Error was " + exception.getMessage()), (Throwable)exception);
            return null;
        }
    }

    public final boolean containsKey(Object object) {
        return this.diskElements.containsKey(object) || this.spool.containsKey(object);
    }

    private Element loadElementFromDiskElement(DiskElement diskElement) throws IOException, ClassNotFoundException {
        this.randomAccessFile.seek(diskElement.position);
        byte[] byArray = new byte[diskElement.payloadSize];
        this.randomAccessFile.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream){

            protected Class resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(objectStreamClass.getName(), false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return super.resolveClass(objectStreamClass);
                }
            }
        };
        Element element = (Element)objectInputStream.readObject();
        objectInputStream.close();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element getQuiet(Object object) {
        try {
            Element element;
            this.checkActive();
            Object object2 = this.spoolLock;
            synchronized (object2) {
                element = (Element)this.spool.remove(object);
            }
            if (element != null) {
                return element;
            }
            object2 = (DiskElement)this.diskElements.get(object);
            if (object2 == null) {
                return null;
            }
            element = this.loadElementFromDiskElement((DiskElement)object2);
            return element;
        }
        catch (Exception exception) {
            LOG.error((Object)(this.name + "Cache: Could not read disk store element for key " + object + ". Initial cause was " + exception.getMessage()), (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object[] getKeyArray() {
        Set set;
        Object object = this.diskElements;
        synchronized (object) {
            set = this.diskElements.keySet();
        }
        HashSet hashSet = this.spoolLock;
        synchronized (hashSet) {
            object = this.spool.keySet();
        }
        hashSet = new HashSet(set.size() + object.size());
        hashSet.addAll(set);
        hashSet.addAll(object);
        return hashSet.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int getSize() {
        try {
            int n;
            int n2;
            this.checkActive();
            Object object = this.spoolLock;
            synchronized (object) {
                n2 = this.spool.size();
            }
            Map map = this.diskElements;
            synchronized (map) {
                n = this.diskElements.size();
            }
            return n2 + n;
        }
        catch (Exception exception) {
            LOG.error((Object)(this.name + "Cache: Could not determine size of disk store.. Initial cause was " + exception.getMessage()), (Throwable)exception);
            return 0;
        }
    }

    public final Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Element element) {
        block9: {
            try {
                this.checkActive();
                if (this.spoolAndExpiryThread.isAlive()) {
                    Object object = this.spoolLock;
                    synchronized (object) {
                        this.spool.put(element.getObjectKey(), element);
                        break block9;
                    }
                }
                LOG.error((Object)(this.name + "Cache: Elements cannot be written to disk store because the" + " spool thread has died."));
                Object object = this.spoolLock;
                synchronized (object) {
                    this.spool.clear();
                }
            }
            catch (Exception exception) {
                LOG.error((Object)(this.name + "Cache: Could not write disk store element for " + element.getObjectKey() + ". Initial cause was " + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Element remove(Object object) {
        Element element;
        try {
            this.checkActive();
            Object object2 = this.spoolLock;
            synchronized (object2) {
                element = (Element)this.spool.remove(object);
            }
            object2 = this.diskElements;
            synchronized (object2) {
                DiskElement diskElement = (DiskElement)this.diskElements.remove(object);
                if (diskElement != null) {
                    element = this.loadElementFromDiskElement(diskElement);
                    this.freeBlock(diskElement);
                }
            }
        }
        catch (Exception exception) {
            String string = this.name + "Cache: Could not remove disk store entry for " + object + ". Error was " + exception.getMessage();
            LOG.error((Object)string, (Throwable)exception);
            throw new CacheException(string);
        }
        return element;
    }

    private void freeBlock(DiskElement diskElement) {
        this.totalSize -= (long)diskElement.payloadSize;
        diskElement.payloadSize = 0;
        diskElement.key = null;
        diskElement.hitcount = 0L;
        diskElement.expiryTime = 0L;
        this.freeSpace.add(diskElement);
    }

    public final synchronized void removeAll() {
        try {
            this.checkActive();
            this.spool = Collections.synchronizedMap(new HashMap());
            this.diskElements = Collections.synchronizedMap(new HashMap());
            this.freeSpace = Collections.synchronizedList(new ArrayList());
            this.totalSize = 0L;
            this.randomAccessFile.setLength(0L);
            if (this.persistent) {
                this.indexFile.delete();
                this.indexFile.createNewFile();
            }
        }
        catch (Exception exception) {
            LOG.error((Object)(this.name + " Cache: Could not rebuild disk store. Initial cause was " + exception.getMessage()), (Throwable)exception);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        if (!this.active) {
            return;
        }
        try {
            this.flush();
            if (this.spoolAndExpiryThread != null) {
                this.spoolAndExpiryThread.interrupt();
            }
            this.spool.clear();
            this.diskElements.clear();
            this.freeSpace.clear();
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
            if (!this.persistent) {
                LOG.debug((Object)("Deleting file " + this.dataFile.getName()));
                this.dataFile.delete();
            }
        }
        catch (Exception exception) {
            LOG.error((Object)(this.name + "Cache: Could not shut down disk cache. Initial cause was " + exception.getMessage()), (Throwable)exception);
        }
        finally {
            this.active = false;
            this.randomAccessFile = null;
            this.notifyAll();
            this.cache = null;
        }
    }

    public final void flush() throws IOException {
        if (this.persistent) {
            this.flushSpool();
            this.writeIndex();
        }
    }

    public final synchronized boolean isSpoolEmpty() {
        return !this.active || this.spool.size() == 0;
    }

    private void spoolAndExpiryThreadMain() {
        long l = System.currentTimeMillis();
        while (true) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                LOG.debug((Object)"Spool Thread interrupted.");
                return;
            }
            if (!this.active) {
                return;
            }
            this.throwableSafeFlushSpoolIfRequired();
            if (!this.active) {
                return;
            }
            l = this.throwableSafeExpireElementsIfRequired(l);
        }
    }

    private long throwableSafeExpireElementsIfRequired(long l) {
        long l2 = l;
        if (!this.eternal && System.currentTimeMillis() > l) {
            try {
                l2 += this.expiryThreadInterval * 1000L;
                this.expireElements();
            }
            catch (Throwable throwable) {
                LOG.error((Object)(this.name + " Cache: Could not expire elements from disk due to " + throwable.getMessage() + ". Continuing..."), throwable);
            }
        }
        return l2;
    }

    private void throwableSafeFlushSpoolIfRequired() {
        if (this.spool != null && this.spool.size() != 0) {
            try {
                this.flushSpool();
            }
            catch (Throwable throwable) {
                LOG.error((Object)(this.name + " Cache: Could not flush elements to disk due to " + throwable.getMessage() + ". Continuing..."), throwable);
            }
        }
    }

    private synchronized void flushSpool() throws IOException {
        if (this.spool.size() == 0) {
            return;
        }
        Map map = this.swapSpoolReference();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            this.writeOrReplaceEntry(iterator.next());
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map swapSpoolReference() {
        Map map = null;
        Object object = this.spoolLock;
        synchronized (object) {
            map = this.spool;
            this.spool = Collections.synchronizedMap(new HashMap());
        }
        return map;
    }

    private void writeOrReplaceEntry(Object object) throws IOException {
        Element element = (Element)object;
        if (element == null) {
            return;
        }
        Serializable serializable = (Serializable)element.getObjectKey();
        this.removeOldEntryIfAny(serializable);
        if (this.maxElementsOnDisk > 0L && (long)this.diskElements.size() >= this.maxElementsOnDisk) {
            this.evictLfuDiskElement();
        }
        this.writeElement(element, serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeElement(Element element, Serializable serializable) throws IOException {
        try {
            long l = element.getExpirationTime();
            MemoryEfficientByteArrayOutputStream memoryEfficientByteArrayOutputStream = null;
            try {
                memoryEfficientByteArrayOutputStream = this.serializeEntry(element);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LOG.error((Object)("OutOfMemoryError on serialize: " + serializable));
            }
            int n = memoryEfficientByteArrayOutputStream.size();
            DiskElement diskElement = this.checkForFreeBlock(n);
            this.randomAccessFile.seek(diskElement.position);
            this.randomAccessFile.write(memoryEfficientByteArrayOutputStream.toByteArray(), 0, n);
            memoryEfficientByteArrayOutputStream = null;
            diskElement.payloadSize = n;
            diskElement.key = serializable;
            diskElement.expiryTime = l;
            diskElement.hitcount = element.getHitCount();
            this.totalSize += (long)n;
            Map map = this.diskElements;
            synchronized (map) {
                this.diskElements.put(serializable, diskElement);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)(this.name + "Cache: Failed to write element to disk '" + serializable + "'. Initial cause was " + exception.getMessage()), (Throwable)exception);
        }
    }

    private MemoryEfficientByteArrayOutputStream serializeEntry(Element element) throws IOException {
        MemoryEfficientByteArrayOutputStream memoryEfficientByteArrayOutputStream = new MemoryEfficientByteArrayOutputStream(this.estimatedPayloadSize());
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(memoryEfficientByteArrayOutputStream);
        objectOutputStream.writeObject(element);
        objectOutputStream.close();
        return memoryEfficientByteArrayOutputStream;
    }

    private int estimatedPayloadSize() {
        int n = 0;
        try {
            n = (int)(this.totalSize / (long)this.diskElements.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n <= 0) {
            n = 512;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldEntryIfAny(Serializable serializable) {
        DiskElement diskElement;
        Map map = this.diskElements;
        synchronized (map) {
            diskElement = (DiskElement)this.diskElements.remove(serializable);
        }
        if (diskElement != null) {
            this.freeBlock(diskElement);
        }
    }

    private DiskElement checkForFreeBlock(int n) throws IOException {
        DiskElement diskElement = this.findFreeBlock(n);
        if (diskElement == null) {
            diskElement = new DiskElement();
            diskElement.position = this.randomAccessFile.length();
            diskElement.blockSize = n;
        }
        return diskElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeIndex() throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.indexFile);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.diskElements);
            objectOutputStream.writeObject(this.freeSpace);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized boolean readIndex() throws IOException {
        ObjectInputStream objectInputStream = null;
        FileInputStream fileInputStream = null;
        boolean bl = false;
        if (this.indexFile.exists()) {
            try {
                fileInputStream = new FileInputStream(this.indexFile);
                objectInputStream = new ObjectInputStream(fileInputStream);
                this.diskElements = (Map)objectInputStream.readObject();
                this.freeSpace = (List)objectInputStream.readObject();
                bl = true;
                return bl;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                LOG.error((Object)"Corrupt index file. Creating new index.");
                return bl;
            }
            catch (IOException iOException) {
                if (!LOG.isDebugEnabled()) return bl;
                LOG.debug((Object)"IOException reading index. Creating new index. ");
                return bl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.error((Object)("Class loading problem reading index. Creating new index. Initial cause was " + classNotFoundException.getMessage()), (Throwable)classNotFoundException);
                return bl;
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    } else if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    LOG.error((Object)"Problem closing the index file.");
                }
                this.createNewIndexFile();
            }
        }
        this.createNewIndexFile();
        return bl;
    }

    private void createNewIndexFile() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Index file " + this.indexFile + " deleted."));
            }
        }
        if (this.indexFile.createNewFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Index file " + this.indexFile + " created successfully"));
            }
        } else {
            throw new IOException("Index file " + this.indexFile + " could not created.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireElements() {
        Object object;
        Object object2;
        long l = System.currentTimeMillis();
        Object object3 = this.spoolLock;
        synchronized (object3) {
            object2 = this.spool.values().iterator();
            while (object2.hasNext()) {
                object = (Element)object2.next();
                if (!((Element)object).isExpired()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + "Cache: Removing expired spool element " + ((Element)object).getObjectKey()));
                }
                object2.remove();
                this.notifyExpiryListeners((Element)object);
            }
        }
        object3 = null;
        object2 = this.cache.getCacheEventNotificationService();
        object = this.diskElements;
        synchronized (object) {
            Iterator iterator = this.diskElements.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                DiskElement diskElement = (DiskElement)entry.getValue();
                if (l < diskElement.expiryTime) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + "Cache: Removing expired spool element " + entry.getKey() + " from Disk Store"));
                }
                iterator.remove();
                if (((RegisteredEventListeners)object2).hasCacheEventListeners()) {
                    try {
                        object3 = this.loadElementFromDiskElement(diskElement);
                        this.notifyExpiryListeners((Element)object3);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)(this.name + "Cache: Could not remove disk store entry for " + entry.getKey() + ". Error was " + exception.getMessage()), (Throwable)exception);
                    }
                }
                this.freeBlock(diskElement);
            }
        }
    }

    private void notifyExpiryListeners(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    private DiskElement findFreeBlock(int n) {
        for (int i = 0; i < this.freeSpace.size(); ++i) {
            DiskElement diskElement = (DiskElement)this.freeSpace.get(i);
            if (diskElement.blockSize < n) continue;
            this.freeSpace.remove(i);
            return diskElement;
        }
        return null;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ dataFile = ").append(this.dataFile.getAbsolutePath()).append(", active=").append(this.active).append(", totalSize=").append(this.totalSize).append(", status=").append(this.status).append(", expiryThreadInterval = ").append(this.expiryThreadInterval).append(" ]");
        return stringBuffer.toString();
    }

    public static String generateUniqueDirectory() {
        return "ehcache_auto_created_" + System.currentTimeMillis();
    }

    public final long getTotalFileSize() {
        return this.getDataFileSize() + this.getIndexFileSize();
    }

    public final long getDataFileSize() {
        return this.dataFile.length();
    }

    public final float calculateDataFileSparseness() {
        return 1.0f - (float)this.getUsedDataSize() / (float)this.getDataFileSize();
    }

    public final long getUsedDataSize() {
        return this.totalSize;
    }

    public final long getIndexFileSize() {
        if (this.indexFile == null) {
            return 0L;
        }
        return this.indexFile.length();
    }

    public final String getDataFileName() {
        return this.name + ".data";
    }

    public final String getDataFilePath() {
        return this.diskPath;
    }

    public final String getIndexFileName() {
        return this.name + ".index";
    }

    public final boolean isSpoolThreadAlive() {
        if (this.spoolAndExpiryThread == null) {
            return false;
        }
        return this.spoolAndExpiryThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictLfuDiskElement() {
        Map map = this.diskElements;
        synchronized (map) {
            DiskElement diskElement = this.findRelativelyUnused();
            this.diskElements.remove(diskElement.key);
            this.notifyEvictionListeners(diskElement);
            this.freeBlock(diskElement);
        }
    }

    private DiskElement findRelativelyUnused() {
        LfuPolicy.Metadata[] metadataArray = this.sampleElements(this.diskElements);
        LfuPolicy.Metadata metadata = LfuPolicy.leastHit(metadataArray, null);
        return (DiskElement)metadata;
    }

    private LfuPolicy.Metadata[] sampleElements(Map map) {
        int[] nArray = LfuPolicy.generateRandomSample(map.size());
        LfuPolicy.Metadata[] metadataArray = new DiskElement[nArray.length];
        Iterator iterator = map.values().iterator();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i]; ++j) {
                iterator.next();
            }
            metadataArray[i] = (DiskElement)iterator.next();
        }
        return metadataArray;
    }

    private void notifyEvictionListeners(DiskElement diskElement) {
        RegisteredEventListeners registeredEventListeners = this.cache.getCacheEventNotificationService();
        if (registeredEventListeners.hasCacheEventListeners()) {
            Element element = null;
            try {
                element = this.loadElementFromDiskElement(diskElement);
                this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
            }
            catch (Exception exception) {
                LOG.error((Object)(this.name + "Cache: Could not notify disk store eviction of " + element.getObjectKey() + ". Error was " + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    private static final class DiskElement
    implements Serializable,
    LfuPolicy.Metadata {
        private static final long serialVersionUID = -717310932566592289L;
        private long position;
        private int payloadSize;
        private int blockSize;
        private Object key;
        private long expiryTime;
        private long hitcount;

        private DiskElement() {
        }

        public Object getKey() {
            return this.key;
        }

        public long getHitCount() {
            return this.hitcount;
        }
    }

    class MemoryEfficientByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MemoryEfficientByteArrayOutputStream(int n) {
            super(n);
        }

        public synchronized byte[] getBytes() {
            return this.buf;
        }
    }

    private final class SpoolAndExpiryThread
    extends Thread {
        public SpoolAndExpiryThread() {
            super("Store " + DiskStore.this.name + " Spool Thread");
            this.setDaemon(true);
            this.setPriority(2);
        }

        public final void run() {
            DiskStore.this.spoolAndExpiryThreadMain();
        }
    }
}

