/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.EhCache;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.Timestamper;

public final class SingletonEhCacheProvider
implements CacheProvider {
    public static final String NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME = "net.sf.ehcache.configurationResourceName";
    private static final Log LOG = LogFactory.getLog((Class)SingletonEhCacheProvider.class);
    private static int referenceCount;
    private CacheManager manager;

    public final Cache buildCache(String string, Properties properties) throws org.hibernate.cache.CacheException {
        try {
            Ehcache ehcache = this.manager.getEhcache(string);
            if (ehcache == null) {
                LOG.warn((Object)("Could not find a specific ehcache configuration for cache named [" + string + "]; using defaults."));
                this.manager.addCache(string);
                ehcache = this.manager.getEhcache(string);
                LOG.debug((Object)("started EHCache region: " + string));
            }
            return new EhCache(ehcache);
        }
        catch (CacheException cacheException) {
            throw new org.hibernate.cache.CacheException((Exception)cacheException);
        }
    }

    public final long nextTimestamp() {
        return Timestamper.next();
    }

    public final void start(Properties properties) throws org.hibernate.cache.CacheException {
        String string = null;
        if (properties != null) {
            string = (String)properties.get(NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME);
        }
        if (string == null || string.length() == 0) {
            this.manager = CacheManager.create();
            ++referenceCount;
        } else {
            if (!string.startsWith("/")) {
                string = "/" + string;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("prepending / to " + string + ". It should be placed in the root" + "of the classpath rather than in a package."));
                }
            }
            URL uRL = this.loadResource(string);
            this.manager = CacheManager.create(uRL);
            ++referenceCount;
        }
    }

    private URL loadResource(String string) {
        ClassLoader classLoader = ClassLoaderUtil.getStandardClassLoader();
        URL uRL = null;
        if (classLoader != null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = this.getClass().getResource(string);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating EhCacheProvider from a specified resource: " + string + " Resolved to URL: " + uRL));
        }
        return uRL;
    }

    public void stop() {
        if (this.manager != null) {
            if (--referenceCount == 0) {
                this.manager.shutdown();
            }
            this.manager = null;
        }
    }

    public final boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

