/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.Timestamper;

public final class EhCache
implements Cache {
    private static final Log LOG = LogFactory.getLog((Class)EhCache.class);
    private static final int SIXTY_THOUSAND_MS = 60000;
    private final Ehcache cache;

    public EhCache(Ehcache ehcache) {
        this.cache = ehcache;
    }

    public final Object get(Object object) throws org.hibernate.cache.CacheException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("key: " + object));
            }
            if (object == null) {
                return null;
            }
            Element element = this.cache.get(object);
            if (element == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Element for " + object + " is null"));
                }
                return null;
            }
            return element.getObjectValue();
        }
        catch (CacheException cacheException) {
            throw new org.hibernate.cache.CacheException((Exception)cacheException);
        }
    }

    public final Object read(Object object) throws org.hibernate.cache.CacheException {
        return this.get(object);
    }

    public final void update(Object object, Object object2) throws org.hibernate.cache.CacheException {
        this.put(object, object2);
    }

    public final void put(Object object, Object object2) throws org.hibernate.cache.CacheException {
        try {
            Element element = new Element(object, object2);
            this.cache.put(element);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new org.hibernate.cache.CacheException((Exception)illegalArgumentException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new org.hibernate.cache.CacheException((Exception)illegalStateException);
        }
    }

    public final void remove(Object object) throws org.hibernate.cache.CacheException {
        try {
            this.cache.remove(object);
        }
        catch (ClassCastException classCastException) {
            throw new org.hibernate.cache.CacheException((Exception)classCastException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new org.hibernate.cache.CacheException((Exception)illegalStateException);
        }
    }

    public final void clear() throws org.hibernate.cache.CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException illegalStateException) {
            throw new org.hibernate.cache.CacheException((Exception)illegalStateException);
        }
    }

    public final void destroy() throws org.hibernate.cache.CacheException {
        try {
            this.cache.getCacheManager().removeCache(this.cache.getName());
        }
        catch (IllegalStateException illegalStateException) {
            throw new org.hibernate.cache.CacheException((Exception)illegalStateException);
        }
        catch (CacheException cacheException) {
            throw new org.hibernate.cache.CacheException((Exception)cacheException);
        }
    }

    public final void lock(Object object) throws org.hibernate.cache.CacheException {
    }

    public final void unlock(Object object) throws org.hibernate.cache.CacheException {
    }

    public final long nextTimestamp() {
        return Timestamper.next();
    }

    public final int getTimeout() {
        return 245760000;
    }

    public final String getRegionName() {
        return this.cache.getName();
    }

    public final long getSizeInMemory() {
        try {
            return this.cache.calculateInMemorySize();
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public final long getElementCountInMemory() {
        try {
            return this.cache.getMemoryStoreSize();
        }
        catch (CacheException cacheException) {
            throw new org.hibernate.cache.CacheException((Exception)cacheException);
        }
    }

    public final long getElementCountOnDisk() {
        return this.cache.getDiskStoreSize();
    }

    public final Map toMap() {
        try {
            HashMap hashMap = new HashMap();
            Iterator iterator = this.cache.getKeys().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                hashMap.put(e, this.cache.get(e).getObjectValue());
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new org.hibernate.cache.CacheException(exception);
        }
    }

    public final String toString() {
        return "EHCache(" + this.getRegionName() + ')';
    }

    final Ehcache getBackingCache() {
        return this.cache;
    }
}

