/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.RemoteCacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMISynchronousCacheReplicator
implements CacheReplicator {
    private static final Log LOG = LogFactory.getLog((String)RMISynchronousCacheReplicator.class.getName());
    protected Status status;
    protected final boolean replicatePuts;
    protected final boolean replicateUpdates;
    protected final boolean replicateUpdatesViaCopy;
    protected final boolean replicateRemovals;

    public RMISynchronousCacheReplicator(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.replicatePuts = bl;
        this.replicateUpdates = bl2;
        this.replicateUpdatesViaCopy = bl3;
        this.replicateRemovals = bl4;
        this.status = Status.STATUS_ALIVE;
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicatePuts) {
            return;
        }
        if (!element.isSerializable()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Object with key " + element.getObjectKey() + " is not Serializable and cannot be replicated"));
            }
            return;
        }
        RMISynchronousCacheReplicator.replicatePutNotification(ehcache, element);
    }

    private static void replicatePutNotification(Ehcache ehcache, Element element) throws RemoteCacheException {
        List list = RMISynchronousCacheReplicator.listRemoteCachePeers(ehcache);
        for (int i = 0; i < list.size(); ++i) {
            CachePeer cachePeer = (CachePeer)list.get(i);
            try {
                cachePeer.put(element);
                continue;
            }
            catch (Throwable throwable) {
                throw new RemoteCacheException("Error doing put to remote peer. Message was: " + throwable.getMessage());
            }
        }
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            if (!element.isSerializable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Object with key " + element.getObjectKey() + " is not Serializable and cannot be updated via copy"));
                }
                return;
            }
            RMISynchronousCacheReplicator.replicatePutNotification(ehcache, element);
        } else {
            if (!element.isKeySerializable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated."));
                }
                return;
            }
            RMISynchronousCacheReplicator.replicateRemovalNotification(ehcache, (Serializable)element.getObjectKey());
        }
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        if (!element.isKeySerializable()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated."));
            }
            return;
        }
        RMISynchronousCacheReplicator.replicateRemovalNotification(ehcache, (Serializable)element.getObjectKey());
    }

    private static void replicateRemovalNotification(Ehcache ehcache, Serializable serializable) throws RemoteCacheException {
        List list = RMISynchronousCacheReplicator.listRemoteCachePeers(ehcache);
        for (int i = 0; i < list.size(); ++i) {
            CachePeer cachePeer = (CachePeer)list.get(i);
            try {
                cachePeer.remove(serializable);
                continue;
            }
            catch (Throwable throwable) {
                throw new RemoteCacheException("Error doing remove to remote peer. Message was: " + throwable.getMessage());
            }
        }
    }

    public final void notifyElementExpired(Ehcache ehcache, Element element) {
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
    }

    public void notifyRemoveAll(Ehcache ehcache) {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        this.replicateRemoveAllNotification(ehcache);
    }

    private void replicateRemoveAllNotification(Ehcache ehcache) {
        List list = RMISynchronousCacheReplicator.listRemoteCachePeers(ehcache);
        for (int i = 0; i < list.size(); ++i) {
            CachePeer cachePeer = (CachePeer)list.get(i);
            try {
                cachePeer.removeAll();
                continue;
            }
            catch (Throwable throwable) {
                throw new RemoteCacheException("Error doing removeAll to remote peer. Message was: " + throwable.getMessage());
            }
        }
    }

    static List listRemoteCachePeers(Ehcache ehcache) {
        CacheManagerPeerProvider cacheManagerPeerProvider = ehcache.getCacheManager().getCachePeerProvider();
        return cacheManagerPeerProvider.listRemoteCachePeers(ehcache);
    }

    public final boolean isReplicateUpdatesViaCopy() {
        return this.replicateUpdatesViaCopy;
    }

    public final boolean notAlive() {
        return !this.alive();
    }

    public final boolean alive() {
        if (this.status == null) {
            return false;
        }
        return this.status.equals(Status.STATUS_ALIVE);
    }

    public void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new RMISynchronousCacheReplicator(this.replicatePuts, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals);
    }
}

