/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.util.Properties;
import net.sf.ehcache.distribution.RMIAsynchronousCacheReplicator;
import net.sf.ehcache.distribution.RMISynchronousCacheReplicator;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMICacheReplicatorFactory
extends CacheEventListenerFactory {
    protected static final int DEFAULT_ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS = 1000;
    private static final Log LOG = LogFactory.getLog((String)RMICacheReplicatorFactory.class.getName());
    private static final String REPLICATE_PUTS = "replicatePuts";
    private static final String REPLICATE_UPDATES = "replicateUpdates";
    private static final String REPLICATE_UPDATES_VIA_COPY = "replicateUpdatesViaCopy";
    private static final String REPLICATE_REMOVALS = "replicateRemovals";
    private static final String REPLICATE_ASYNCHRONOUSLY = "replicateAsynchronously";
    private static final String ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS = "asynchronousReplicationIntervalMillis";
    private static final int MINIMUM_REASONABLE_INTERVAL = 10;

    public final CacheEventListener createCacheEventListener(Properties properties) {
        boolean bl = this.extractReplicatePuts(properties);
        boolean bl2 = this.extractReplicateUpdates(properties);
        boolean bl3 = this.extractReplicateUpdatesViaCopy(properties);
        boolean bl4 = this.extractReplicateRemovals(properties);
        boolean bl5 = this.extractReplicateAsynchronously(properties);
        int n = this.extractReplicationIntervalMilis(properties);
        if (bl5) {
            return new RMIAsynchronousCacheReplicator(bl, bl2, bl3, bl4, n);
        }
        return new RMISynchronousCacheReplicator(bl, bl2, bl3, bl4);
    }

    protected int extractReplicationIntervalMilis(Properties properties) {
        int n;
        block5: {
            String string = PropertyUtil.extractAndLogProperty(ASYNCHRONOUS_REPLICATION_INTERVAL_MILLIS, properties);
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 < 10) {
                        LOG.warn((Object)"Trying to set the asynchronousReplicationIntervalMillis to an unreasonable number. Using the default instead.");
                        n = 1000;
                        break block5;
                    }
                    n = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.warn((Object)("Number format exception trying to set asynchronousReplicationIntervalMillis. Using the default instead. String value was: '" + string + "'"));
                    n = 1000;
                }
            } else {
                n = 1000;
            }
        }
        return n;
    }

    protected boolean extractReplicateAsynchronously(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(REPLICATE_ASYNCHRONOUSLY, properties);
        boolean bl = string != null ? PropertyUtil.parseBoolean(string) : true;
        return bl;
    }

    protected boolean extractReplicateRemovals(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(REPLICATE_REMOVALS, properties);
        boolean bl = string != null ? PropertyUtil.parseBoolean(string) : true;
        return bl;
    }

    protected boolean extractReplicateUpdatesViaCopy(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(REPLICATE_UPDATES_VIA_COPY, properties);
        boolean bl = string != null ? PropertyUtil.parseBoolean(string) : true;
        return bl;
    }

    protected boolean extractReplicateUpdates(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(REPLICATE_UPDATES, properties);
        boolean bl = string != null ? PropertyUtil.parseBoolean(string) : true;
        return bl;
    }

    protected boolean extractReplicatePuts(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(REPLICATE_PUTS, properties);
        boolean bl = string != null ? PropertyUtil.parseBoolean(string) : true;
        return bl;
    }
}

