/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.ConfigurableRMIClientSocketFactory;
import net.sf.ehcache.distribution.EventMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMICachePeer
extends UnicastRemoteObject
implements CachePeer,
Remote {
    private static final Log LOG = LogFactory.getLog((String)RMICachePeer.class.getName());
    private final String hostname;
    private final Integer port;
    private final Ehcache cache;

    public RMICachePeer(Ehcache ehcache, String string, Integer n, Integer n2) throws RemoteException {
        super(0, new ConfigurableRMIClientSocketFactory(n2), RMISocketFactory.getDefaultSocketFactory());
        this.hostname = string;
        this.port = n;
        this.cache = ehcache;
    }

    public final String getUrl() {
        return "//" + this.hostname + ":" + this.port + "/" + this.cache.getName();
    }

    public final String getUrlBase() {
        return "//" + this.hostname + ":" + this.port;
    }

    public List getKeys() throws RemoteException {
        return this.cache.getKeys();
    }

    public Element getQuiet(Serializable serializable) throws RemoteException {
        return this.cache.getQuiet(serializable);
    }

    public List getElements(List list) throws RemoteException {
        if (list == null) {
            return new ArrayList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < list.size(); ++i) {
            Serializable serializable = (Serializable)list.get(i);
            Element element = this.cache.getQuiet(serializable);
            arrayList.add(element);
        }
        return arrayList;
    }

    public void put(Element element) throws RemoteException, IllegalArgumentException, IllegalStateException {
        this.cache.put(element, true);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Remote put received. Element is: " + element));
        }
    }

    public final boolean remove(Serializable serializable) throws RemoteException, IllegalStateException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Remote remove received for key: " + serializable));
        }
        return this.cache.remove(serializable, true);
    }

    public final void removeAll() throws RemoteException, IllegalStateException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Remote removeAll received");
        }
        this.cache.removeAll(true);
    }

    public final void send(List list) throws RemoteException {
        for (int i = 0; i < list.size(); ++i) {
            EventMessage eventMessage = (EventMessage)list.get(i);
            if (eventMessage.getEvent() == 0) {
                this.put(eventMessage.getElement());
                continue;
            }
            if (eventMessage.getEvent() == 1) {
                this.remove(eventMessage.getSerializableKey());
                continue;
            }
            if (eventMessage.getEvent() == 3) {
                this.removeAll();
                continue;
            }
            LOG.error((Object)("Unknown event: " + eventMessage));
        }
    }

    public final String getName() throws RemoteException {
        return this.cache.getName();
    }

    public final String getGuid() throws RemoteException {
        return this.cache.getGuid();
    }

    final Ehcache getBoundCacheInstance() {
        return this.cache;
    }

    public String toString() {
        return this.getUrl();
    }
}

