/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.distribution.ManualRMICacheManagerPeerProvider;
import net.sf.ehcache.distribution.MulticastRMICacheManagerPeerProvider;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMICacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static final Log LOG = LogFactory.getLog((String)RMICacheManagerPeerProviderFactory.class.getName());
    private static final String PEER_DISCOVERY = "peerDiscovery";
    private static final String AUTOMATIC_PEER_DISCOVERY = "automatic";
    private static final String MANUALLY_CONFIGURED_PEER_DISCOVERY = "manual";
    private static final String RMI_URLS = "rmiUrls";
    private static final String MULTICAST_GROUP_PORT = "multicastGroupPort";
    private static final String MULTICAST_GROUP_ADDRESS = "multicastGroupAddress";
    private static final String MULTICAST_PACKET_TTL = "timeToLive";
    private static final int MAXIMUM_TTL = 255;

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) throws CacheException {
        String string = PropertyUtil.extractAndLogProperty(PEER_DISCOVERY, properties);
        if (string == null || string.equalsIgnoreCase(AUTOMATIC_PEER_DISCOVERY)) {
            try {
                return this.createAutomaticallyConfiguredCachePeerProvider(cacheManager, properties);
            }
            catch (IOException iOException) {
                throw new CacheException("Could not create CacheManagerPeerProvider. Initial cause was " + iOException.getMessage(), iOException);
            }
        }
        if (string.equalsIgnoreCase(MANUALLY_CONFIGURED_PEER_DISCOVERY)) {
            return this.createManuallyConfiguredCachePeerProvider(properties);
        }
        return null;
    }

    protected CacheManagerPeerProvider createManuallyConfiguredCachePeerProvider(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(RMI_URLS, properties);
        if (string == null || string.length() == 0) {
            LOG.info((Object)"Starting manual peer provider with empty list of peers. No replication will occur unless peers are added.");
            string = new String();
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        ManualRMICacheManagerPeerProvider manualRMICacheManagerPeerProvider = new ManualRMICacheManagerPeerProvider();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            ((RMICacheManagerPeerProvider)manualRMICacheManagerPeerProvider).registerPeer(string2);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Registering peer " + string2));
        }
        return manualRMICacheManagerPeerProvider;
    }

    protected CacheManagerPeerProvider createAutomaticallyConfiguredCachePeerProvider(CacheManager cacheManager, Properties properties) throws IOException {
        Integer n;
        String string = PropertyUtil.extractAndLogProperty(MULTICAST_GROUP_ADDRESS, properties);
        InetAddress inetAddress = InetAddress.getByName(string);
        String string2 = PropertyUtil.extractAndLogProperty(MULTICAST_GROUP_PORT, properties);
        Integer n2 = new Integer(string2);
        String string3 = PropertyUtil.extractAndLogProperty(MULTICAST_PACKET_TTL, properties);
        if (string3 == null) {
            n = new Integer(1);
            LOG.debug((Object)"No TTL set. Setting it to the default of 1, which means packets are limited to the same subnet.");
        } else {
            n = new Integer(string3);
            if (n < 0 || n > 255) {
                throw new CacheException("The TTL must be set to a value between 0 and 255");
            }
        }
        return new MulticastRMICacheManagerPeerProvider(cacheManager, inetAddress, n2, n);
    }
}

