/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.net.UnknownHostException;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.RMICacheManagerPeerListener;
import net.sf.ehcache.util.PropertyUtil;

public class RMICacheManagerPeerListenerFactory
extends CacheManagerPeerListenerFactory {
    public static final Integer DEFAULT_SOCKET_TIMEOUT_MILLIS = new Integer(120000);
    private static final String HOSTNAME = "hostName";
    private static final String PORT = "port";
    private static final String SOCKET_TIMEOUT_MILLIS = "socketTimeoutMillis";

    public final CacheManagerPeerListener createCachePeerListener(CacheManager cacheManager, Properties properties) throws CacheException {
        String string = PropertyUtil.extractAndLogProperty(HOSTNAME, properties);
        String string2 = PropertyUtil.extractAndLogProperty(PORT, properties);
        Integer n = null;
        n = string2 != null && string2.length() != 0 ? new Integer(string2) : new Integer(0);
        String string3 = PropertyUtil.extractAndLogProperty(SOCKET_TIMEOUT_MILLIS, properties);
        Integer n2 = string3 == null || string3.length() == 0 ? DEFAULT_SOCKET_TIMEOUT_MILLIS : new Integer(string3);
        return this.doCreateCachePeerListener(string, n, cacheManager, n2);
    }

    protected CacheManagerPeerListener doCreateCachePeerListener(String string, Integer n, CacheManager cacheManager, Integer n2) {
        try {
            return new RMICacheManagerPeerListener(string, n, cacheManager, n2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new CacheException("Unable to create CacheManagerPeerListener. Initial cause was " + unknownHostException.getMessage(), unknownHostException);
        }
    }
}

