/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.RMICachePeer;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMICacheManagerPeerListener
implements CacheManagerPeerListener {
    private static final Log LOG = LogFactory.getLog((String)RMICacheManagerPeerListener.class.getName());
    private static final int MINIMUM_SENSIBLE_TIMEOUT = 200;
    private static final int NAMING_UNBIND_RETRY_INTERVAL = 400;
    private static final int NAMING_UNBIND_MAX_RETRIES = 10;
    protected final Map cachePeers = new HashMap();
    protected Status status = Status.STATUS_UNINITIALISED;
    protected Integer port;
    private Registry registry;
    private final String hostName;
    private CacheManager cacheManager;
    private Integer socketTimeoutMillis;

    public RMICacheManagerPeerListener(String string, Integer n, CacheManager cacheManager, Integer n2) throws UnknownHostException {
        if (string != null && string.length() != 0) {
            this.hostName = string;
            if (string.equals("localhost")) {
                LOG.warn((Object)"Explicitly setting the listener hostname to 'localhost' is not recommended. It will only work if all CacheManager peers are on the same machine.");
            }
        } else {
            this.hostName = this.calculateHostAddress();
        }
        if (n == null || n == 0) {
            this.assignFreePort(false);
        } else {
            this.port = n;
        }
        this.cacheManager = cacheManager;
        if (n2 == null || n2 < 200) {
            throw new IllegalArgumentException("socketTimoutMillis must be a reasonable value greater than 200ms");
        }
        this.socketTimeoutMillis = n2;
    }

    protected void assignFreePort(boolean bl) throws IllegalStateException {
        if (this.status != Status.STATUS_UNINITIALISED) {
            throw new IllegalStateException("Cannot change the port of an already started listener.");
        }
        this.port = new Integer(this.getFreePort());
        if (bl) {
            LOG.warn((Object)("Resolving RMI port conflict by automatically using a free TCP/IP port to listen on: " + this.port));
        } else {
            LOG.debug((Object)("Automatically finding a free TCP/IP port to listen on: " + this.port));
        }
    }

    protected String calculateHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    protected int getFreePort() throws IllegalArgumentException {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not acquire a free port number.");
        }
        finally {
            if (serverSocket != null && !serverSocket.isClosed()) {
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {
                    LOG.debug((Object)("Error closing ServerSocket: " + exception.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws CacheException {
        RMICachePeer rMICachePeer = null;
        try {
            this.startRegistry();
            int n = 0;
            this.populateListOfRemoteCachePeers();
            Map map = this.cachePeers;
            synchronized (map) {
                Iterator iterator = this.cachePeers.values().iterator();
                while (iterator.hasNext()) {
                    rMICachePeer = (RMICachePeer)iterator.next();
                    this.bind(rMICachePeer);
                    ++n;
                }
            }
            LOG.debug((Object)(n + " RMICachePeers bound in registry for RMI listener"));
            this.status = Status.STATUS_ALIVE;
        }
        catch (Exception exception) {
            String string = null;
            if (rMICachePeer != null) {
                string = rMICachePeer.getUrl();
            }
            throw new CacheException("Problem starting listener for RMICachePeer " + string + ". Initial cause was " + exception.getMessage(), exception);
        }
    }

    protected void bind(RMICachePeer rMICachePeer) throws Exception {
        Naming.rebind(rMICachePeer.getUrl(), rMICachePeer);
    }

    protected String[] listBoundRMICachePeers() throws CacheException {
        try {
            return this.registry.list();
        }
        catch (RemoteException remoteException) {
            throw new CacheException("Unable to list cache peers " + remoteException.getMessage());
        }
    }

    protected Remote lookupPeer(String string) throws CacheException {
        try {
            return this.registry.lookup(string);
        }
        catch (Exception exception) {
            throw new CacheException("Unable to lookup peer for replicated cache " + string + " " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateListOfRemoteCachePeers() throws RemoteException {
        String[] stringArray = this.cacheManager.getCacheNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Ehcache ehcache = this.cacheManager.getEhcache(string);
            Map map = this.cachePeers;
            synchronized (map) {
                if (this.cachePeers.get(string) == null && this.isDistributed(ehcache)) {
                    RMICachePeer rMICachePeer = new RMICachePeer(ehcache, this.hostName, this.port, this.socketTimeoutMillis);
                    this.cachePeers.put(string, rMICachePeer);
                }
                continue;
            }
        }
    }

    protected boolean isDistributed(Ehcache ehcache) {
        Set set = ehcache.getCacheEventNotificationService().getCacheEventListeners();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
            if (!(cacheEventListener instanceof CacheReplicator)) continue;
            return true;
        }
        return false;
    }

    protected void startRegistry() throws RemoteException {
        try {
            this.registry = LocateRegistry.getRegistry(this.port);
            try {
                this.registry.list();
            }
            catch (RemoteException remoteException) {
                this.registry = LocateRegistry.createRegistry(this.port);
            }
        }
        catch (ExportException exportException) {
            LOG.fatal((Object)("Exception starting RMI registry. Error was " + exportException.getMessage()), (Throwable)exportException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws CacheException {
        try {
            int n = 0;
            Map map = this.cachePeers;
            synchronized (map) {
                Iterator iterator = this.cachePeers.values().iterator();
                while (iterator.hasNext()) {
                    RMICachePeer rMICachePeer = (RMICachePeer)iterator.next();
                    this.disposeRMICachePeer(rMICachePeer);
                    ++n;
                }
            }
            LOG.debug((Object)(n + " RMICachePeers unbound from registry in RMI listener"));
            this.status = Status.STATUS_SHUTDOWN;
        }
        catch (Exception exception) {
            throw new CacheException("Problem unbinding remote cache peers. Initial cause was " + exception.getMessage(), exception);
        }
    }

    protected void disposeRMICachePeer(RMICachePeer rMICachePeer) throws Exception {
        this.unbind(rMICachePeer);
    }

    protected void unbind(RMICachePeer rMICachePeer) throws Exception {
        String string = rMICachePeer.getUrl();
        try {
            Naming.unbind(string);
        }
        catch (NotBoundException notBoundException) {
            LOG.warn((Object)(string + " not bound therefore not unbinding."));
        }
        boolean bl = UnicastRemoteObject.unexportObject(rMICachePeer, false);
        for (int i = 1; i < 10 && !bl; ++i) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            bl = UnicastRemoteObject.unexportObject(rMICachePeer, false);
        }
        if (!bl && !UnicastRemoteObject.unexportObject(rMICachePeer, true)) {
            LOG.warn((Object)("Unable to unexport rmiCachePeer: " + rMICachePeer.getUrl() + ".  Skipping."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBoundCachePeers() {
        ArrayList<RMICachePeer> arrayList = new ArrayList<RMICachePeer>();
        Map map = this.cachePeers;
        synchronized (map) {
            Iterator iterator = this.cachePeers.values().iterator();
            while (iterator.hasNext()) {
                RMICachePeer rMICachePeer = (RMICachePeer)iterator.next();
                arrayList.add(rMICachePeer);
            }
        }
        return arrayList;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getUniqueResourceIdentifier() {
        return "RMI listener port: " + this.port;
    }

    public void attemptResolutionOfUniqueResourceConflict() throws IllegalStateException, CacheException {
        this.assignFreePort(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCacheAdded(String string) throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding " + string + " to RMI listener"));
        }
        Object object = this.cachePeers;
        synchronized (object) {
            if (this.cachePeers.get(string) != null) {
                return;
            }
        }
        object = this.cacheManager.getEhcache(string);
        if (this.isDistributed((Ehcache)object)) {
            RMICachePeer rMICachePeer = null;
            String string2 = null;
            try {
                rMICachePeer = new RMICachePeer((Ehcache)object, this.hostName, this.port, this.socketTimeoutMillis);
                string2 = rMICachePeer.getUrl();
                this.bind(rMICachePeer);
            }
            catch (Exception exception) {
                throw new CacheException("Problem starting listener for RMICachePeer " + string2 + ". Initial cause was " + exception.getMessage(), exception);
            }
            Map map = this.cachePeers;
            synchronized (map) {
                this.cachePeers.put(string, rMICachePeer);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.cachePeers.size() + " RMICachePeers bound in registry for RMI listener"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCacheRemoved(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing " + string + " from RMI listener"));
        }
        Object object = this.cachePeers;
        synchronized (object) {
            if (this.cachePeers.get(string) == null) {
                return;
            }
        }
        Map map = this.cachePeers;
        synchronized (map) {
            object = (RMICachePeer)this.cachePeers.remove(string);
        }
        map = null;
        try {
            this.unbind((RMICachePeer)object);
        }
        catch (Exception exception) {
            throw new CacheException("Error removing Cache Peer " + (String)((Object)map) + " from listener. Message was: " + exception.getMessage(), exception);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.cachePeers.size() + " RMICachePeers bound in registry for RMI listener"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCachePeer(String string, RMICachePeer rMICachePeer) {
        Map map = this.cachePeers;
        synchronized (map) {
            this.cachePeers.put(string, rMICachePeer);
        }
    }
}

