/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.util.Properties;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.distribution.RMIBootstrapCacheLoader;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMIBootstrapCacheLoaderFactory
extends BootstrapCacheLoaderFactory {
    public static final String BOOTSTRAP_ASYNCHRONOUSLY = "bootstrapAsynchronously";
    public static final String MAXIMUM_CHUNK_SIZE_BYTES = "maximumChunkSizeBytes";
    protected static final int DEFAULT_MAXIMUM_CHUNK_SIZE_BYTES = 5000000;
    protected static final int ONE_HUNDRED_MB = 100000000;
    protected static final int FIVE_KB = 5000;
    private static final Log LOG = LogFactory.getLog((String)RMIBootstrapCacheLoaderFactory.class.getName());

    public BootstrapCacheLoader createBootstrapCacheLoader(Properties properties) {
        boolean bl = this.extractBootstrapAsynchronously(properties);
        int n = this.extractMaximumChunkSizeBytes(properties);
        return new RMIBootstrapCacheLoader(bl, n);
    }

    protected int extractMaximumChunkSizeBytes(Properties properties) {
        int n;
        block5: {
            n = 0;
            String string = PropertyUtil.extractAndLogProperty(MAXIMUM_CHUNK_SIZE_BYTES, properties);
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 < 5000 || n2 > 100000000) {
                        LOG.warn((Object)"Trying to set the chunk size to an unreasonable number. Using the default instead.");
                        n = 5000000;
                        break block5;
                    }
                    n = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.warn((Object)"Number format exception trying to set chunk size. Using the default instead.");
                    n = 5000000;
                }
            } else {
                n = 5000000;
            }
        }
        return n;
    }

    protected boolean extractBootstrapAsynchronously(Properties properties) {
        String string = PropertyUtil.extractAndLogProperty(BOOTSTRAP_ASYNCHRONOUSLY, properties);
        boolean bl = string != null ? PropertyUtil.parseBoolean(string) : true;
        return bl;
    }
}

