/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.RemoteCacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMIBootstrapCacheLoader
implements BootstrapCacheLoader {
    private static final int ONE_SECOND = 1000;
    private static final Log LOG = LogFactory.getLog((String)RMIBootstrapCacheLoader.class.getName());
    protected boolean asynchronous;
    protected int maximumChunkSizeBytes;

    public RMIBootstrapCacheLoader(boolean bl, int n) {
        this.asynchronous = bl;
        this.maximumChunkSizeBytes = n;
    }

    public void load(Ehcache ehcache) throws RemoteCacheException {
        if (this.asynchronous) {
            BootstrapThread bootstrapThread = new BootstrapThread(ehcache);
            bootstrapThread.start();
        } else {
            this.doLoad(ehcache);
        }
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void doLoad(Ehcache ehcache) throws RemoteCacheException {
        List list = this.acquireCachePeers(ehcache);
        if (list == null || list.size() == 0) {
            LOG.debug((Object)("Empty list of cache peers for cache " + ehcache.getName() + ". No cache peer to bootstrap from."));
            return;
        }
        Random random = new Random();
        int n = random.nextInt(list.size());
        CachePeer cachePeer = (CachePeer)list.get(n);
        LOG.debug((Object)("Bootstrapping " + ehcache.getName() + " from " + cachePeer));
        try {
            Element element = null;
            List list2 = cachePeer.getKeys();
            for (int i = 0; i < list2.size(); ++i) {
                Serializable serializable = (Serializable)list2.get(i);
                element = cachePeer.getQuiet((Serializable)list2.get(0));
                if (element != null) break;
            }
            if (element == null) {
                LOG.debug((Object)("All cache peer elements were null. Nothing to bootstrap from. Cache was " + ehcache.getName() + ". Cache peer was " + cachePeer));
                return;
            }
            long l = element.getSerializedSize();
            int n2 = (int)((long)this.maximumChunkSizeBytes / l);
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            for (int i = 0; i < list2.size(); ++i) {
                Serializable serializable = (Serializable)list2.get(i);
                arrayList.add(serializable);
                if (arrayList.size() != n2) continue;
                this.fetchAndPutElements(ehcache, arrayList, cachePeer);
                arrayList.clear();
            }
            this.fetchAndPutElements(ehcache, arrayList, cachePeer);
            LOG.debug((Object)("Bootstrapping " + ehcache.getName() + " from " + cachePeer + " finished. " + list2.size() + " keys requested."));
        }
        catch (Throwable throwable) {
            throw new RemoteCacheException("Error bootstrapping from remote peer. Message was: " + throwable.getMessage(), throwable);
        }
    }

    protected List acquireCachePeers(Ehcache ehcache) {
        long l = 0L;
        CacheManagerPeerProvider cacheManagerPeerProvider = ehcache.getCacheManager().getCacheManagerPeerProvider();
        if (cacheManagerPeerProvider != null) {
            l = cacheManagerPeerProvider.getTimeForClusterToForm();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to acquire cache peers for cache " + ehcache.getName() + " to bootstrap from. Will wait up to " + l + "ms for cache to join cluster."));
        }
        List list = null;
        int n = 0;
        while ((long)n <= l && (list = this.listRemoteCachePeers(ehcache)) != null && list.size() <= 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                LOG.debug((Object)("doLoad for " + ehcache.getName() + " interrupted."));
            }
            n += 1000;
        }
        return list;
    }

    protected void fetchAndPutElements(Ehcache ehcache, List list, CachePeer cachePeer) throws RemoteException {
        List list2 = cachePeer.getElements(list);
        for (int i = 0; i < list2.size(); ++i) {
            Element element = (Element)list2.get(i);
            ehcache.put(element, true);
        }
    }

    protected List listRemoteCachePeers(Ehcache ehcache) {
        CacheManagerPeerProvider cacheManagerPeerProvider = ehcache.getCacheManager().getCachePeerProvider();
        if (cacheManagerPeerProvider == null) {
            return null;
        }
        return cacheManagerPeerProvider.listRemoteCachePeers(ehcache);
    }

    public int getMaximumChunkSizeBytes() {
        return this.maximumChunkSizeBytes;
    }

    public Object clone() throws CloneNotSupportedException {
        return new RMIBootstrapCacheLoader(this.asynchronous, this.maximumChunkSizeBytes);
    }

    private final class BootstrapThread
    extends Thread {
        private Ehcache cache;

        public BootstrapThread(Ehcache ehcache) {
            super("Bootstrap Thread for cache " + ehcache.getName());
            this.cache = ehcache;
            this.setDaemon(true);
            this.setPriority(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                RMIBootstrapCacheLoader.this.doLoad(this.cache);
            }
            catch (RemoteCacheException remoteCacheException) {
                LOG.debug((Object)("Error asynchronously performing bootstrap. The cause was: " + remoteCacheException.getMessage()));
            }
            finally {
                this.cache = null;
            }
        }
    }
}

