/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.EventMessage;
import net.sf.ehcache.distribution.RMISynchronousCacheReplicator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMIAsynchronousCacheReplicator
extends RMISynchronousCacheReplicator {
    private static final Log LOG = LogFactory.getLog((String)RMIAsynchronousCacheReplicator.class.getName());
    protected Thread replicationThread = new ReplicationThread();
    protected int asynchronousReplicationInterval;
    protected final List replicationQueue = new LinkedList();

    public RMIAsynchronousCacheReplicator(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        super(bl, bl2, bl3, bl4);
        this.asynchronousReplicationInterval = n;
        this.status = Status.STATUS_ALIVE;
        this.replicationThread.start();
    }

    private void replicationThreadMain() {
        while (true) {
            if (this.alive() && this.replicationQueue != null && this.replicationQueue.size() == 0) {
                try {
                    Thread.sleep(this.asynchronousReplicationInterval);
                }
                catch (InterruptedException interruptedException) {
                    LOG.debug((Object)"Spool Thread interrupted.");
                    return;
                }
            }
            if (this.notAlive()) {
                return;
            }
            try {
                if (this.replicationQueue.size() == 0) continue;
                this.flushReplicationQueue();
                continue;
            }
            catch (Throwable throwable) {
                LOG.warn((Object)("Exception on flushing of replication queue: " + throwable.getMessage() + ". Continuing..."), throwable);
                continue;
            }
            break;
        }
    }

    public final void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicatePuts) {
            return;
        }
        if (!element.isSerializable()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Object with key " + element.getObjectKey() + " is not Serializable and cannot be replicated"));
            }
            return;
        }
        this.addToReplicationQueue(new CacheEventMessage(0, ehcache, element, null));
    }

    public final void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            if (!element.isSerializable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Object with key " + element.getObjectKey() + " is not Serializable and cannot be updated via copy"));
                }
                return;
            }
            this.addToReplicationQueue(new CacheEventMessage(0, ehcache, element, null));
        } else {
            if (!element.isKeySerializable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated."));
                }
                return;
            }
            this.addToReplicationQueue(new CacheEventMessage(1, ehcache, null, element.getKey()));
        }
    }

    public final void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        if (!element.isKeySerializable()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated."));
            }
            return;
        }
        this.addToReplicationQueue(new CacheEventMessage(1, ehcache, null, element.getKey()));
    }

    public void notifyRemoveAll(Ehcache ehcache) {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        this.addToReplicationQueue(new CacheEventMessage(3, ehcache, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToReplicationQueue(CacheEventMessage cacheEventMessage) {
        if (!this.replicationThread.isAlive()) {
            LOG.error((Object)"CacheEventMessages cannot be added to the replication queue because the replication thread has died.");
        } else {
            List list = this.replicationQueue;
            synchronized (list) {
                this.replicationQueue.add(cacheEventMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushReplicationQueue() {
        int n;
        Object object;
        ArrayList<CacheEventMessage> arrayList;
        Object object2 = this.replicationQueue;
        synchronized (object2) {
            if (this.replicationQueue.size() == 0) {
                return;
            }
            arrayList = new ArrayList<CacheEventMessage>(this.replicationQueue.size());
            for (int i = 0; i < this.replicationQueue.size(); ++i) {
                object = (CacheEventMessage)this.replicationQueue.get(i);
                arrayList.add((CacheEventMessage)object);
            }
            this.replicationQueue.clear();
        }
        object2 = ((CacheEventMessage)arrayList.get(0)).cache;
        List list = RMIAsynchronousCacheReplicator.listRemoteCachePeers((Ehcache)object2);
        object = RMIAsynchronousCacheReplicator.extractAndResolveEventMessages(arrayList);
        for (n = 0; n < list.size(); ++n) {
            CachePeer cachePeer = (CachePeer)list.get(n);
            try {
                cachePeer.send((List)object);
                continue;
            }
            catch (UnmarshalException unmarshalException) {
                String string = unmarshalException.getMessage();
                if (string.indexOf("Read time out") != 0) {
                    LOG.warn((Object)("Unable to send message to remote peer due to socket read timeout. Consider increasing the socketTimeoutMillis setting in the cacheManagerPeerListenerFactory. Message was: " + unmarshalException.getMessage()));
                    continue;
                }
                LOG.debug((Object)("Unable to send message to remote peer.  Message was: " + unmarshalException.getMessage()));
                continue;
            }
            catch (Throwable throwable) {
                LOG.debug((Object)("Unable to send message to remote peer.  Message was: " + throwable.getMessage()));
            }
        }
        if (LOG.isWarnEnabled() && (n = arrayList.size() - object.size()) > 0) {
            LOG.warn((Object)(n + " messages were discarded on replicate due to reclamation of " + "SoftReferences by the VM. Consider increasing the maximum heap size and/or setting the " + "starting heap size to a higher value."));
        }
    }

    private static List extractAndResolveEventMessages(List list) {
        ArrayList<EventMessage> arrayList = new ArrayList<EventMessage>();
        for (int i = 0; i < list.size(); ++i) {
            EventMessage eventMessage = ((CacheEventMessage)list.get(i)).getEventMessage();
            if (eventMessage == null || !eventMessage.isValid()) continue;
            arrayList.add(eventMessage);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
        List list = this.replicationQueue;
        synchronized (list) {
            this.replicationQueue.clear();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new RMIAsynchronousCacheReplicator(this.replicatePuts, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals, this.asynchronousReplicationInterval);
    }

    private static final class CacheEventMessage {
        private final Ehcache cache;
        private final EventMessage eventMessage;

        public CacheEventMessage(int n, Ehcache ehcache, Element element, Serializable serializable) {
            this.eventMessage = new EventMessage(n, serializable, element);
            this.cache = ehcache;
        }

        public final EventMessage getEventMessage() {
            return this.eventMessage;
        }
    }

    private final class ReplicationThread
    extends Thread {
        public ReplicationThread() {
            super("Replication Thread");
            this.setDaemon(true);
            this.setPriority(2);
        }

        public final void run() {
            RMIAsynchronousCacheReplicator.this.replicationThreadMain();
        }
    }
}

