/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.ehcache.distribution.CachePeer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class PayloadUtil {
    public static final int MTU = 1500;
    public static final String URL_DELIMITER = "|";
    private static final Log LOG = LogFactory.getLog((String)PayloadUtil.class.getName());

    private PayloadUtil() {
    }

    public static byte[] assembleUrlList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            CachePeer cachePeer = (CachePeer)list.get(i);
            String string = null;
            try {
                string = cachePeer.getUrl();
            }
            catch (RemoteException remoteException) {
                LOG.error((Object)"This should never be thrown as it is called locally");
            }
            if (i != list.size() - 1) {
                stringBuffer.append(string).append(URL_DELIMITER);
                continue;
            }
            stringBuffer.append(string);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cache peers: " + stringBuffer));
        }
        return stringBuffer.toString().getBytes();
    }

    public static byte[] gzip(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            LOG.fatal((Object)("Could not gzip " + byArray));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ungzip(byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            byte[] byArray3 = new byte[1500];
            int n = 0;
            while (n != -1) {
                n = gZIPInputStream.read(byArray3, 0, 1500);
                if (n == -1) continue;
                byteArrayOutputStream.write(byArray3, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
            gZIPInputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            LOG.fatal((Object)("Could not ungzip. Heartbeat will not be working. " + iOException.getMessage()));
        }
        return byArray2;
    }
}

