/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.MulticastKeepaliveHeartbeatReceiver;
import net.sf.ehcache.distribution.MulticastKeepaliveHeartbeatSender;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MulticastRMICacheManagerPeerProvider
extends RMICacheManagerPeerProvider
implements CacheManagerPeerProvider {
    protected static final int SHORT_DELAY = 100;
    private static final Log LOG = LogFactory.getLog((String)MulticastRMICacheManagerPeerProvider.class.getName());
    private final MulticastKeepaliveHeartbeatReceiver heartBeatReceiver;
    private final MulticastKeepaliveHeartbeatSender heartBeatSender;

    public MulticastRMICacheManagerPeerProvider(CacheManager cacheManager, InetAddress inetAddress, Integer n, Integer n2) {
        super(cacheManager);
        this.heartBeatReceiver = new MulticastKeepaliveHeartbeatReceiver(this, inetAddress, n);
        this.heartBeatSender = new MulticastKeepaliveHeartbeatSender(cacheManager, inetAddress, n, n2);
    }

    public final void init() throws CacheException {
        try {
            this.heartBeatReceiver.init();
            this.heartBeatSender.init();
        }
        catch (IOException iOException) {
            LOG.error((Object)("Error starting heartbeat. Error was: " + iOException.getMessage()), (Throwable)iOException);
            throw new CacheException(iOException.getMessage());
        }
    }

    public final synchronized void registerPeer(String string) {
        try {
            CachePeerEntry cachePeerEntry = (CachePeerEntry)this.peerUrls.get(string);
            if (cachePeerEntry == null) {
                CachePeer cachePeer = this.lookupRemoteCachePeer(string);
                cachePeerEntry = new CachePeerEntry(cachePeer, new Date());
                this.peerUrls.put(string, cachePeerEntry);
            } else {
                cachePeerEntry.date = new Date();
            }
        }
        catch (IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to lookup remote cache peer for " + string + ". Removing from peer list. Cause was: " + iOException.getMessage()));
            }
            this.peerUrls.remove(string);
        }
        catch (NotBoundException notBoundException) {
            this.peerUrls.remove(string);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to lookup remote cache peer for " + string + ". Removing from peer list. Cause was: " + notBoundException.getMessage()));
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)("Unable to lookup remote cache peer for " + string + ". Cause was not due to an IOException or NotBoundException which will occur in normal operation:" + " " + throwable.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List listRemoteCachePeers(Ehcache ehcache) throws CacheException {
        ArrayList<CachePeer> arrayList = new ArrayList<CachePeer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Map map = this.peerUrls;
        synchronized (map) {
            String string;
            Iterator iterator = this.peerUrls.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                String string2 = MulticastRMICacheManagerPeerProvider.extractCacheName(string);
                try {
                    if (!string2.equals(ehcache.getName())) continue;
                    CachePeerEntry cachePeerEntry = (CachePeerEntry)this.peerUrls.get(string);
                    Date date = cachePeerEntry.date;
                    if (!this.stale(date)) {
                        CachePeer cachePeer = cachePeerEntry.cachePeer;
                        arrayList.add(cachePeer);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("rmiUrl " + string + " is stale. Either the remote peer is shutdown or the " + "network connectivity has been interrupted. Will be removed from list of remote cache peers"));
                    }
                    arrayList2.add(string);
                }
                catch (Exception exception) {
                    LOG.error((Object)exception.getMessage(), (Throwable)exception);
                    throw new CacheException("Unable to list remote cache peers. Error was " + exception.getMessage());
                }
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                string = (String)arrayList2.get(i);
                this.peerUrls.remove(string);
            }
        }
        return arrayList;
    }

    public final void dispose() {
        this.heartBeatSender.dispose();
        this.heartBeatReceiver.dispose();
    }

    public long getTimeForClusterToForm() {
        return this.getStaleTime();
    }

    protected long getStaleTime() {
        return MulticastKeepaliveHeartbeatSender.getHeartBeatInterval() * 2L + 100L;
    }

    protected final boolean stale(Date date) {
        long l = System.currentTimeMillis();
        return date.getTime() < l - this.getStaleTime();
    }

    public MulticastKeepaliveHeartbeatReceiver getHeartBeatReceiver() {
        return this.heartBeatReceiver;
    }

    public MulticastKeepaliveHeartbeatSender getHeartBeatSender() {
        return this.heartBeatSender;
    }

    protected static final class CachePeerEntry {
        private final CachePeer cachePeer;
        private Date date;

        public CachePeerEntry(CachePeer cachePeer, Date date) {
            this.cachePeer = cachePeer;
            this.date = date;
        }

        public final CachePeer getCachePeer() {
            return this.cachePeer;
        }

        public final Date getDate() {
            return this.date;
        }
    }
}

